/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.hints.BeanReferenceProvider;
import com.intellij.spring.boot.application.config.hints.DurationReferenceProvider;
import com.intellij.spring.boot.application.config.hints.EncodingReferenceProvider;
import com.intellij.spring.boot.application.config.hints.EnumReferenceProvider;
import com.intellij.spring.boot.application.config.hints.FloatReferenceProvider;
import com.intellij.spring.boot.application.config.hints.IntegerReferenceProvider;
import com.intellij.spring.boot.application.config.hints.LoggerNameReferenceProvider;
import com.intellij.spring.boot.application.config.hints.LongReferenceProvider;
import com.intellij.spring.boot.application.config.hints.MultiStaticValuesReferenceProvider;
import com.intellij.spring.boot.application.config.hints.RegExReferenceProvider;
import com.intellij.spring.boot.application.config.hints.ResourceReferenceProvider;
import com.intellij.spring.boot.application.config.hints.SpringBootHintRegistryInfo;
import com.intellij.spring.boot.application.config.hints.SpringBootHintRegistryKey;
import com.intellij.spring.boot.application.config.hints.StaticValuesReferenceProvider;
import com.intellij.spring.boot.application.config.hints.ValueHintReferenceProvider;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathReferenceSet;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootValueProvider;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.converters.PatternFileReferenceSet;
import com.intellij.spring.profiles.SpringProfilesReferenceProvider;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xml.util.HtmlUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootHintReferencesProviderImpl
extends SpringBootHintReferencesProvider {
    private static final String STATIC = "static";
    private static final String ENUM_VALUES = "enumValues";
    private static final String REGEX = "regex";
    private static final String RESOURCE = "resource";
    private static final String PATH_PATTERN = "pathPattern";
    private static final String SPRING_PROFILE_NAME = SpringBootValueProvider.SPRING_PROFILE_NAME.getId();
    private final PsiReferenceProvider myDummyProvider = new PsiReferenceProvider(){

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (context == null) {
                1.$$$reportNull$$$0(1);
            }
            if (PsiReference.EMPTY_ARRAY == null) {
                1.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final StaticValuesReferenceProvider myLocaleProvider = new StaticValuesReferenceProvider(true, true, null, (String[])ContainerUtil.map2Array((Object[])Locale.getAvailableLocales(), String.class, locale -> {
        String country = locale.getCountry();
        String language = locale.getLanguage();
        return country.isEmpty() ? language : language + "_" + country;
    }));
    private final StaticValuesReferenceProvider myContentTypeProvider = new StaticValuesReferenceProvider(true, true, null, HtmlUtil.CONTENT_TYPES);
    private final StaticValuesReferenceProvider myContentTypeMultiValueProvider = new MultiStaticValuesReferenceProvider(true, true, HtmlUtil.CONTENT_TYPES);
    private final EncodingReferenceProvider myEncodingProvider = new EncodingReferenceProvider();
    private final SpringProfilesReferenceProvider mySpringProfileProvider = new SpringProfilesReferenceProvider(){

        protected String getStringValue(PsiElement element) {
            return ElementManipulators.getValueText((PsiElement)element);
        }

        protected boolean isDefinition() {
            return false;
        }
    };
    private final Map<String, String> myExplicitMappings = new THashMap();
    private final Map<String, PsiReferenceProvider> myExplicitProviders = new THashMap();
    private final Map<String, PsiReferenceProvider> myBuiltinProviders = new THashMap();
    private final Set<String> myOverrideKeys = new THashSet();
    private final Map<String, PsiReferenceProvider> myByTypeProviders = ContainerUtil.immutableMapBuilder().put((Object)"java.lang.Boolean", (Object)new StaticValuesReferenceProvider(false, false, DefaultLanguageHighlighterColors.KEYWORD, "true", "false")).put((Object)"java.lang.Integer", (Object)new IntegerReferenceProvider()).put((Object)"java.lang.Long", (Object)new LongReferenceProvider()).put((Object)"java.lang.Float", (Object)new FloatReferenceProvider()).put((Object)"java.nio.charset.Charset", (Object)this.myEncodingProvider).put((Object)"org.springframework.util.MimeType", (Object)this.myContentTypeProvider).put((Object)"org.springframework.core.io.Resource", (Object)new ResourceReferenceProvider()).put((Object)"java.util.Locale", (Object)this.myLocaleProvider).put((Object)"java.time.Duration", (Object)new DurationReferenceProvider()).build();

    protected SpringBootHintReferencesProviderImpl() {
        this.myBuiltinProviders.put(SPRING_PROFILE_NAME, (PsiReferenceProvider)this.mySpringProfileProvider);
        this.myBuiltinProviders.put(RESOURCE, new ResourceReferenceProvider());
        this.myBuiltinProviders.put(PATH_PATTERN, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                FileReference[] fileReferenceArray = new PatternFileReferenceSet(ElementManipulators.getValueText((PsiElement)element), element, 0).getAllReferences();
                if (fileReferenceArray == null) {
                    3.$$$reportNull$$$0(2);
                }
                return fileReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.loadExplicitMappings();
    }

    private void loadExplicitMappings() {
        URL url = SpringBootHintReferencesProviderImpl.class.getResource("spring-boot-hint-registry.xml");
        SpringBootHintRegistryInfo info = (SpringBootHintRegistryInfo)XmlSerializer.deserialize((URL)url, SpringBootHintRegistryInfo.class);
        for (SpringBootHintRegistryKey key : ((SpringBootHintRegistryInfo)ObjectUtils.assertNotNull((Object)info)).myKeys) {
            String providerId = key.myProvider;
            if (key.myOverride) {
                this.myOverrideKeys.add(key.myId);
            }
            if (providerId.equals(STATIC) || providerId.equals(ENUM_VALUES)) {
                this.myExplicitProviders.put(key.myId, SpringBootHintReferencesProviderImpl.createStaticOrEnumReferenceProvider(key));
                continue;
            }
            if (providerId.equals(SpringBootValueProvider.SPRING_BEAN_REFERENCE.getId())) {
                this.myExplicitProviders.put(key.myId, SpringBootHintReferencesProviderImpl.createBeanReferenceProvider(key.myValue));
                continue;
            }
            if (providerId.equals(SpringBootValueProvider.CLASS_REFERENCE.getId())) {
                this.myExplicitProviders.put(key.myId, (PsiReferenceProvider)SpringBootHintReferencesProviderImpl.createClassReferenceProvider(key.myValue, key.myAllowOtherValues, true));
                continue;
            }
            if (providerId.equals(REGEX)) {
                this.myExplicitProviders.put(key.myId, new RegExReferenceProvider(key.myValue));
                continue;
            }
            if (providerId.equals(RESOURCE) || providerId.equals(PATH_PATTERN) || providerId.equals(SPRING_PROFILE_NAME)) {
                this.myExplicitMappings.put(key.myId, providerId);
                continue;
            }
            throw new IllegalArgumentException(providerId);
        }
    }

    @NotNull
    public PsiReference[] getKeyReferences(Module module, SpringBootApplicationMetaConfigKey configKey, PsiElement keyPsiElement, ProcessingContext context) {
        if (configKey.getKeyItemHint() != SpringBootApplicationMetaConfigKey.ItemHint.NONE) {
            PsiReference[] psiReferenceArray = this.getItemHintReferences(configKey, ItemHintType.KEY, keyPsiElement, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    public PsiReference[] getValueReferences(Module module, SpringBootApplicationMetaConfigKey configKey, @Nullable PsiElement keyPsiElement, PsiElement valuePsiElement, ProcessingContext context) {
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            PsiReference[] psiReferenceArray = this.getFallbackProvider(configKey).getReferencesByElement(valuePsiElement, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (configKey.getItemHint() != SpringBootApplicationMetaConfigKey.ItemHint.NONE) {
            PsiReference[] psiReferenceArray = this.getItemHintReferences(configKey, ItemHintType.VALUE, valuePsiElement, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        PsiReferenceProvider byTypeOrExplicitProvider = this.getByTypeOrExplicitProvider(configKey);
        if (byTypeOrExplicitProvider != this.myDummyProvider) {
            PsiReference[] psiReferenceArray = byTypeOrExplicitProvider.getReferencesByElement(valuePsiElement, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (keyPsiElement == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] overrideOtherReferences = new PsiReference[]{PsiReferenceBase.createSelfReference((PsiElement)valuePsiElement, (PsiElement)valuePsiElement)};
        if (!MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION.value((Object)configKey)) {
            if (overrideOtherReferences == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(6);
            }
            return overrideOtherReferences;
        }
        PsiReferenceProvider pojoReferenceProvider = this.getPojoValueProvider(configKey, keyPsiElement);
        if (pojoReferenceProvider != null) {
            PsiReference[] psiReferenceArray = pojoReferenceProvider.getReferencesByElement(valuePsiElement, context);
            if (psiReferenceArray == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(7);
            }
            return psiReferenceArray;
        }
        if (overrideOtherReferences == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(8);
        }
        return overrideOtherReferences;
    }

    @Nullable
    private PsiReferenceProvider getPojoValueProvider(SpringBootApplicationMetaConfigKey configKey, @NotNull PsiElement keyPsiElement) {
        PsiReference lastReference;
        if (keyPsiElement == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(9);
        }
        if (!((lastReference = (PsiReference)ArrayUtil.getLastElement((Object[])keyPsiElement.getReferences())) instanceof ConfigKeyPathReferenceSet.Reference)) {
            return null;
        }
        ConfigKeyPathReferenceSet.Reference reference = (ConfigKeyPathReferenceSet.Reference)lastReference;
        if (reference.getPathType() != ConfigKeyPathReferenceSet.Reference.PathType.BEAN_PROPERTY) {
            return null;
        }
        PsiElement resolve = reference.resolve();
        if (!(resolve instanceof BeanPropertyElement)) {
            return null;
        }
        PsiType type = ((BeanPropertyElement)resolve).getPropertyType();
        if (type instanceof PsiPrimitiveType) {
            type = ((PsiPrimitiveType)type).getBoxedType(keyPsiElement);
        }
        return this.getByTypeProvider(configKey, PsiTypesUtil.getPsiClass((PsiType)type));
    }

    @NotNull
    private PsiReferenceProvider getByTypeOrExplicitProvider(SpringBootApplicationMetaConfigKey configKey) {
        PsiReferenceProvider byTypeProvider = this.getByTypeProvider(configKey);
        if (byTypeProvider != null) {
            PsiReferenceProvider psiReferenceProvider = byTypeProvider;
            if (psiReferenceProvider == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(10);
            }
            return psiReferenceProvider;
        }
        PsiReferenceProvider explicitValuesProvider = this.getExplicitProvider(configKey, true);
        if (explicitValuesProvider != null) {
            PsiReferenceProvider psiReferenceProvider = explicitValuesProvider;
            if (psiReferenceProvider == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(11);
            }
            return psiReferenceProvider;
        }
        PsiReferenceProvider psiReferenceProvider = this.myDummyProvider;
        if (psiReferenceProvider == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(12);
        }
        return psiReferenceProvider;
    }

    @NotNull
    private PsiReference[] getItemHintReferences(SpringBootApplicationMetaConfigKey configKey, ItemHintType itemHintType, PsiElement element, ProcessingContext context) {
        List<PsiReferenceProvider> providers = this.getItemHintProviders(element, configKey, itemHintType);
        if (providers.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(13);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] allReferences = PsiReference.EMPTY_ARRAY;
        for (PsiReferenceProvider provider : providers) {
            allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])provider.getReferencesByElement(element, context), (ArrayFactory)PsiReference.ARRAY_FACTORY);
        }
        if (allReferences == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(14);
        }
        return allReferences;
    }

    private List<PsiReferenceProvider> getItemHintProviders(PsiElement element, SpringBootApplicationMetaConfigKey configKey, ItemHintType itemHintType) {
        SpringBootApplicationMetaConfigKey.ItemHint keyOrValueHint = itemHintType == ItemHintType.VALUE ? configKey.getItemHint() : configKey.getKeyItemHint();
        String prefix = itemHintType == ItemHintType.VALUE ? "" : configKey.getName() + ".";
        List valueProviders = keyOrValueHint.getValueProviders();
        boolean hasAnyProvider = ContainerUtil.exists((Iterable)valueProviders, provider -> {
            SpringBootValueProvider byId = SpringBootValueProvider.findById(provider.getName());
            return byId == SpringBootValueProvider.ANY;
        });
        SmartList providers = new SmartList();
        List valueHints = keyOrValueHint.getValueHints();
        if (!valueHints.isEmpty()) {
            providers.add(new ValueHintReferenceProvider(configKey, valueHints, prefix, hasAnyProvider));
        }
        if (valueProviders.isEmpty()) {
            return providers;
        }
        SpringBootValueProvider valueProvider = null;
        Map parameters = null;
        for (SpringBootApplicationMetaConfigKey.ValueProvider provider2 : valueProviders) {
            valueProvider = SpringBootValueProvider.findById(provider2.getName());
            if (valueProvider == null) continue;
            parameters = provider2.getParameters();
            break;
        }
        if (valueProvider == null) {
            return providers;
        }
        if (itemHintType == ItemHintType.VALUE) {
            String target;
            if (valueProvider == SpringBootValueProvider.CLASS_REFERENCE) {
                target = (String)parameters.get("target");
                String concreteParameter = (String)parameters.get("concrete");
                Boolean concrete = concreteParameter == null ? Boolean.TRUE : Boolean.valueOf(concreteParameter);
                providers.add(SpringBootHintReferencesProviderImpl.createClassReferenceProvider(target, false, concrete));
            } else if (valueProvider == SpringBootValueProvider.SPRING_PROFILE_NAME) {
                providers.add(this.mySpringProfileProvider);
            } else if (valueProvider == SpringBootValueProvider.SPRING_BEAN_REFERENCE) {
                target = (String)parameters.get("target");
                providers.add(SpringBootHintReferencesProviderImpl.createBeanReferenceProvider(target));
            } else if (valueProvider == SpringBootValueProvider.HANDLE_AS && parameters.containsKey("target")) {
                target = (String)parameters.get("target");
                PsiReferenceProvider byTypeProvider = this.myByTypeProviders.get(target);
                if (byTypeProvider != null) {
                    providers.add(byTypeProvider);
                } else {
                    Project project = element.getProject();
                    PsiClass enumClass = JavaPsiFacade.getInstance((Project)project).findClass(target, element.getResolveScope());
                    if (enumClass != null && enumClass.isEnum()) {
                        providers.add(new EnumReferenceProvider(enumClass));
                    }
                }
            }
        }
        if (valueProvider == SpringBootValueProvider.LOGGER_NAME) {
            providers.add(new LoggerNameReferenceProvider(prefix));
        }
        return providers;
    }

    @Nullable
    private PsiReferenceProvider getByTypeProvider(SpringBootApplicationMetaConfigKey configKey) {
        PsiClass typeClass = configKey.getEffectiveValueClass();
        return this.getByTypeProvider(configKey, typeClass);
    }

    @Nullable
    private PsiReferenceProvider getByTypeProvider(SpringBootApplicationMetaConfigKey configKey, @Nullable PsiClass typeClass) {
        if (typeClass == null) {
            return null;
        }
        if (typeClass.isEnum()) {
            return new EnumReferenceProvider(typeClass);
        }
        String typeFqn = typeClass.getQualifiedName();
        if (typeFqn == null) {
            return null;
        }
        if ("java.lang.Class".equals(typeFqn)) {
            PsiType type = configKey.getType();
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiType[] parameters = ((PsiClassType)type).getParameters();
            if (parameters.length != 1) {
                return null;
            }
            PsiType typeParameter = parameters[0];
            if (!(typeParameter instanceof PsiWildcardType)) {
                return null;
            }
            PsiWildcardType parameter = (PsiWildcardType)typeParameter;
            return SpringBootHintReferencesProviderImpl.createClassReferenceProvider(parameter.getExtendsBound().getCanonicalText(), false, Boolean.TRUE);
        }
        return this.myByTypeProviders.get(typeFqn);
    }

    @Nullable
    private PsiReferenceProvider getExplicitProvider(SpringBootApplicationMetaConfigKey configKey, boolean isSpringBoot13OrHigher) {
        String configKeyName = configKey.getName();
        if (isSpringBoot13OrHigher && !this.myOverrideKeys.contains(configKeyName)) {
            return null;
        }
        PsiReferenceProvider byKey = this.myExplicitProviders.get(configKeyName);
        if (byKey != null) {
            return byKey;
        }
        String explicitProviderId = this.myExplicitMappings.get(configKeyName);
        if (explicitProviderId == null) {
            return null;
        }
        PsiReferenceProvider provider = this.myBuiltinProviders.get(explicitProviderId);
        if (provider == null) {
            throw new IllegalStateException("provider id '" + explicitProviderId + "' not found, configured for " + configKey);
        }
        return provider;
    }

    private PsiReferenceProvider getFallbackProvider(SpringBootApplicationMetaConfigKey configKey) {
        PsiReferenceProvider byTypeProvider = this.getByTypeProvider(configKey);
        if (byTypeProvider != null) {
            return byTypeProvider;
        }
        PsiReferenceProvider explicitReferenceProvider = this.getExplicitProvider(configKey, false);
        if (explicitReferenceProvider != null) {
            return explicitReferenceProvider;
        }
        String configKeyName = configKey.getName();
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"encoding") || StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"charset")) {
            return this.myEncodingProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"content-type")) {
            return this.myContentTypeProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"mime-types")) {
            return this.myContentTypeMultiValueProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"locale")) {
            return this.myLocaleProvider;
        }
        return this.myDummyProvider;
    }

    private static PsiReferenceProvider createStaticOrEnumReferenceProvider(SpringBootHintRegistryKey key) {
        String[] values = (String[])ContainerUtil.map2Array((Collection)StringUtil.split((String)key.myValue, (String)","), String.class, (Function)StringUtil.TRIMMER);
        return new StaticValuesReferenceProvider(key.myAllowOtherValues, key.myProvider.equals(ENUM_VALUES), null, values);
    }

    @NotNull
    private static JavaClassReferenceProvider createClassReferenceProvider(String baseClass, boolean allowOtherValues, Boolean concrete) {
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
        if (StringUtil.isNotEmpty((String)baseClass)) {
            provider.setOption(JavaClassReferenceProvider.EXTEND_CLASS_NAMES, (Object)new String[]{baseClass});
        }
        if (allowOtherValues) {
            provider.setSoft(true);
        }
        if (concrete.booleanValue()) {
            provider.setOption(JavaClassReferenceProvider.CONCRETE, (Object)Boolean.TRUE);
        }
        provider.setOption(JavaClassReferenceProvider.RESOLVE_QUALIFIED_CLASS_NAME, (Object)Boolean.TRUE);
        provider.setOption(JavaClassReferenceProvider.ADVANCED_RESOLVE, (Object)Boolean.TRUE);
        JavaClassReferenceProvider javaClassReferenceProvider = provider;
        if (javaClassReferenceProvider == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(15);
        }
        return javaClassReferenceProvider;
    }

    @NotNull
    private static PsiReferenceProvider createBeanReferenceProvider(@Nullable String baseClass) {
        BeanReferenceProvider beanReferenceProvider = new BeanReferenceProvider(baseClass);
        if (beanReferenceProvider == null) {
            SpringBootHintReferencesProviderImpl.$$$reportNull$$$0(16);
        }
        return beanReferenceProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyReferences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getByTypeOrExplicitProvider";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemHintReferences";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassReferenceProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createBeanReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPojoValueProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ItemHintType {
        VALUE,
        KEY;

    }
}

