/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.facet;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.ui.CheckboxTreeAdapter;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.config.ConfigFileSearcher;
import com.intellij.xml.config.ConfigFilesTreeBuilder;
import icons.SpringBootApiIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootCustomizationDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JPanel myTreePanel;
    private JPanel myTextFieldPanel;
    private JBLabel myKeyLabel;
    private JPanel myConfigurationPanel;
    private TextFieldWithAutoCompletion<SpringConfigNameProposal> mySpringConfigNameTextField;
    private final Project myProject;
    private final SpringFileSet myFileSet;
    private final SpringBootModelConfigFileNameContributor myFileNameContributor;
    private CheckboxTreeBase myFilesTree;
    private ConfigFilesTreeBuilder myFilesTreeBuilder;
    private Set<PsiFile> myPsiFiles;
    private boolean foundConfigFilesByName;
    private List<VirtualFile> myCustomConfigFiles;
    private Module myModule;

    public SpringBootCustomizationDialog(Project project, SpringFileSet fileSet, SpringBootModelConfigFileNameContributor fileNameContributor) {
        super(project);
        this.$$$setupUI$$$();
        this.myPsiFiles = new HashSet<PsiFile>();
        this.myCustomConfigFiles = new ArrayList<VirtualFile>();
        this.myProject = project;
        this.myFileSet = fileSet;
        this.myFileNameContributor = fileNameContributor;
        this.myModule = fileSet.getFacet().getModule();
        this.setTitle("Spring Boot Context '" + this.myFileSet.getName() + "'");
        this.initUI();
        this.init();
    }

    protected void doOKAction() {
        CustomSetting.STRING configFileNameSetting = this.getConfigFileNameSetting();
        String configFileName = this.getConfigFileName();
        if (StringUtil.isEmpty((String)configFileName)) {
            configFileNameSetting.clear();
        } else {
            configFileNameSetting.setStringValue(configFileName);
        }
        CustomSetting.STRING customConfigFilesSetting = this.getCustomConfigFilesSetting();
        if (!this.myCustomConfigFiles.isEmpty()) {
            customConfigFilesSetting.setStringValue(StringUtil.join(this.myCustomConfigFiles, file -> file.getUrl(), (String)";"));
        } else {
            customConfigFilesSetting.clear();
        }
        super.doOKAction();
    }

    @NotNull
    private CustomSetting.STRING getConfigFileNameSetting() {
        CustomSetting.STRING sTRING = this.getCustomSetting((Key<CustomSetting.STRING>)this.myFileNameContributor.getCustomNameSettingDescriptor().key);
        if (sTRING == null) {
            SpringBootCustomizationDialog.$$$reportNull$$$0(0);
        }
        return sTRING;
    }

    @NotNull
    private CustomSetting.STRING getCustomConfigFilesSetting() {
        CustomSetting.STRING sTRING = this.getCustomSetting((Key<CustomSetting.STRING>)this.myFileNameContributor.getCustomFilesSettingDescriptor().key);
        if (sTRING == null) {
            SpringBootCustomizationDialog.$$$reportNull$$$0(1);
        }
        return sTRING;
    }

    @NotNull
    private CustomSetting.STRING getCustomSetting(Key<CustomSetting.STRING> id) {
        CustomSetting.STRING setting = (CustomSetting.STRING)this.myFileSet.getFacet().findSetting(id);
        assert (setting != null);
        CustomSetting.STRING sTRING = setting;
        if (sTRING == null) {
            SpringBootCustomizationDialog.$$$reportNull$$$0(2);
        }
        return sTRING;
    }

    protected boolean postponeValidation() {
        return false;
    }

    private void initUI() {
        SpringBootModelConfigFileNameContributor.CustomizationPresentation presentation = this.myFileNameContributor.getCustomizationPresentation();
        this.myConfigurationPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)presentation.customizationPanelTitle, (boolean)false));
        this.myKeyLabel.setText(String.format("<html><code>%s</code>:</html>", presentation.configFileKey));
        this.mySpringConfigNameTextField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new SpringConfigNameAutoCompletionListProvider(this.getSpringConfigNameProposals()), true, null);
        this.myTextFieldPanel.add((Component)this.mySpringConfigNameTextField);
        CustomSetting.STRING configFileNameSetting = this.getConfigFileNameSetting();
        if (!Comparing.equal((String)configFileNameSetting.getStringValue(), (String)configFileNameSetting.getDefaultValue())) {
            this.mySpringConfigNameTextField.setText(configFileNameSetting.getStringValue());
        }
        this.mySpringConfigNameTextField.setPlaceholder((CharSequence)("(not set, using default '" + configFileNameSetting.getDefaultValue() + "')"));
        this.mySpringConfigNameTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                SpringBootCustomizationDialog.this.updateTree();
            }
        });
        CustomSetting.STRING customConfigFilesSetting = this.getCustomConfigFilesSetting();
        String urls = customConfigFilesSetting.getStringValue();
        if (urls != null) {
            for (String url : StringUtil.split((String)urls, (String)";")) {
                VirtualFile customConfigFile = VirtualFileManager.getInstance().findFileByUrl(url);
                ContainerUtil.addIfNotNull(this.myCustomConfigFiles, (Object)customConfigFile);
            }
        }
        this.myFilesTree = new CheckboxTreeBase(new CheckboxTreeBase.CheckboxTreeCellRendererBase(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                ConfigFilesTreeBuilder.renderNode((Object)value, (boolean)expanded, (ColoredTreeCellRenderer)this.getTextRenderer());
                if (!(value instanceof DefaultMutableTreeNode)) {
                    return;
                }
                Object object = ((DefaultMutableTreeNode)value).getUserObject();
                if (object instanceof PsiFile) {
                    this.getTextRenderer().setIcon(SpringBootApiIcons.SpringBoot);
                } else if (object instanceof FileType) {
                    this.getTextRenderer().setIcon((Icon)new LayeredIcon(new Icon[]{AllIcons.Nodes.Folder, SpringBootApiIcons.SpringBoot_Overlay}));
                }
            }
        }, null, new CheckboxTreeBase.CheckPolicy(false, false, true, true)){

            protected boolean shouldShowBusyIconIfNeeded() {
                return true;
            }
        };
        ConfigFilesTreeBuilder.installSearch((JTree)this.myFilesTree);
        this.myFilesTreeBuilder = new ConfigFilesTreeBuilder((JTree)this.myFilesTree){

            protected DefaultMutableTreeNode createFileNode(Object file) {
                CheckedTreeNode node = new CheckedTreeNode(file);
                if (file instanceof PsiFile) {
                    node.setChecked(true);
                    node.setEnabled(SpringBootCustomizationDialog.this.myCustomConfigFiles.contains(((PsiFile)file).getVirtualFile()));
                } else {
                    node.setChecked(false);
                    node.setEnabled(false);
                }
                return node;
            }
        };
        this.myFilesTree.addCheckboxTreeListener((CheckboxTreeListener)new CheckboxTreeAdapter(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                Object userObject;
                if (node == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((userObject = node.getUserObject()) instanceof PsiFile) {
                    VirtualFile configFile = ((PsiFile)userObject).getVirtualFile();
                    if (node.isChecked()) {
                        SpringBootCustomizationDialog.this.myCustomConfigFiles.add(configFile);
                    } else {
                        SpringBootCustomizationDialog.this.myCustomConfigFiles.remove(configFile);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$5", "nodeStateChanged"));
            }
        });
        this.myFilesTree.setRootVisible(false);
        this.myFilesTree.setShowsRootHandles(true);
        this.updateTree();
        JPanel panel = ToolbarDecorator.createDecorator((JTree)this.myFilesTree).setAddAction(button -> this.addCustomFiles()).setAddActionName("Add custom configuration files").createPanel();
        this.myTreePanel.add(panel);
    }

    private List<SpringConfigNameProposal> getSpringConfigNameProposals() {
        ArrayList<SpringConfigNameProposal> results = new ArrayList<SpringConfigNameProposal>();
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            GlobalSearchScope searchScope = contributor.getConfigFileSearchScope(this.myModule, false);
            if (searchScope == null) continue;
            FileType fileType = contributor.getFileType();
            Collection allFiles = FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)searchScope);
            for (VirtualFile file : allFiles) {
                String nameWithoutExtension = file.getNameWithoutExtension();
                if (StringUtil.containsChar((String)nameWithoutExtension, (char)'-') || "application".equals(nameWithoutExtension) || "bootstrap".equals(nameWithoutExtension)) continue;
                List configFilesByName = contributor.findApplicationConfigFiles(this.myModule, false, nameWithoutExtension);
                results.add(new SpringConfigNameProposal(fileType, nameWithoutExtension, configFilesByName));
            }
        }
        results.sort((o1, o2) -> StringUtil.naturalCompare((String)((SpringConfigNameProposal)o1).myName, (String)((SpringConfigNameProposal)o2).myName));
        return results;
    }

    private void addCustomFiles() {
        final Set configFileFiletypes = ContainerUtil.map2Set((Object[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions(), contributor -> contributor.getFileType());
        final HashSet configFilesFromDifferentContributors = ContainerUtil.newHashSet();
        for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            if (fileNameContributor.equals(this.myFileNameContributor) || !fileNameContributor.accept(this.myModule)) continue;
            for (SpringBootModelConfigFileContributor contributor2 : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
                configFilesFromDifferentContributors.addAll(contributor2.getConfigurationFiles(this.myModule, fileNameContributor, false));
            }
        }
        FileChooserDescriptor chooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles)) {
                    return false;
                }
                if (file.isDirectory()) {
                    return !ProjectFileIndex.getInstance((Project)SpringBootCustomizationDialog.this.myProject).isExcluded(file);
                }
                return configFileFiletypes.contains(file.getFileType()) && !configFilesFromDifferentContributors.contains(file) && SpringBootCustomizationDialog.this.myPsiFiles.stream().noneMatch(psiFile -> psiFile.getVirtualFile().equals(file));
            }
        }.withShowHiddenFiles(false).withTitle("Choose Custom Configuration Files").withRoots(ModuleRootManager.getInstance((Module)this.myModule).getContentRoots());
        FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(chooserDescriptor, this.myProject, (Component)this.myMainPanel);
        Object[] files = fileChooser.choose(this.myProject, new VirtualFile[0]);
        if (files.length != 0) {
            ContainerUtil.addAll(this.myCustomConfigFiles, (Object[])files);
            this.updateTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTree() {
        CheckedTreeNode myRoot = new CheckedTreeNode(null);
        this.myFilesTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)myRoot));
        this.myPsiFiles.clear();
        this.myFilesTree.setPaintBusy(true);
        try {
            ConfigFileSearcher[] searchers;
            for (ConfigFileSearcher searcher : searchers = this.getSearchers()) {
                ContainerUtil.addAll(this.myPsiFiles, (Iterable)searcher.searchWithFiles());
            }
            this.myFilesTreeBuilder.buildTree((DefaultMutableTreeNode)this.myFilesTree.getModel().getRoot(), searchers);
            TreeUtil.expandAll((JTree)this.myFilesTree);
        }
        finally {
            this.myFilesTree.setPaintBusy(false);
        }
    }

    private ConfigFileSearcher[] getSearchers() {
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        final String defaultConfigName = this.getConfigFileNameSetting().getDefaultValue();
        this.foundConfigFilesByName = false;
        SmartList searchers = new SmartList();
        for (final SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            ConfigFileSearcher searcher = new ConfigFileSearcher(this.myModule, this.myModule.getProject()){

                public Set<PsiFile> search(@Nullable Module module, @NotNull Project project) {
                    if (project == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    assert (module != null);
                    SmartList allConfigFiles = new SmartList();
                    String configName = StringUtil.defaultIfEmpty((String)SpringBootCustomizationDialog.this.getConfigFileName(), (String)defaultConfigName);
                    List configNameFiles = contributor.findApplicationConfigFiles(module, false, configName);
                    if (!configNameFiles.isEmpty()) {
                        SpringBootCustomizationDialog.this.foundConfigFilesByName = true;
                    }
                    allConfigFiles.addAll(configNameFiles);
                    LinkedHashSet<PsiFile> hashSet = new LinkedHashSet<PsiFile>();
                    ContainerUtil.addAll(hashSet, (Iterable)PsiUtilCore.toPsiFiles((PsiManager)psiManager, (Collection)allConfigFiles));
                    return hashSet;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$7", "search"));
                }
            };
            searchers.add(searcher);
        }
        searchers.add(new ConfigFileSearcher(this.myModule, this.myModule.getProject()){

            public Set<PsiFile> search(@Nullable Module module, @NotNull Project project) {
                if (project == null) {
                    8.$$$reportNull$$$0(0);
                }
                LinkedHashSet<PsiFile> hashSet = new LinkedHashSet<PsiFile>();
                ContainerUtil.addAll(hashSet, (Iterable)PsiUtilCore.toPsiFiles((PsiManager)psiManager, (Collection)SpringBootCustomizationDialog.this.myCustomConfigFiles));
                return hashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$8", "search"));
            }
        });
        return searchers.toArray(new ConfigFileSearcher[searchers.size()]);
    }

    private String getConfigFileName() {
        return this.mySpringConfigNameTextField.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.foundConfigFilesByName) {
            return new ValidationInfo("No configuration files matching pattern '" + this.getConfigFileName() + "' found", this.mySpringConfigNameTextField);
        }
        return null;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "SpringBootCustomization";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/facet/SpringBootCustomizationDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFileNameSetting";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomConfigFilesSetting";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSetting";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConfigurationPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myTreePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setToolTipText("Uncheck to remove custom configuration files");
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        this.myKeyLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 2, 1, 0, 1, 6, 1, null, null, null));
        this.myTextFieldPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, new Dimension(250, -1), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class SpringConfigNameAutoCompletionListProvider
    extends TextFieldWithAutoCompletionListProvider<SpringConfigNameProposal> {
        private SpringConfigNameAutoCompletionListProvider(List<SpringConfigNameProposal> variants) {
            super(variants);
        }

        @NotNull
        protected String getLookupString(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                SpringConfigNameAutoCompletionListProvider.$$$reportNull$$$0(0);
            }
            String string = item.myName;
            if (string == null) {
                SpringConfigNameAutoCompletionListProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected String getTypeText(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                SpringConfigNameAutoCompletionListProvider.$$$reportNull$$$0(2);
            }
            return "(." + item.myFileType.getDefaultExtension() + ")";
        }

        @Nullable
        public String getAdvertisement() {
            return "Use (+) to add configuration files from custom location";
        }

        protected String getTailText(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                SpringConfigNameAutoCompletionListProvider.$$$reportNull$$$0(3);
            }
            List configFiles = item.myConfigFilesByName;
            StringBuilder tailText = new StringBuilder(" ");
            if (configFiles.size() > 1) {
                tailText.append("[Detected Profiles: ");
                SmartList profileNames = new SmartList();
                for (VirtualFile file : configFiles) {
                    String nameWithoutExtension = file.getNameWithoutExtension();
                    if (!StringUtil.containsChar((String)nameWithoutExtension, (char)'-')) continue;
                    profileNames.add(StringUtil.substringAfter((String)nameWithoutExtension, (String)"-"));
                }
                tailText.append(StringUtil.join((Collection)profileNames, (String)", "));
                tailText.append("] ");
            }
            return tailText.toString();
        }

        @Nullable
        protected Icon getIcon(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                SpringConfigNameAutoCompletionListProvider.$$$reportNull$$$0(4);
            }
            return item.myFileType.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$SpringConfigNameAutoCompletionListProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$SpringConfigNameAutoCompletionListProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SpringConfigNameProposal {
        private final FileType myFileType;
        private final String myName;
        private final List<VirtualFile> myConfigFilesByName;

        private SpringConfigNameProposal(FileType fileType, String name, List<VirtualFile> configFilesByName) {
            this.myFileType = fileType;
            this.myName = name;
            this.myConfigFilesByName = configFilesByName;
        }
    }
}

