/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.SpringInspectionsRegistry;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class SpringBootConfigFileAdditionalFilesContributor
extends SpringInspectionsRegistry.AdditionalFilesContributor {
    public Collection<VirtualFile> getAdditionalFilesToProcess(Project project, CompileContext context) {
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            return Collections.emptyList();
        }
        LinkedHashSet additionalFiles = ContainerUtil.newLinkedHashSet();
        for (Module module : context.getCompileScope().getAffectedModules()) {
            if (!SpringCommonUtils.hasSpringFacet((Module)module)) continue;
            SpringBootConfigFileAdditionalFilesContributor.addConfigurationFiles(additionalFiles, module);
        }
        return additionalFiles;
    }

    private static void addConfigurationFiles(Collection<VirtualFile> additionalFiles, Module module) {
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            additionalFiles.addAll(contributor.getConfigurationFiles(module, true));
        }
    }
}

