/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassSorter;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.spi.SpringSpiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AutoConfigClassCollector {
    private final Module myModule;
    private final EnableAutoConfiguration myEnableAutoConfiguration;
    private final PsiClass myConfig;

    AutoConfigClassCollector(Module module, EnableAutoConfiguration enableAutoConfiguration, PsiClass config) {
        this.myModule = module;
        this.myEnableAutoConfiguration = enableAutoConfiguration;
        this.myConfig = config;
    }

    List<PsiClass> getAllAutoConfigurationClasses() {
        List<PsiClass> allAutoConfigurationClasses = AutoConfigClassCollector.getAllRegisteredAutoConfigurationClasses(this.myModule);
        List excludes = this.myEnableAutoConfiguration.getExcludes();
        allAutoConfigurationClasses.removeAll(excludes);
        AutoConfigClassSorter sorter = new AutoConfigClassSorter(this.myModule, allAutoConfigurationClasses);
        return sorter.getSortedConfigs();
    }

    private static List<PsiClass> getAllRegisteredAutoConfigurationClasses(@NotNull Module module) {
        if (module == null) {
            AutoConfigClassCollector.$$$reportNull$$$0(0);
        }
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        List allFromConfig = SpringSpiManager.getInstance((Module)module).getClassesListValue(false, "org.springframework.boot.autoconfigure.EnableAutoConfiguration");
        return new ArrayList<PsiClass>(new LinkedHashSet(allFromConfig));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassCollector", "getAllRegisteredAutoConfigurationClasses"));
    }
}

