/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.facet.SpringBootFileSetEditorCustomization;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassConditionEvaluator;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class AutoConfigurationModelBase
extends LocalAnnotationModel {
    private final LocalAnnotationModel myLocalAnnotationModel;
    private final PsiClass myConfigClass;

    protected AutoConfigurationModelBase(LocalAnnotationModel localAnnotationModel, PsiClass configClass) {
        this.myLocalAnnotationModel = localAnnotationModel;
        this.myConfigClass = configClass;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(0);
        }
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        return Collections.emptySet();
    }

    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myConfigClass;
        if (psiClass == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(1);
        }
        return psiClass;
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        List<PsiClass> autoConfigClasses = this.getAutoConfigClasses();
        boolean nonStrictEvaluation = this.isNonStrictEvaluation();
        Map configFilesCache = FactoryMap.create(contributor -> Arrays.stream(SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()).filter(fileNameContributor -> fileNameContributor.accept(this.getModule())).map(fileNameContributor -> contributor.getConfigurationFiles(this.getModule(), fileNameContributor, false)).filter(list -> !list.isEmpty()).collect(Collectors.toCollection(ContainerUtil::newSmartList)));
        LinkedHashSet autoConfigModels = ContainerUtil.newLinkedHashSet();
        autoConfigClasses.forEach(autoConfigClass -> this.processConfigurationClass(autoConfigModels, (PsiClass)autoConfigClass, nonStrictEvaluation, (Function<SpringBootModelConfigFileContributor, List<List<VirtualFile>>>)((Function)contributor -> (List)configFilesCache.get(contributor))));
        LinkedHashSet linkedHashSet = autoConfigModels;
        if (linkedHashSet == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    private boolean isNonStrictEvaluation() {
        SpringFacet springFacet = SpringFacet.getInstance((Module)this.getModule());
        CustomSetting.BOOLEAN setting = springFacet != null ? (CustomSetting.BOOLEAN)springFacet.findSetting(SpringBootFileSetEditorCustomization.NON_STRICT_SETTING) : null;
        return setting == null || setting.getBooleanValue();
    }

    private void processConfigurationClass(Set<Pair<LocalModel, LocalModelDependency>> autoConfigModels, PsiClass autoConfigClass, boolean nonStrictEvaluation, Function<SpringBootModelConfigFileContributor, List<List<VirtualFile>>> configFilesFunction) {
        AutoConfigClassConditionEvaluator evaluator = new AutoConfigClassConditionEvaluator(this.getModule(), nonStrictEvaluation, autoConfigClass, this.myLocalAnnotationModel.getActiveProfiles(), configFilesFunction);
        if (!evaluator.isActive()) {
            return;
        }
        LocalAnnotationModel autoConfigModel = SpringManager.getInstance((Project)this.myConfigClass.getProject()).getLocalSpringModel(autoConfigClass, this.getModule());
        if (autoConfigModel == null) {
            return;
        }
        autoConfigModel.disableEvaluatingInnerConfigurationClasses();
        LocalModelDependency dependency = LocalModelDependency.create((String)("Auto-configuration @" + this.myConfigClass.getQualifiedName()), (LocalModelDependencyType)this.getModelDependencyType(), (PsiElement)autoConfigClass.getNavigationElement());
        autoConfigModels.add((Pair<LocalModel, LocalModelDependency>)Pair.create((Object)autoConfigModel, (Object)dependency));
        for (PsiClass innerConfig : autoConfigClass.getInnerClasses()) {
            if (!innerConfig.hasModifierProperty("static") || JamService.getJamService((Project)this.getModule().getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)innerConfig) == null) continue;
            this.processConfigurationClass(autoConfigModels, innerConfig, nonStrictEvaluation, configFilesFunction);
        }
    }

    protected LocalAnnotationModel getLocalAnnotationModel() {
        return this.myLocalAnnotationModel;
    }

    @NotNull
    protected abstract List<PsiClass> getAutoConfigClasses();

    @NotNull
    protected abstract LocalModelDependencyType getModelDependencyType();

    @NotNull
    public Module getModule() {
        Module module = this.myLocalAnnotationModel.getModule();
        if (module == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(3);
        }
        return module;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        Set set = this.myLocalAnnotationModel.getAllProfiles();
        if (set == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set set = this.myLocalAnnotationModel.getConfigFiles();
        if (set == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            AutoConfigurationModelBase.$$$reportNull$$$0(6);
        }
        return this.myLocalAnnotationModel.hasConfigFile(configFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AutoConfigurationModelBase model = (AutoConfigurationModelBase)((Object)o);
        return this.myConfigClass.equals(model.myConfigClass) && this.myLocalAnnotationModel.equals(model.myLocalAnnotationModel);
    }

    public int hashCode() {
        int result = this.myConfigClass.hashCode();
        result = 31 * result + this.myLocalAnnotationModel.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentLocalModels";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setActiveProfiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

