/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.store;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lobobrowser.io.ManagedFile;
import org.lobobrowser.io.ManagedFileFilter;
import org.lobobrowser.io.ManagedStore;
import org.lobobrowser.io.QuotaExceededException;
import org.lobobrowser.store.ClassLoaderObjectInputStream;
import org.lobobrowser.store.QuotaSource;
import org.lobobrowser.store.RestrictedOutputStream;
import org.lobobrowser.util.WrapperException;

public final class RestrictedStore
implements QuotaSource,
ManagedStore {
    private static final Logger logger = Logger.getLogger(RestrictedStore.class.getName());
    private final File baseDirectory;
    private final String baseCanonicalPath;
    private final String sizeFileCanonicalPath;
    private final long quota;
    private final String SIZE_FILE_NAME = ".W$Dir$Size";
    private final int EMPTY_FILE_SIZE = 64;
    private final int DIRECTORY_SIZE = 64;
    private long size = -1L;
    private long lastUpdatedSize = Long.MIN_VALUE;
    private static long SIZE_UPDATE_THRESHOLD = 4096L;

    public RestrictedStore(File baseDirectory, long quota) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        String canonical = baseDirectory.getCanonicalPath();
        if (sm != null) {
            sm.checkWrite(canonical);
        }
        if (!baseDirectory.exists()) {
            baseDirectory.mkdirs();
        } else if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException(baseDirectory + " not a directory");
        }
        this.baseDirectory = new File(canonical);
        this.baseCanonicalPath = canonical;
        this.sizeFileCanonicalPath = new File(this.baseDirectory, ".W$Dir$Size").getCanonicalPath();
        this.quota = quota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateSizeFile() throws IOException {
        long prevSize;
        long totalSize = this.computeSize();
        RestrictedStore restrictedStore = this;
        synchronized (restrictedStore) {
            prevSize = this.size;
            this.updateSizeFileImpl(totalSize);
        }
        if (prevSize != -1L && Math.abs(totalSize - prevSize) > 10000L) {
            logger.warning("updateSizeFile(): Corrected a size discrepancy of " + (totalSize - prevSize) + " bytes in store '" + this.baseDirectory + "'.");
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSizeFileImpl(long totalSize) throws IOException {
        RestrictedStore restrictedStore = this;
        synchronized (restrictedStore) {
            this.size = totalSize;
            File sizeFile = new File(this.baseDirectory, ".W$Dir$Size");
            FileOutputStream out = new FileOutputStream(sizeFile);
            DataOutputStream dout = new DataOutputStream(out);
            try {
                dout.writeLong(totalSize);
                dout.flush();
            }
            finally {
                dout.close();
                out.close();
            }
        }
    }

    @Override
    public long getQuota() {
        return this.quota;
    }

    @Override
    public long getSize() throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Long>(){

                @Override
                public Long run() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            long size = RestrictedStore.this.size;
                            if (size == -1L) {
                                size = RestrictedStore.this.size = RestrictedStore.this.getSizeFromFile();
                            }
                            return size;
                        }
                        catch (IOException ioe) {
                            throw new WrapperException(ioe);
                        }
                    }
                }
            });
        }
        catch (WrapperException we) {
            throw (IOException)we.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSizeFromFile() throws IOException {
        long l;
        File sizeFile = new File(this.baseDirectory, ".W$Dir$Size");
        FileInputStream in = new FileInputStream(sizeFile);
        try {
            DataInputStream din = new DataInputStream(in);
            l = din.readLong();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException fnf) {
                return this.updateSizeFile();
            }
        }
        in.close();
        return l;
    }

    private long computeSize() throws IOException {
        return this.computeSize(this.baseDirectory);
    }

    private long computeSize(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("'directory' not a directory");
        }
        long total = 64L;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            Thread.yield();
            File file = files[i];
            if (file.isDirectory() && !file.equals(directory)) {
                String fileCanonical = file.getCanonicalPath();
                if (!fileCanonical.startsWith(this.baseCanonicalPath)) continue;
                total += this.computeSize(file);
                continue;
            }
            total += 64L + file.length();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUsedBytes(long addition) throws IOException {
        RestrictedStore restrictedStore = this;
        synchronized (restrictedStore) {
            boolean fromFile = false;
            if (this.size == -1L) {
                this.size = this.getSizeFromFile();
                fromFile = true;
            }
            long newTotal = this.size + addition;
            if (addition > 0L && newTotal > this.quota) {
                throw new QuotaExceededException("Quota would be exceeded by " + (newTotal - this.quota) + " bytes.");
            }
            this.size = newTotal;
            if (fromFile) {
                this.lastUpdatedSize = newTotal;
            } else if (Math.abs(newTotal - this.lastUpdatedSize) > SIZE_UPDATE_THRESHOLD) {
                this.lastUpdatedSize = newTotal;
                this.updateSizeFileImpl(newTotal);
            }
        }
    }

    public void subtractUsedBytes(long reduction) throws IOException {
        this.addUsedBytes(-reduction);
    }

    private void checkNotSizeFile(String canonicalPath, String ref) {
        if (this.sizeFileCanonicalPath.equals(canonicalPath)) {
            throw new SecurityException("This particular path not allowed: " + ref);
        }
    }

    private void checkPath(String canonicalPath, String ref) {
        if (!canonicalPath.startsWith(this.baseCanonicalPath)) {
            throw new SecurityException("Path outside protected store: " + ref);
        }
        this.checkNotSizeFile(canonicalPath, ref);
    }

    public InputStream getInputStream(final File fullFile, final String ref) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    try {
                        String canonical = fullFile.getCanonicalPath();
                        RestrictedStore.this.checkPath(canonical, ref);
                        return new FileInputStream(fullFile);
                    }
                    catch (IOException ioe) {
                        throw new WrapperException(ioe);
                    }
                }
            });
        }
        catch (WrapperException we) {
            throw (IOException)we.getCause();
        }
    }

    public OutputStream getOutputStream(final File fullFile, final String ref) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<OutputStream>(){

                @Override
                public OutputStream run() {
                    try {
                        long toSubtract = 64L + (fullFile.exists() ? fullFile.length() : 0L);
                        String canonical = fullFile.getCanonicalPath();
                        RestrictedStore.this.checkPath(canonical, ref);
                        File parent = fullFile.getParentFile();
                        if (!parent.exists()) {
                            parent.mkdirs();
                        } else if (!parent.isDirectory()) {
                            throw new IllegalArgumentException("Parent of '" + ref + "' is not a directory");
                        }
                        FileOutputStream fout = new FileOutputStream(fullFile);
                        RestrictedOutputStream out = new RestrictedOutputStream(fout, RestrictedStore.this);
                        if (toSubtract != 0L) {
                            RestrictedStore.this.subtractUsedBytes(toSubtract);
                        }
                        return out;
                    }
                    catch (IOException ioe) {
                        throw new WrapperException(ioe);
                    }
                }
            });
        }
        catch (WrapperException we) {
            throw (IOException)we.getCause();
        }
    }

    private String getRelativePath(String canonicalPath) {
        String relativePath = canonicalPath.substring(this.baseCanonicalPath.length());
        if (relativePath.startsWith(File.separator)) {
            relativePath = relativePath.substring(File.separator.length());
        }
        if (!"/".equals(File.separator)) {
            relativePath = relativePath.replace(File.separatorChar, '/');
        }
        return relativePath;
    }

    public Collection getPaths(String regexp) throws IOException {
        final Pattern pattern = Pattern.compile(regexp);
        try {
            return AccessController.doPrivileged(new PrivilegedAction<Collection>(){

                @Override
                public Collection run() {
                    try {
                        return RestrictedStore.this.getPaths(pattern, RestrictedStore.this.baseDirectory);
                    }
                    catch (IOException ioe) {
                        throw new WrapperException(ioe);
                    }
                }
            });
        }
        catch (WrapperException we) {
            throw (IOException)we.getCause();
        }
    }

    private Collection getPaths(Pattern pattern, File directory) throws IOException {
        LinkedList<String> paths = new LinkedList<String>();
        File[] localFiles = directory.listFiles();
        for (int i = 0; i < localFiles.length; ++i) {
            File file = localFiles[i];
            if (file.isDirectory()) {
                Collection subPaths = this.getPaths(pattern, file);
                paths.addAll(subPaths);
                continue;
            }
            String canonical = file.getCanonicalPath();
            String relativePath = this.getRelativePath(canonical);
            Matcher matcher = pattern.matcher(relativePath);
            if (!matcher.matches()) continue;
            try {
                this.checkPath(canonical, "not-shown");
                paths.add(relativePath);
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return paths;
    }

    @Override
    public long getSpaceLeft() throws IOException {
        return this.quota - this.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveObject(String path, Serializable object) throws IOException {
        ManagedFile file = this.getManagedFile(path);
        OutputStream out = file.openOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(new BufferedOutputStream(out));
            oout.writeObject(object);
            oout.flush();
        }
        finally {
            out.close();
        }
    }

    public void removeObject(String path) throws IOException {
        ManagedFile file = this.getManagedFile(path);
        file.delete();
    }

    public Object retrieveObject(String path) throws IOException, ClassNotFoundException {
        return this.retrieveObject(path, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object retrieveObject(String path, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Object object;
        ManagedFile file = this.getManagedFile(path);
        InputStream in = file.openInputStream();
        ClassLoaderObjectInputStream oin = new ClassLoaderObjectInputStream(in, classLoader);
        try {
            object = oin.readObject();
        }
        catch (Throwable throwable) {
            try {
                oin.close();
                in.close();
                throw throwable;
            }
            catch (FileNotFoundException err) {
                return null;
            }
        }
        oin.close();
        in.close();
        return object;
    }

    @Override
    public ManagedFile getManagedFile(ManagedFile parent, String relativePath) throws IOException {
        return new ManagedFileImpl(parent, relativePath);
    }

    @Override
    public ManagedFile getManagedFile(String path) throws IOException {
        return new ManagedFileImpl(path);
    }

    @Override
    public ManagedFile getRootManagedDirectory() throws IOException {
        return new ManagedFileImpl("/");
    }

    private File managedToNative(final String path) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    try {
                        if (path.contains("\\")) {
                            throw new IllegalArgumentException("Characer backslash (\\) not allowed in managed paths. Use a forward slash. Path=" + path);
                        }
                        String relPath = path;
                        while (relPath.startsWith("/")) {
                            relPath = relPath.substring(1);
                        }
                        File fullFile = (relPath = relPath.replace("/", File.separator)).length() == 0 ? RestrictedStore.this.baseDirectory : new File(RestrictedStore.this.baseDirectory, relPath);
                        String canonical = fullFile.getCanonicalPath();
                        RestrictedStore.this.checkPath(canonical, path);
                        return fullFile;
                    }
                    catch (IOException ioe) {
                        throw new WrapperException(ioe);
                    }
                }
            });
        }
        catch (WrapperException we) {
            throw (IOException)we.getCause();
        }
    }

    private ManagedFile nativeToManaged(File file) throws IOException {
        String canonical = file.getCanonicalPath();
        if (!canonical.startsWith(this.baseCanonicalPath)) {
            throw new SecurityException("File is outside of managed store");
        }
        String mpath = canonical.substring(this.baseCanonicalPath.length());
        if (!mpath.startsWith(File.separator)) {
            mpath = File.separator + mpath;
        }
        return new ManagedFileImpl(mpath);
    }

    private class ManagedFileImpl
    implements ManagedFile {
        private final String path;
        private final File nativeFile;

        private ManagedFileImpl(String path) throws IOException {
            this.path = path;
            this.nativeFile = RestrictedStore.this.managedToNative(path);
        }

        private ManagedFileImpl(ManagedFile parent, String relPath) throws IOException {
            String pp;
            this.path = parent == null ? relPath : (relPath.startsWith("/") ? relPath : ((pp = parent.getPath()).endsWith("/") ? pp + relPath : pp + "/" + relPath));
            this.nativeFile = RestrictedStore.this.managedToNative(this.path);
        }

        @Override
        public boolean createNewFile() throws IOException {
            try {
                return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        try {
                            boolean success = ManagedFileImpl.this.nativeFile.createNewFile();
                            if (success) {
                                RestrictedStore.this.addUsedBytes(64L);
                            }
                            return success;
                        }
                        catch (IOException ioe) {
                            throw new WrapperException(ioe);
                        }
                    }
                });
            }
            catch (WrapperException we) {
                throw (IOException)we.getCause();
            }
        }

        @Override
        public boolean exists() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return ManagedFileImpl.this.nativeFile.exists();
                }
            });
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return RestrictedStore.this.getInputStream(this.nativeFile, this.path);
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return RestrictedStore.this.getOutputStream(this.nativeFile, this.path);
        }

        @Override
        public ManagedFile getParent() throws IOException {
            try {
                return AccessController.doPrivileged(new PrivilegedAction<ManagedFile>(){

                    @Override
                    public ManagedFile run() {
                        try {
                            File parentFile = ManagedFileImpl.this.nativeFile.getParentFile();
                            return RestrictedStore.this.nativeToManaged(parentFile);
                        }
                        catch (IOException ioe) {
                            throw new WrapperException(ioe);
                        }
                    }
                });
            }
            catch (WrapperException we) {
                throw (IOException)we.getCause();
            }
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isDirectory() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return ManagedFileImpl.this.nativeFile.isDirectory();
                }
            });
        }

        @Override
        public ManagedFile[] listFiles() throws IOException {
            return this.listFiles(null);
        }

        @Override
        public ManagedFile[] listFiles(final ManagedFileFilter filter) throws IOException {
            try {
                return AccessController.doPrivileged(new PrivilegedAction<ManagedFile[]>(){

                    @Override
                    public ManagedFile[] run() {
                        try {
                            File[] files = ManagedFileImpl.this.nativeFile.listFiles();
                            ArrayList<ManagedFile> mfs = new ArrayList<ManagedFile>();
                            for (int i = 0; i < files.length; ++i) {
                                File file = files[i];
                                ManagedFile mf = RestrictedStore.this.nativeToManaged(file);
                                if (filter != null && !filter.accept(mf)) continue;
                                mfs.add(mf);
                            }
                            return mfs.toArray(new ManagedFile[0]);
                        }
                        catch (IOException ioe) {
                            throw new WrapperException(ioe);
                        }
                    }
                });
            }
            catch (WrapperException we) {
                throw (IOException)we.getCause();
            }
        }

        @Override
        public boolean mkdir() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean success = ManagedFileImpl.this.nativeFile.mkdir();
                    if (success) {
                        try {
                            RestrictedStore.this.addUsedBytes(64L);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return success;
                }
            });
        }

        @Override
        public boolean mkdirs() {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    boolean success = ManagedFileImpl.this.nativeFile.mkdirs();
                    if (success) {
                        try {
                            RestrictedStore.this.addUsedBytes(64L);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return success;
                }
            });
        }

        @Override
        public boolean delete() throws IOException {
            try {
                return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        try {
                            long prevLength = ManagedFileImpl.this.nativeFile.length() + 64L;
                            if (ManagedFileImpl.this.nativeFile.delete()) {
                                RestrictedStore.this.subtractUsedBytes(prevLength);
                                return true;
                            }
                            return false;
                        }
                        catch (IOException ioe) {
                            throw new WrapperException(ioe);
                        }
                    }
                });
            }
            catch (WrapperException we) {
                throw (IOException)we.getCause();
            }
        }
    }
}

