/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CssTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, Project project, Editor editor, PsiFile file) {
        char prevChar;
        int offset;
        if (!(file instanceof StylesheetFile) && !CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file)) {
            return super.checkAutoPopup(charTyped, project, editor, file);
        }
        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)project);
        if (charTyped == '#' && CssTypedHandler.insideStylesheet(editor, file)) {
            autoPopupController.autoPopupMemberLookup(editor, null);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (charTyped == '-' || charTyped == '!') {
            boolean insideBlock;
            boolean bl = insideBlock = PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), CssBlock.class) != null;
            if (insideBlock) {
                autoPopupController.autoPopupMemberLookup(editor, null);
                return TypedHandlerDelegate.Result.STOP;
            }
        } else if (charTyped == ' ' && CssTypedHandler.insideStylesheet(editor, file) && (offset = editor.getCaretModel().getOffset()) > 0 && ('{' == (prevChar = editor.getDocument().getCharsSequence().charAt(offset - 1)) || ';' == prevChar || ':' == prevChar)) {
            autoPopupController.autoPopupMemberLookup(editor, null);
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.checkAutoPopup(charTyped, project, editor, file);
    }

    private static boolean insideStylesheet(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            CssTypedHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CssTypedHandler.$$$reportNull$$$0(1);
        }
        return file instanceof StylesheetFile || CssPsiUtil.getStylesheetLanguage((PsiElement)file.findElementAt(editor.getCaretModel().getOffset())) != null;
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        Document document;
        int offset;
        if (!(file instanceof StylesheetFile) && !CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file)) {
            return super.beforeCharTyped(c, project, editor, file, fileType);
        }
        String terminator = CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)file);
        if (terminator.length() == 1 && c == terminator.charAt(0) && (offset = editor.getCaretModel().getOffset()) < (document = editor.getDocument()).getTextLength() && document.getCharsSequence().charAt(offset) == c) {
            editor.getCaretModel().moveToOffset(offset + 1);
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.beforeCharTyped(c, project, editor, file, fileType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/css/CssTypedHandler";
        objectArray[2] = "insideStylesheet";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

