/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class XmlBuilder {
    private final StringBuilder myStringBuilder = new StringBuilder();
    private Construct myLastAppendedConstruct = Construct.NULL;
    private int myIndentationLevel;

    @NotNull
    public XmlBuilder startTag(@NotNull String name) {
        int length;
        if (name == null) {
            XmlBuilder.$$$reportNull$$$0(0);
        }
        if (!this.myLastAppendedConstruct.equals((Object)Construct.END_TAG) && (length = this.myStringBuilder.length()) > 0) {
            this.myStringBuilder.replace(length - 1, length, ">\n");
        }
        if (this.myIndentationLevel != 0) {
            this.myStringBuilder.append('\n');
        }
        this.indent();
        this.myStringBuilder.append('<').append(name).append('\n');
        ++this.myIndentationLevel;
        this.myLastAppendedConstruct = Construct.START_TAG;
        XmlBuilder xmlBuilder = this;
        if (xmlBuilder == null) {
            XmlBuilder.$$$reportNull$$$0(1);
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder androidAttribute(@NotNull String name, boolean value) {
        if (name == null) {
            XmlBuilder.$$$reportNull$$$0(2);
        }
        XmlBuilder xmlBuilder = this.androidAttribute(name, Boolean.toString(value));
        if (xmlBuilder == null) {
            XmlBuilder.$$$reportNull$$$0(3);
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder androidAttribute(@NotNull String name, int value) {
        if (name == null) {
            XmlBuilder.$$$reportNull$$$0(4);
        }
        XmlBuilder xmlBuilder = this.androidAttribute(name, Integer.toString(value));
        if (xmlBuilder == null) {
            XmlBuilder.$$$reportNull$$$0(5);
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder androidAttribute(@NotNull String name, @NotNull String value) {
        if (name == null) {
            XmlBuilder.$$$reportNull$$$0(6);
        }
        if (value == null) {
            XmlBuilder.$$$reportNull$$$0(7);
        }
        XmlBuilder xmlBuilder = this.attribute("android", name, value);
        if (xmlBuilder == null) {
            XmlBuilder.$$$reportNull$$$0(8);
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder attribute(@NotNull String namespacePrefix, @NotNull String name, @NotNull String value) {
        if (namespacePrefix == null) {
            XmlBuilder.$$$reportNull$$$0(9);
        }
        if (name == null) {
            XmlBuilder.$$$reportNull$$$0(10);
        }
        if (value == null) {
            XmlBuilder.$$$reportNull$$$0(11);
        }
        this.indent();
        if (!StringUtil.isEmpty((String)namespacePrefix)) {
            this.myStringBuilder.append(namespacePrefix).append(':');
        }
        this.myStringBuilder.append(name).append("=\"").append(value).append("\"\n");
        this.myLastAppendedConstruct = Construct.ATTRIBUTE;
        XmlBuilder xmlBuilder = this;
        if (xmlBuilder == null) {
            XmlBuilder.$$$reportNull$$$0(12);
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder endTag(@NotNull String name) {
        boolean useEmptyElementTag;
        if (name == null) {
            XmlBuilder.$$$reportNull$$$0(13);
        }
        boolean bl = useEmptyElementTag = !name.endsWith("Layout") && !name.equals("PreferenceCategory");
        if (this.myLastAppendedConstruct.equals((Object)Construct.START_TAG) || this.myLastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) {
            int length = this.myStringBuilder.length();
            if (useEmptyElementTag) {
                this.myStringBuilder.deleteCharAt(length - 1);
            } else {
                this.myStringBuilder.replace(length - 1, length, ">\n\n");
            }
        }
        --this.myIndentationLevel;
        if ((this.myLastAppendedConstruct.equals((Object)Construct.START_TAG) || this.myLastAppendedConstruct.equals((Object)Construct.ATTRIBUTE)) && useEmptyElementTag) {
            this.myStringBuilder.append(" />\n");
        } else {
            this.indent();
            this.myStringBuilder.append("</").append(name).append(">\n");
        }
        this.myLastAppendedConstruct = Construct.END_TAG;
        XmlBuilder xmlBuilder = this;
        if (xmlBuilder == null) {
            XmlBuilder.$$$reportNull$$$0(14);
        }
        return xmlBuilder;
    }

    private void indent() {
        for (int i = 0; i < this.myIndentationLevel; ++i) {
            this.myStringBuilder.append("    ");
        }
    }

    @NotNull
    public String toString() {
        String string = this.myStringBuilder.toString();
        if (string == null) {
            XmlBuilder.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/XmlBuilder";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/XmlBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startTag";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "androidAttribute";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "attribute";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "endTag";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startTag";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "androidAttribute";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "attribute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "endTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Construct {
        NULL,
        START_TAG,
        ATTRIBUTE,
        END_TAG;

    }
}

