/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class AutoImportNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.auto.import");
    @NotNull
    private final Project myProject;
    @NotNull
    private final EditorNotifications myNotifications;

    public AutoImportNotificationProvider(@NotNull Project project, @NotNull EditorNotifications notifications) {
        if (project == null) {
            AutoImportNotificationProvider.$$$reportNull$$$0(0);
        }
        if (notifications == null) {
            AutoImportNotificationProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myNotifications = notifications;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            AutoImportNotificationProvider.$$$reportNull$$$0(2);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            AutoImportNotificationProvider.$$$reportNull$$$0(3);
        }
        if (fileEditor == null) {
            AutoImportNotificationProvider.$$$reportNull$$$0(4);
        }
        if (!GradleProjectInfo.getInstance(this.myProject).isBuildWithGradle()) {
            return null;
        }
        String name = file.getName();
        if ("build.gradle".equals(name) || "settings.gradle".equals(name)) {
            GradleProjectSettings settings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(this.myProject);
            if (IdeInfo.getInstance().isAndroidStudio() && settings != null && settings.isUseAutoImport()) {
                return new DisableAutoImportNotificationPanel(settings);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notifications";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/notification/AutoImportNotificationProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/notification/AutoImportNotificationProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DisableAutoImportNotificationPanel
    extends EditorNotificationPanel {
        DisableAutoImportNotificationPanel(GradleProjectSettings settings) {
            if (settings == null) {
                DisableAutoImportNotificationPanel.$$$reportNull$$$0(0);
            }
            this.setText("Gradle 'auto-import' will considerably slow down the IDE, due to a known bug.");
            this.createActionLabel("Open bug report", () -> BrowserUtil.browse((String)"https://code.google.com/p/android/issues/detail?id=59965"));
            this.createActionLabel("Disable 'auto-import'", () -> {
                if (settings == null) {
                    DisableAutoImportNotificationPanel.$$$reportNull$$$0(1);
                }
                settings.setUseAutoImport(false);
                AutoImportNotificationProvider.this.myNotifications.updateAllNotifications();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "settings";
            objectArray2[1] = "com/android/tools/idea/gradle/notification/AutoImportNotificationProvider$DisableAutoImportNotificationPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$new$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

