/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.PropertyBasedDoNotAskOption;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.android.util.AndroidUiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleVersionRecommendedUpdateDialog
extends DialogWrapper {
    private static final String SHOW_DO_NOT_ASK_TO_UPGRADE_GRADLE_PROPERTY_NAME = "show.do.not.ask.upgrade.gradle";
    @NotNull
    private final Project myProject;
    @NotNull
    private final PropertyBasedDoNotAskOption myDoNotAskOption;
    private JPanel myMainPanel;
    private JEditorPane myMessagePane;
    private JButton[] myButtons;

    public GradleVersionRecommendedUpdateDialog(@NotNull Project project, @NotNull GradleVersion recommendedVersion, @Nullable GradleVersion newPluginVersion) {
        if (project == null) {
            GradleVersionRecommendedUpdateDialog.$$$reportNull$$$0(0);
        }
        if (recommendedVersion == null) {
            GradleVersionRecommendedUpdateDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setTitle("Gradle Update Recommended");
        this.myDoNotAskOption = new PropertyBasedDoNotAskOption(project, SHOW_DO_NOT_ASK_TO_UPGRADE_GRADLE_PROPERTY_NAME){

            @Override
            @NotNull
            public String getDoNotShowMessage() {
                if ("Don't remind me again for this project" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "Don't remind me again for this project";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/GradleVersionRecommendedUpdateDialog$1", "getDoNotShowMessage"));
            }
        };
        this.init();
        AndroidUiUtil.setUpAsHtmlLabel(this.myMessagePane);
        String msg = "<b>It is strongly recommended that you update Gradle to version " + recommendedVersion.toString() + " or later.</b>";
        if (newPluginVersion != null) {
            msg = msg + "<br/>As part of the update, the Android plugin will be updated to version " + newPluginVersion + ".";
        }
        msg = msg + "<br/><br/>For more information, please refer to the <a href='https://developer.android.com/studio/releases/index.html#Revisions'>release notes</a>.";
        this.myMessagePane.setText(msg);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        Action[] actions = this.createActions();
        ArrayList buttons = Lists.newArrayList();
        JPanel panel = new JPanel(new BorderLayout());
        if (actions.length > 0) {
            JPanel buttonsPanel = this.createButtons(actions, buttons);
            panel.add((Component)buttonsPanel, "Center");
            this.myButtons = buttons.toArray(new JButton[buttons.size()]);
        }
        if (this.getStyle() == DialogWrapper.DialogStyle.COMPACT) {
            CustomLineBorder line = new CustomLineBorder(OnePixelDivider.BACKGROUND, 1, 0, 0, 0);
            panel.setBorder(new CompoundBorder((Border)line, (Border)JBUI.Borders.empty((int)8, (int)12)));
        } else {
            panel.setBorder((Border)JBUI.Borders.emptyTop((int)8));
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            GradleVersionRecommendedUpdateDialog.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{new DoNotAskAction(), this.getCancelAction(), this.getOKAction()};
            if (actionArray == null) {
                GradleVersionRecommendedUpdateDialog.$$$reportNull$$$0(3);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), new DoNotAskAction()};
        if (actionArray == null) {
            GradleVersionRecommendedUpdateDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    @NotNull
    protected Action getOKAction() {
        Action action = super.getOKAction();
        action.putValue("Name", "Update");
        Action action2 = action;
        if (action2 == null) {
            GradleVersionRecommendedUpdateDialog.$$$reportNull$$$0(5);
        }
        return action2;
    }

    @NotNull
    protected Action getCancelAction() {
        Action action = super.getCancelAction();
        action.putValue("Name", "Remind me later");
        Action action2 = action;
        if (action2 == null) {
            GradleVersionRecommendedUpdateDialog.$$$reportNull$$$0(6);
        }
        return action2;
    }

    @NotNull
    private JPanel createButtons(@NotNull Action[] actions, @NotNull List<JButton> buttons) {
        if (actions == null) {
            GradleVersionRecommendedUpdateDialog.$$$reportNull$$$0(7);
        }
        if (buttons == null) {
            GradleVersionRecommendedUpdateDialog.$$$reportNull$$$0(8);
        }
        JPanel buttonsPanel = new JPanel(new FlowLayout(4));
        for (Action action : actions) {
            JButton button = this.createJButtonForAction(action);
            Object value = action.getValue("MnemonicKey");
            if (value instanceof Integer) {
                int mnemonic = (Integer)value;
                button.setMnemonic(mnemonic);
            }
            if (action.getValue("FocusedAction") != null) {
                this.myPreferredFocusedComponent = button;
            }
            buttons.add(button);
            buttonsPanel.add(button);
        }
        JPanel jPanel = buttonsPanel;
        if (jPanel == null) {
            GradleVersionRecommendedUpdateDialog.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    public void show() {
        if (PropertiesComponent.getInstance((Project)this.myProject).getBoolean(SHOW_DO_NOT_ASK_TO_UPGRADE_GRADLE_PROPERTY_NAME, true)) {
            super.show();
        } else {
            this.doCancelAction();
        }
    }

    protected void dispose() {
        super.dispose();
        if (this.myButtons != null) {
            for (JButton button : this.myButtons) {
                button.setAction(null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recommendedVersion";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/GradleVersionRecommendedUpdateDialog";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/GradleVersionRecommendedUpdateDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCancelAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createButtons";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMessagePane = jEditorPane = new JEditorPane();
        jPanel.add((Component)jEditorPane, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(450, 100), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class DoNotAskAction
    extends DialogWrapper.DialogWrapperAction {
        protected DoNotAskAction() {
            super((DialogWrapper)GradleVersionRecommendedUpdateDialog.this, GradleVersionRecommendedUpdateDialog.this.myDoNotAskOption.getDoNotShowMessage());
        }

        protected void doAction(ActionEvent e) {
            GradleVersionRecommendedUpdateDialog.this.myDoNotAskOption.setToBeShown(false, 1);
            GradleVersionRecommendedUpdateDialog.this.doCancelAction();
        }
    }
}

