/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.BaseSyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.hyperlink.CreateGradleWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixGradleVersionInWrapperHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenGradleSettingsHyperlink;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class UnsupportedGradleVersionErrorHandler
extends BaseSyncErrorHandler {
    private static final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN_1 = Pattern.compile("Minimum supported Gradle version is (.*)\\. Current version is.*?");
    private static final Pattern UNSUPPORTED_GRADLE_VERSION_PATTERN_2 = Pattern.compile("Gradle version (.*) is required.*?");

    @Override
    @Nullable
    protected String findErrorMessage(@NotNull Throwable rootCause, @NotNull NotificationData notification, @NotNull Project project) {
        String text;
        if (rootCause == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(0);
        }
        if (notification == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(2);
        }
        String newMsg = "";
        if (UnsupportedGradleVersionErrorHandler.isOldGradleVersion(rootCause)) {
            newMsg = "The project is using an unsupported version of Gradle.\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
        }
        if ((text = rootCause.getMessage()) != null && (UNSUPPORTED_GRADLE_VERSION_PATTERN_1.matcher(text).matches() || UNSUPPORTED_GRADLE_VERSION_PATTERN_2.matcher(text).matches())) {
            int i = text.indexOf("If using the gradle wrapper");
            if (i != -1) {
                text = text.substring(0, i);
                text = text.trim();
            }
            if (!text.endsWith(".")) {
                text = text + ".";
            }
            newMsg = text + "\n\n" + "Please fix the project's Gradle settings.";
        }
        if (StringUtil.isNotEmpty((String)newMsg)) {
            UnsupportedGradleVersionErrorHandler.updateUsageTracker(AndroidStudioEvent.GradleSyncFailure.UNSUPPORTED_GRADLE_VERSION);
            return newMsg;
        }
        return null;
    }

    private static boolean isOldGradleVersion(@NotNull Throwable error) {
        if (error == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(3);
        }
        String msg = error.getMessage();
        if (error instanceof UnsupportedVersionException) {
            return true;
        }
        if (error instanceof UnsupportedMethodException && msg != null && msg.contains("GradleProject.getBuildScript")) {
            return true;
        }
        return error instanceof ClassNotFoundException && msg != null && msg.contains(ToolingModelBuilderRegistry.class.getName());
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull NotificationData notification, @NotNull Project project, @NotNull String text) {
        if (notification == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(4);
        }
        if (project == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(5);
        }
        if (text == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(6);
        }
        String gradleVersion = UnsupportedGradleVersionErrorHandler.getSupportedGradleVersion(UnsupportedGradleVersionErrorHandler.getFirstLineMessage(text));
        List<NotificationHyperlink> list = UnsupportedGradleVersionErrorHandler.getQuickFixHyperlinks(project, gradleVersion);
        if (list == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    private static String getSupportedGradleVersion(@NotNull String message) {
        if (message == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(8);
        }
        return UnsupportedGradleVersionErrorHandler.getSupportedGradleVersion(message, UNSUPPORTED_GRADLE_VERSION_PATTERN_1, UNSUPPORTED_GRADLE_VERSION_PATTERN_2);
    }

    @Nullable
    private static String getSupportedGradleVersion(@NotNull String message, Pattern ... patterns) {
        if (message == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(9);
        }
        if (patterns == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(10);
        }
        for (Pattern pattern : patterns) {
            String version;
            Matcher matcher = pattern.matcher(message);
            if (!matcher.matches() || !StringUtil.isNotEmpty((String)(version = matcher.group(1)))) continue;
            return version;
        }
        return null;
    }

    @NotNull
    public static List<NotificationHyperlink> getQuickFixHyperlinks(@NotNull Project project, @Nullable String gradleVersion) {
        if (project == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(11);
        }
        ArrayList<NotificationHyperlink> hyperlinks = new ArrayList<NotificationHyperlink>();
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        if (gradleWrapper != null) {
            NotificationHyperlink hyperlink = FixGradleVersionInWrapperHyperlink.createIfProjectUsesGradleWrapper(project, gradleVersion);
            if (hyperlink != null) {
                hyperlinks.add(hyperlink);
            }
        } else {
            GradleProjectSettings gradleProjectSettings = GradleProjectSettingsFinder.getInstance().findGradleProjectSettings(project);
            if (gradleProjectSettings != null && gradleProjectSettings.getDistributionType() == DistributionType.LOCAL) {
                hyperlinks.add(new CreateGradleWrapperHyperlink());
            }
        }
        hyperlinks.add(new OpenGradleSettingsHyperlink());
        ArrayList<NotificationHyperlink> arrayList = hyperlinks;
        if (arrayList == null) {
            UnsupportedGradleVersionErrorHandler.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCause";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 2: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/UnsupportedGradleVersionErrorHandler";
                break;
            }
            case 7: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixHyperlinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findErrorMessage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOldGradleVersion";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixHyperlinks";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedGradleVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

