/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InstallCMakeHyperlink
extends NotificationHyperlink {
    public InstallCMakeHyperlink() {
        super("install.cmake", "Install CMake and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            InstallCMakeHyperlink.$$$reportNull$$$0(0);
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(this.getClass());
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)progressIndicator);
        StudioProgressRunner progressRunner = new StudioProgressRunner(false, false, "Loading Remote SDK", true, project);
        RepoManager.RepoLoadedCallback onComplete = packages -> {
            Collection cmakePackages;
            if (project == null) {
                InstallCMakeHyperlink.$$$reportNull$$$0(3);
            }
            if (!(cmakePackages = packages.getRemotePackagesForPrefix("cmake")).isEmpty()) {
                RemotePackage cmakePackage = cmakePackages.size() == 1 ? (RemotePackage)ContainerUtil.getFirstItem((Collection)cmakePackages) : sdkHandler.getLatestRemotePackageForPrefix("cmake", false, (ProgressIndicator)progressIndicator);
                if (cmakePackage != null) {
                    ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)cmakePackage.getPath()));
                    if (dialog != null && dialog.showAndGet()) {
                        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
                    }
                    return;
                }
                InstallCMakeHyperlink.notifyCMakePackageNotFound(project);
            }
        };
        Runnable onError = () -> {
            if (project == null) {
                InstallCMakeHyperlink.$$$reportNull$$$0(2);
            }
            InstallCMakeHyperlink.notifyCMakePackageNotFound(project);
        };
        sdkManager.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)progressRunner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private static void notifyCMakePackageNotFound(@NotNull Project project) {
        if (project == null) {
            InstallCMakeHyperlink.$$$reportNull$$$0(1);
        }
        Messages.showErrorDialog((Project)project, (String)"Failed to obtain CMake package", (String)"Gradle Sync");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/InstallCMakeHyperlink";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyCMakePackageNotFound";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$1";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

