/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.precheck.AndroidStudioSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JdkPreSyncCheck
extends AndroidStudioSyncCheck {
    JdkPreSyncCheck() {
    }

    @Override
    @NotNull
    PreSyncCheckResult doCheckCanSync(@NotNull Project project) {
        Sdk jdk;
        if (project == null) {
            JdkPreSyncCheck.$$$reportNull$$$0(0);
        }
        if (!JdkPreSyncCheck.isValidJdk(jdk = IdeSdks.getInstance().getJdk())) {
            String msg = "Please use JDK 8 or newer.";
            SyncMessage message = new SyncMessage("Project sync error", MessageType.ERROR, msg);
            List<NotificationHyperlink> quickFixes = Jdks.getInstance().getWrongJdkQuickFixes(project);
            message.add(quickFixes);
            SyncMessages.getInstance(project).report(message);
            PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.failure(msg);
            if (preSyncCheckResult == null) {
                JdkPreSyncCheck.$$$reportNull$$$0(1);
            }
            return preSyncCheckResult;
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.SUCCESS;
        if (preSyncCheckResult == null) {
            JdkPreSyncCheck.$$$reportNull$$$0(2);
        }
        return preSyncCheckResult;
    }

    private static boolean isValidJdk(Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        String jdkHomePath = jdk.getHomePath();
        return jdkHomePath != null && JdkUtil.checkForJdk((File)new File(jdkHomePath)) && Jdks.getInstance().isApplicableJdk(jdk, LanguageLevel.JDK_1_8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/precheck/JdkPreSyncCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/precheck/JdkPreSyncCheck";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doCheckCanSync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCheckCanSync";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

