/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidAtom;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Sets;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesExtractor {
    @NotNull
    public static DependenciesExtractor getInstance() {
        DependenciesExtractor dependenciesExtractor = (DependenciesExtractor)ServiceManager.getService(DependenciesExtractor.class);
        if (dependenciesExtractor == null) {
            DependenciesExtractor.$$$reportNull$$$0(0);
        }
        return dependenciesExtractor;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            DependenciesExtractor.$$$reportNull$$$0(1);
        }
        DependencySet dependencies = new DependencySet();
        GradleVersion modelVersion = androidModel.getModelVersion();
        for (BaseArtifact testArtifact : androidModel.getTestArtifactsInSelectedVariant()) {
            DependenciesExtractor.populate(dependencies, testArtifact, DependencyScope.TEST, modelVersion);
        }
        AndroidArtifact mainArtifact = androidModel.getMainArtifact();
        DependenciesExtractor.populate(dependencies, (BaseArtifact)mainArtifact, DependencyScope.COMPILE, modelVersion);
        DependencySet dependencySet = dependencies;
        if (dependencySet == null) {
            DependenciesExtractor.$$$reportNull$$$0(2);
        }
        return dependencySet;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull BaseArtifact artifact, @NotNull DependencyScope scope, @Nullable GradleVersion modelVersion) {
        if (artifact == null) {
            DependenciesExtractor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(4);
        }
        DependencySet dependencies = new DependencySet();
        DependenciesExtractor.populate(dependencies, artifact, scope, modelVersion);
        DependencySet dependencySet = dependencies;
        if (dependencySet == null) {
            DependenciesExtractor.$$$reportNull$$$0(5);
        }
        return dependencySet;
    }

    private static void populate(@NotNull DependencySet dependencies, @NotNull BaseArtifact artifact, @NotNull DependencyScope scope, @Nullable GradleVersion modelVersion) {
        if (dependencies == null) {
            DependenciesExtractor.$$$reportNull$$$0(6);
        }
        if (artifact == null) {
            DependenciesExtractor.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(8);
        }
        Dependencies artifactDependencies = GradleUtil.getDependencies(artifact, modelVersion);
        boolean supportsInstantApps = modelVersion != null && GradleUtil.androidModelSupportsInstantApps(modelVersion);
        DependenciesExtractor.addJavaLibraries(dependencies, artifactDependencies.getJavaLibraries(), scope);
        HashSet unique = Sets.newHashSet();
        for (AndroidLibrary library : artifactDependencies.getLibraries()) {
            DependenciesExtractor.addAndroidLibrary(library, dependencies, scope, unique);
        }
        if (supportsInstantApps) {
            Collection atoms = null;
            try {
                atoms = artifactDependencies.getAtoms();
            }
            catch (Throwable e) {
                DependenciesExtractor.getLogger().warn("Android plugin version " + modelVersion.toString() + " should support Atoms", e);
            }
            if (atoms != null) {
                for (AndroidAtom androidAtom : atoms) {
                    DependenciesExtractor.addAndroidAtom(androidAtom, dependencies, scope, unique);
                }
            }
        }
        for (String gradleProjectPath : artifactDependencies.getProjects()) {
            if (gradleProjectPath == null || gradleProjectPath.isEmpty()) continue;
            ModuleDependency dependency = new ModuleDependency(gradleProjectPath, scope);
            dependencies.add(dependency);
        }
    }

    @NotNull
    private static String getBundleName(@NotNull com.android.builder.model.AndroidBundle bundle) {
        MavenCoordinates coordinates;
        if (bundle == null) {
            DependenciesExtractor.$$$reportNull$$$0(9);
        }
        if ((coordinates = bundle.getResolvedCoordinates()) != null) {
            String string = coordinates.getArtifactId() + "-" + coordinates.getVersion();
            if (string == null) {
                DependenciesExtractor.$$$reportNull$$$0(10);
            }
            return string;
        }
        File bundleFile = bundle.getBundle();
        String string = FileUtil.getNameWithoutExtension((File)bundleFile);
        if (string == null) {
            DependenciesExtractor.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static boolean isAlreadySeen(@NotNull com.android.builder.model.AndroidBundle bundle, @NotNull Set<File> unique) {
        File folder;
        if (bundle == null) {
            DependenciesExtractor.$$$reportNull$$$0(12);
        }
        if (unique == null) {
            DependenciesExtractor.$$$reportNull$$$0(13);
        }
        if (unique.contains(folder = bundle.getFolder())) {
            return true;
        }
        unique.add(folder);
        return false;
    }

    private static void addAndroidLibrary(@NotNull AndroidLibrary library, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique) {
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(14);
        }
        if (dependencies == null) {
            DependenciesExtractor.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(16);
        }
        if (unique == null) {
            DependenciesExtractor.$$$reportNull$$$0(17);
        }
        if (DependenciesExtractor.isAlreadySeen((com.android.builder.model.AndroidBundle)library, unique)) {
            return;
        }
        String gradleProjectPath = library.getProject();
        if (StringUtil.isNotEmpty((String)gradleProjectPath)) {
            ModuleDependency dependency = new ModuleDependency(gradleProjectPath, scope);
            dependency.setBackupDependency(DependenciesExtractor.createLibraryDependencyFromAndroidLibrary(library, scope));
            dependencies.add(dependency);
        } else {
            dependencies.add(DependenciesExtractor.createLibraryDependencyFromAndroidLibrary(library, scope));
        }
        DependenciesExtractor.addBundleTransitiveDependencies((com.android.builder.model.AndroidBundle)library, dependencies, scope, unique);
    }

    private static void addAndroidAtom(@NotNull AndroidAtom atom, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique) {
        if (atom == null) {
            DependenciesExtractor.$$$reportNull$$$0(18);
        }
        if (dependencies == null) {
            DependenciesExtractor.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(20);
        }
        if (unique == null) {
            DependenciesExtractor.$$$reportNull$$$0(21);
        }
        if (DependenciesExtractor.isAlreadySeen((com.android.builder.model.AndroidBundle)atom, unique)) {
            return;
        }
        String gradleProjectPath = atom.getProject();
        if (StringUtil.isEmpty((String)gradleProjectPath)) {
            DependenciesExtractor.getLogger().error(AndroidBundle.message("android.gradle.dependency.atom.invalid.external", atom.getName()));
        } else {
            dependencies.add(new ModuleDependency(gradleProjectPath, scope));
            DependenciesExtractor.addAtomTransitiveDependencies(atom, dependencies, scope, unique);
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(DependenciesExtractor.class);
        if (logger == null) {
            DependenciesExtractor.$$$reportNull$$$0(22);
        }
        return logger;
    }

    private static void addBundleTransitiveDependencies(@NotNull com.android.builder.model.AndroidBundle bundle, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique) {
        if (bundle == null) {
            DependenciesExtractor.$$$reportNull$$$0(23);
        }
        if (dependencies == null) {
            DependenciesExtractor.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(25);
        }
        if (unique == null) {
            DependenciesExtractor.$$$reportNull$$$0(26);
        }
        for (AndroidLibrary dependentLibrary : bundle.getLibraryDependencies()) {
            DependenciesExtractor.addAndroidLibrary(dependentLibrary, dependencies, scope, unique);
        }
    }

    private static void addAtomTransitiveDependencies(@NotNull AndroidAtom atom, @NotNull DependencySet dependencies, @NotNull DependencyScope scope, @NotNull Set<File> unique) {
        if (atom == null) {
            DependenciesExtractor.$$$reportNull$$$0(27);
        }
        if (dependencies == null) {
            DependenciesExtractor.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(29);
        }
        if (unique == null) {
            DependenciesExtractor.$$$reportNull$$$0(30);
        }
        for (AndroidAtom dependentAtom : atom.getAtomDependencies()) {
            DependenciesExtractor.addAndroidAtom(dependentAtom, dependencies, scope, unique);
        }
        DependenciesExtractor.addBundleTransitiveDependencies((com.android.builder.model.AndroidBundle)atom, dependencies, scope, unique);
    }

    @NotNull
    private static LibraryDependency createLibraryDependencyFromAndroidLibrary(@NotNull AndroidLibrary library, @NotNull DependencyScope scope) {
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(31);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(32);
        }
        LibraryDependency dependency = new LibraryDependency(library.getBundle(), DependenciesExtractor.getBundleName((com.android.builder.model.AndroidBundle)library), scope);
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getJarFile());
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getResFolder());
        for (File localJar : library.getLocalJars()) {
            dependency.addPath(LibraryDependency.PathType.BINARY, localJar);
        }
        LibraryDependency libraryDependency = dependency;
        if (libraryDependency == null) {
            DependenciesExtractor.$$$reportNull$$$0(33);
        }
        return libraryDependency;
    }

    private static void addJavaLibraries(@NotNull DependencySet dependencies, @NotNull Collection<? extends JavaLibrary> libraries, @NotNull DependencyScope scope) {
        if (dependencies == null) {
            DependenciesExtractor.$$$reportNull$$$0(34);
        }
        if (libraries == null) {
            DependenciesExtractor.$$$reportNull$$$0(35);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(36);
        }
        for (JavaLibrary javaLibrary : libraries) {
            DependenciesExtractor.addJavaLibrary(javaLibrary, dependencies, scope);
        }
    }

    private static void addJavaLibrary(@NotNull JavaLibrary library, @NotNull DependencySet dependencies, @NotNull DependencyScope scope) {
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(37);
        }
        if (dependencies == null) {
            DependenciesExtractor.$$$reportNull$$$0(38);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(39);
        }
        dependencies.add(DependenciesExtractor.createLibraryDependencyFromJavaLibrary(library, scope));
        DependenciesExtractor.addJavaLibraries(dependencies, library.getDependencies(), scope);
    }

    @NotNull
    private static LibraryDependency createLibraryDependencyFromJavaLibrary(@NotNull JavaLibrary library, @NotNull DependencyScope scope) {
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(40);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(41);
        }
        File jarFilePath = library.getJarFile();
        LibraryDependency libraryDependency = new LibraryDependency(jarFilePath, scope);
        if (libraryDependency == null) {
            DependenciesExtractor.$$$reportNull$$$0(42);
        }
        return libraryDependency;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 20: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: 
            case 15: 
            case 19: 
            case 24: 
            case 28: 
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 9: 
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 13: 
            case 17: 
            case 21: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unique";
                break;
            }
            case 14: 
            case 31: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atom";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractFrom";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundleName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryDependencyFromAndroidLibrary";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryDependencyFromJavaLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractFrom";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBundleName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadySeen";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidLibrary";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidAtom";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addBundleTransitiveDependencies";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addAtomTransitiveDependencies";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryDependencyFromAndroidLibrary";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addJavaLibraries";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addJavaLibrary";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryDependencyFromJavaLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

