/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class MavenCentralRepository
extends ArtifactRepository {
    @Override
    @NotNull
    public String getName() {
        if ("Maven Central" == null) {
            MavenCentralRepository.$$$reportNull$$$0(0);
        }
        return "Maven Central";
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request) throws Exception {
        if (request == null) {
            MavenCentralRepository.$$$reportNull$$$0(1);
        }
        String url = MavenCentralRepository.createRequestUrl(request);
        SearchResult searchResult = (SearchResult)HttpRequests.request((String)url).accept("application/xml").connect(request1 -> {
            try {
                return this.parse(request1.getReader());
            }
            catch (JDOMException e) {
                String msg = String.format("Failed to parse request '%1$s'", request1);
                throw new IOException(msg, e);
            }
        });
        if (searchResult == null) {
            MavenCentralRepository.$$$reportNull$$$0(2);
        }
        return searchResult;
    }

    @VisibleForTesting
    @NotNull
    static String createRequestUrl(@NotNull SearchRequest request) {
        if (request == null) {
            MavenCentralRepository.$$$reportNull$$$0(3);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("https://search.maven.org/solrsearch/select?").append("rows=").append(request.getRowCount()).append("&").append("start=").append(request.getStart()).append("&").append("wt=xml&").append("q=");
        String groupId = request.getGroupId();
        if (StringUtil.isNotEmpty((String)groupId)) {
            buffer.append("g:\"").append(groupId).append("\"+AND+");
        }
        buffer.append("a:\"").append(request.getArtifactName()).append("\"");
        String string = buffer.toString();
        if (string == null) {
            MavenCentralRepository.$$$reportNull$$$0(4);
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    SearchResult parse(@NotNull Reader response) throws JDOMException, IOException {
        if (response == null) {
            MavenCentralRepository.$$$reportNull$$$0(5);
        }
        ArrayList artifacts = Lists.newArrayList();
        int totalFound = 0;
        Element root = JdomKt.loadElement((Reader)response);
        Element result = root.getChild("result");
        if (result != null) {
            String found = result.getAttributeValue("numFound");
            if (StringUtil.isNotEmpty((String)found)) {
                try {
                    totalFound = Integer.parseInt(found);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            block2: for (Element doc : result.getChildren("doc")) {
                String id = null;
                GradleVersion latestVersion = null;
                for (Element str : doc.getChildren("str")) {
                    String value;
                    String name = str.getAttributeValue("name");
                    if ("id".equals(name)) {
                        id = str.getTextTrim();
                    } else if ("latestVersion".equals(name) && StringUtil.isNotEmpty((String)(value = str.getTextTrim()))) {
                        latestVersion = GradleVersion.parse((String)value);
                    }
                    if (!StringUtil.isNotEmpty((String)id) || latestVersion == null) continue;
                    List coordinate = Splitter.on((String)":").splitToList((CharSequence)id);
                    assert (coordinate.size() == 2);
                    artifacts.add(new FoundArtifact(this.getName(), (String)coordinate.get(0), (String)coordinate.get(1), latestVersion));
                    continue block2;
                }
            }
        }
        SearchResult searchResult = new SearchResult(this.getName(), artifacts, totalFound);
        if (searchResult == null) {
            MavenCentralRepository.$$$reportNull$$$0(6);
        }
        return searchResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/repositories/search/MavenCentralRepository";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/repositories/search/MavenCentralRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doSearch";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doSearch";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRequestUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

