/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifest;
import com.intellij.openapi.module.Module;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleInfo {
    @NotNull
    private final AndroidFacet myFacet;

    private AndroidModuleInfo(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidModuleInfo.$$$reportNull$$$0(0);
        }
        this.myFacet = facet;
    }

    @NotNull
    public static AndroidModuleInfo create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidModuleInfo.$$$reportNull$$$0(1);
        }
        AndroidModuleInfo androidModuleInfo = new AndroidModuleInfo(facet);
        if (androidModuleInfo == null) {
            AndroidModuleInfo.$$$reportNull$$$0(2);
        }
        return androidModuleInfo;
    }

    @NotNull
    public static AndroidModuleInfo get(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidModuleInfo.$$$reportNull$$$0(3);
        }
        AndroidModuleInfo androidModuleInfo = facet.getAndroidModuleInfo();
        if (androidModuleInfo == null) {
            AndroidModuleInfo.$$$reportNull$$$0(4);
        }
        return androidModuleInfo;
    }

    @Nullable
    public static AndroidModuleInfo get(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            AndroidModuleInfo.$$$reportNull$$$0(5);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? facet.getAndroidModuleInfo() : null;
    }

    @Nullable
    public String getPackage() {
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null) {
            return androidModel.getApplicationId();
        }
        return MergedManifest.get(this.myFacet).getApplicationId();
    }

    @NotNull
    public AndroidVersion getRuntimeMinSdkVersion() {
        AndroidVersion minSdkVersion;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (minSdkVersion = androidModel.getRuntimeMinSdkVersion()) != null) {
            AndroidVersion androidVersion = minSdkVersion;
            if (androidVersion == null) {
                AndroidModuleInfo.$$$reportNull$$$0(6);
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = MergedManifest.get(this.myFacet).getMinSdkVersion();
        if (androidVersion == null) {
            AndroidModuleInfo.$$$reportNull$$$0(7);
        }
        return androidVersion;
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion minSdkVersion;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (minSdkVersion = androidModel.getMinSdkVersion()) != null) {
            AndroidVersion androidVersion = minSdkVersion;
            if (androidVersion == null) {
                AndroidModuleInfo.$$$reportNull$$$0(8);
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = MergedManifest.get(this.myFacet).getMinSdkVersion();
        if (androidVersion == null) {
            AndroidModuleInfo.$$$reportNull$$$0(9);
        }
        return androidVersion;
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion targetSdkVersion;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (targetSdkVersion = androidModel.getTargetSdkVersion()) != null) {
            AndroidVersion androidVersion = targetSdkVersion;
            if (androidVersion == null) {
                AndroidModuleInfo.$$$reportNull$$$0(10);
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = MergedManifest.get(this.myFacet).getTargetSdkVersion();
        if (androidVersion == null) {
            AndroidModuleInfo.$$$reportNull$$$0(11);
        }
        return androidVersion;
    }

    @Nullable
    public AndroidVersion getBuildSdkVersion() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
        if (platform != null) {
            return platform.getApiVersion();
        }
        return null;
    }

    @Nullable
    public Boolean isDebuggable() {
        Boolean debuggable;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (debuggable = androidModel.isDebuggable()) != null) {
            return debuggable;
        }
        return MergedManifest.get(this.myFacet).getApplicationDebuggable();
    }

    @Nullable
    public static AndroidVersion getBuildSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            return moduleInfo.getBuildSdkVersion();
        }
        return null;
    }

    public static int getBuildSdkApiLevel(@Nullable Module module) {
        AndroidVersion version = AndroidModuleInfo.getBuildSdkVersion(module);
        return version != null ? version.getApiLevel() : -1;
    }

    @NotNull
    public static AndroidVersion getTargetSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            AndroidVersion androidVersion = moduleInfo.getTargetSdkVersion();
            if (androidVersion == null) {
                AndroidModuleInfo.$$$reportNull$$$0(12);
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = AndroidVersion.DEFAULT;
        if (androidVersion == null) {
            AndroidModuleInfo.$$$reportNull$$$0(13);
        }
        return androidVersion;
    }

    @NotNull
    public static AndroidVersion getMinSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            AndroidVersion androidVersion = moduleInfo.getMinSdkVersion();
            if (androidVersion == null) {
                AndroidModuleInfo.$$$reportNull$$$0(14);
            }
            return androidVersion;
        }
        AndroidVersion androidVersion = AndroidVersion.DEFAULT;
        if (androidVersion == null) {
            AndroidModuleInfo.$$$reportNull$$$0(15);
        }
        return androidVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/model/AndroidModuleInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/model/AndroidModuleInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeMinSdkVersion";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinSdkVersion";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSdkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

