/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.network;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.adtui.TimelineData;
import com.android.tools.idea.monitor.DeviceSampler;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class NetworkSampler
extends DeviceSampler {
    public static final String NETWORK_STATS_FILE = "/proc/net/xt_qtaguid/stats";
    private static final int TIMELINE_DATA_STREAM_SIZE = 2;
    private static final int TIMELINE_DATA_SIZE = 2048;
    private static final int MAX_TIMEOUT_SECOND = 1;
    private static final String LINE_SPLIT_REGEX = "[ \t\r\n\f]";
    private int myUid;
    private long myStartingRxBytes;
    private long myStartingTxBytes;

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(DeviceSampler.class);
        if (logger == null) {
            NetworkSampler.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public NetworkSampler(int frequencyMs) {
        super(new TimelineData(2, 2048, (TimelineData.SampleTransform)new TimelineData.AreaTransform()), frequencyMs);
    }

    @Override
    @NotNull
    public String getName() {
        if ("Network Sampler" == null) {
            NetworkSampler.$$$reportNull$$$0(1);
        }
        return "Network Sampler";
    }

    @Override
    public void start() {
        this.myUid = -1;
        this.myStartingRxBytes = -1L;
        this.myStartingTxBytes = -1L;
        super.start();
    }

    public int checkStatsFile(@NotNull Client client) {
        if (client == null) {
            NetworkSampler.$$$reportNull$$$0(2);
        }
        if (this.getClient() != client) {
            return 0;
        }
        IDevice device = client.getDevice();
        if (device == null || device.isOffline()) {
            return -1;
        }
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            device.executeShellCommand("ls /proc/net/xt_qtaguid/stats", (IShellOutputReceiver)receiver);
            return receiver.getOutput().contains("No such file") ? -1 : 1;
        }
        catch (TimeoutException timeoutException) {
            NetworkSampler.getLog().warn(String.format("TimeoutException %1$s in ls %2$s", timeoutException.getMessage(), NETWORK_STATS_FILE));
        }
        catch (AdbCommandRejectedException rejectedException) {
            NetworkSampler.getLog().warn(String.format("AdbCommandRejectedException %1$s in ls %2$s", rejectedException.getMessage(), NETWORK_STATS_FILE));
        }
        catch (ShellCommandUnresponsiveException unresponsiveException) {
            NetworkSampler.getLog().warn(String.format("ShellCommandUnresponsiveException %1$s in ls %2$s", unresponsiveException.getMessage(), NETWORK_STATS_FILE));
        }
        catch (IOException ioException) {
            NetworkSampler.getLog().warn(String.format("IOException %1$s in ls %2$s", ioException.getMessage(), NETWORK_STATS_FILE));
        }
        return 0;
    }

    @Override
    protected void sample(boolean forced) throws InterruptedException {
        IDevice device;
        Client client = this.getClient();
        IDevice iDevice = device = client != null ? client.getDevice() : null;
        if (device == null) {
            return;
        }
        if (this.myUid < 0) {
            int pid = client.getClientData().getPid();
            this.myUid = NetworkSampler.getUidFromPid(pid, device);
            if (this.myUid < 0) {
                return;
            }
        }
        NetworkStatsReceiver receiver = new NetworkStatsReceiver(this.myUid);
        String command = "cat /proc/net/xt_qtaguid/stats | grep " + receiver.getUid();
        int myDataType = 1;
        try {
            device.executeShellCommand(command, (IShellOutputReceiver)receiver, 1L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            myDataType = 2;
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | IOException ignored) {
            myDataType = 0;
        }
        if (receiver.isFileMissing() || myDataType != 1) {
            return;
        }
        if (this.myStartingRxBytes < 0L) {
            this.myStartingRxBytes = receiver.getRxBytes();
            this.myStartingTxBytes = receiver.getTxBytes();
        } else {
            this.getTimelineData().add(System.currentTimeMillis(), myDataType, new float[]{(float)(receiver.getRxBytes() - this.myStartingRxBytes) / 1024.0f, (float)(receiver.getTxBytes() - this.myStartingTxBytes) / 1024.0f});
        }
    }

    private static int getUidFromPid(int pid, IDevice device) {
        UidReceiver uidReceiver = new UidReceiver();
        try {
            device.executeShellCommand("cat /proc/" + pid + "/status", (IShellOutputReceiver)uidReceiver, 1L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            NetworkSampler.getLog().warn(String.format("TimeoutException to get uid from pid %d", pid));
        }
        catch (AdbCommandRejectedException commandRejectedException) {
            NetworkSampler.getLog().warn(String.format("AdbCommandRejectedException to get uid from pid %d", pid));
        }
        catch (ShellCommandUnresponsiveException commandUnresponsiveException) {
            NetworkSampler.getLog().warn(String.format("ShellCommandUnresponsiveException to get uid from pid %d", pid));
        }
        catch (IOException ioException) {
            NetworkSampler.getLog().warn(String.format("IOException to get uid from pid %d", pid));
        }
        return uidReceiver.getUid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/network/NetworkSampler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/network/NetworkSampler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkStatsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NetworkStatsReceiver
    extends MultiLineReceiver {
        private static int INDEX_OF_UID = 3;
        private static int INDEX_OF_RX_BYTES = 5;
        private static int INDEX_OF_TX_BYTES = 7;
        private final int myUid;
        private long myRxBytes;
        private long myTxBytes;
        private boolean myIsFileMissing;

        public NetworkStatsReceiver(int uid) {
            this.myUid = uid;
            this.myRxBytes = 0L;
            this.myTxBytes = 0L;
            this.myIsFileMissing = false;
        }

        public int getUid() {
            return this.myUid;
        }

        public long getRxBytes() {
            return this.myRxBytes;
        }

        public long getTxBytes() {
            return this.myTxBytes;
        }

        public boolean isFileMissing() {
            return this.myIsFileMissing;
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                if (line.startsWith("idx")) continue;
                if (line.contains("No such file")) {
                    this.myIsFileMissing = true;
                    return;
                }
                String[] values = line.split(NetworkSampler.LINE_SPLIT_REGEX);
                if (values.length < INDEX_OF_TX_BYTES) continue;
                try {
                    int lineUid = Integer.parseInt(values[INDEX_OF_UID]);
                    if (this.myUid != lineUid) continue;
                    int tempRxBytes = Integer.parseInt(values[INDEX_OF_RX_BYTES]);
                    int tempTxBytes = Integer.parseInt(values[INDEX_OF_TX_BYTES]);
                    if (tempRxBytes < 0 || tempTxBytes < 0) {
                        NetworkSampler.getLog().warn(String.format("Negative rxBytes %1$d and/or txBytes %2$d in %3$s", tempRxBytes, tempTxBytes, line));
                        continue;
                    }
                    this.myRxBytes += (long)tempRxBytes;
                    this.myTxBytes += (long)tempTxBytes;
                }
                catch (NumberFormatException e) {
                    NetworkSampler.getLog().warn(String.format("Expected int value, instead got uid %1$s, rxBytes %2$s, txBytes %3$s in %4$s", values[INDEX_OF_UID], values[INDEX_OF_RX_BYTES], values[INDEX_OF_TX_BYTES], line));
                }
            }
        }

        public boolean isCancelled() {
            return false;
        }
    }

    private static class UidReceiver
    extends MultiLineReceiver {
        private static final int INDEX_OF_EFFECTIVE_USER_ID = 1;
        private int myUid = -1;

        public int getUid() {
            return this.myUid;
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                if (!line.startsWith("Uid:")) continue;
                String[] values = line.split(NetworkSampler.LINE_SPLIT_REGEX);
                if (values.length <= 1) {
                    NetworkSampler.getLog().warn(String.format("NumberFormatException %1$s \n length %2$d", line, values.length));
                    return;
                }
                try {
                    this.myUid = Integer.parseInt(values[1]);
                }
                catch (NumberFormatException e) {
                    NetworkSampler.getLog().warn(String.format("NumberFormatException %1$s in %2$s", e.getMessage(), line));
                }
                break;
            }
        }

        public boolean isCancelled() {
            return false;
        }
    }
}

