/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.view;

import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.common.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.memory.model.AllocationTrackingSample;
import com.android.tools.idea.monitor.ui.memory.model.MemoryDataCache;
import com.android.tools.idea.monitor.ui.memory.view.ClassHistogramView;
import com.android.tools.idea.monitor.ui.memory.view.MemoryProfilerUiManager;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MemoryDetailView
implements Disposable {
    @NotNull
    private final JPanel myParent;
    @NotNull
    private final SeriesDataStore myDataStore;
    @NotNull
    private final Range myRange;
    @NotNull
    private final Choreographer myChoreographer;
    @NotNull
    private final EventDispatcher<ProfilerEventListener> myProfilerEventDispatcher;
    @NotNull
    private final List<HeapDumpInfoEntryFormatter> myHeapDumpEntries;
    @Nullable
    private ClassHistogramView myClassHistogramView;
    @Nullable
    private MemoryDataCache myDataCache;
    @NotNull
    private ComboBox<AbstractInfoEntryFormatter> myMainSampleSelector;
    @NotNull
    private ComboBox<AbstractInfoEntryFormatter> myDiffSampleSelector;
    @NotNull
    private AbstractInfoEntryFormatter myCurrentMainEntry;
    @NotNull
    private AbstractInfoEntryFormatter myCurrentDiffEntry;
    private final AbstractInfoEntryFormatter DEFAULT_MAIN_ENTRY;
    private final AbstractInfoEntryFormatter DEFAULT_DIFF_ENTRY;

    MemoryDetailView(@NotNull JPanel parent, @NotNull SeriesDataStore dataStore, @Nullable MemoryDataCache dataCache, @NotNull Range range, @NotNull Choreographer choreographer, @NotNull EventDispatcher<ProfilerEventListener> profilerEventDispatcher, @NotNull EventDispatcher<MemoryProfilerUiManager.MemoryEventListener> memoryEventDispatcher) {
        if (parent == null) {
            MemoryDetailView.$$$reportNull$$$0(0);
        }
        if (dataStore == null) {
            MemoryDetailView.$$$reportNull$$$0(1);
        }
        if (range == null) {
            MemoryDetailView.$$$reportNull$$$0(2);
        }
        if (choreographer == null) {
            MemoryDetailView.$$$reportNull$$$0(3);
        }
        if (profilerEventDispatcher == null) {
            MemoryDetailView.$$$reportNull$$$0(4);
        }
        if (memoryEventDispatcher == null) {
            MemoryDetailView.$$$reportNull$$$0(5);
        }
        this.myHeapDumpEntries = new ArrayList<HeapDumpInfoEntryFormatter>();
        this.myClassHistogramView = null;
        this.myDataCache = null;
        this.DEFAULT_MAIN_ENTRY = new AbstractInfoEntryFormatter(){

            @Override
            public String toString() {
                return MemoryDetailView.this.myMainSampleSelector.getModel().getSize() == 1 && MemoryDetailView.this.myMainSampleSelector.getSelectedItem() == this ? "No sample to display" : "Select a sample";
            }
        };
        this.DEFAULT_DIFF_ENTRY = new AbstractInfoEntryFormatter(){

            @Override
            public String toString() {
                if (MemoryDetailView.this.myDiffSampleSelector.getSelectedItem() == null) {
                    return "";
                }
                if (MemoryDetailView.this.myMainSampleSelector.getSelectedItem() == MemoryDetailView.this.DEFAULT_MAIN_ENTRY) {
                    if (MemoryDetailView.this.myMainSampleSelector.getModel().getSize() > 1) {
                        return "<-- Select a sample";
                    }
                    return "No sample to display";
                }
                if (MemoryDetailView.this.myMainSampleSelector.getSelectedItem() instanceof HeapDumpInfoEntryFormatter) {
                    if (MemoryDetailView.this.myDiffSampleSelector.getModel().getSize() == 1) {
                        return "No sample to diff against";
                    }
                    if (MemoryDetailView.this.myDiffSampleSelector.getSelectedItem() == this) {
                        return "Select heap dump to diff";
                    }
                    return "Select this to analyze heap dump";
                }
                return "Viewing allocations";
            }
        };
        this.myParent = parent;
        this.myDataStore = dataStore;
        this.myRange = range;
        this.myChoreographer = choreographer;
        this.myProfilerEventDispatcher = profilerEventDispatcher;
        memoryEventDispatcher.addListener((EventListener)new MemoryProfilerUiManager.MemoryEventListener(){

            @Override
            public void newHeapDumpInfosRetrieved(MemoryProfiler.HeapDumpInfo newInfo) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    HeapDumpInfoEntryFormatter entry = MemoryDetailView.this.addHeapDumpInfo(newInfo);
                    if (MemoryDetailView.this.myMainSampleSelector.getSelectedItem() == MemoryDetailView.this.DEFAULT_MAIN_ENTRY) {
                        MemoryDetailView.this.myMainSampleSelector.setSelectedItem((Object)entry);
                    }
                });
            }

            @Override
            public void newAllocationTrackingInfosRetrieved(AllocationTrackingSample newInfo) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    AllocationTrackingInfoEntryFormatter entry = MemoryDetailView.this.addAllocationTrackingSample(newInfo);
                    if (MemoryDetailView.this.myMainSampleSelector.getSelectedItem() == MemoryDetailView.this.DEFAULT_MAIN_ENTRY) {
                        MemoryDetailView.this.myMainSampleSelector.setSelectedItem((Object)entry);
                    }
                });
            }
        }, (Disposable)this);
        JBPanel toolbar = new JBPanel((LayoutManager)new HorizontalLayout(JBUI.scale((int)5)));
        this.myMainSampleSelector = new ComboBox();
        this.myMainSampleSelector.addItem((Object)this.DEFAULT_MAIN_ENTRY);
        this.myMainSampleSelector.setSelectedItem((Object)this.DEFAULT_MAIN_ENTRY);
        this.myCurrentMainEntry = this.DEFAULT_MAIN_ENTRY;
        this.myDiffSampleSelector = new ComboBox();
        this.myDiffSampleSelector.addItem((Object)this.DEFAULT_DIFF_ENTRY);
        this.myDiffSampleSelector.setSelectedItem((Object)this.DEFAULT_DIFF_ENTRY);
        this.myCurrentDiffEntry = this.DEFAULT_DIFF_ENTRY;
        toolbar.add("LEFT", (Component)this.myMainSampleSelector);
        toolbar.add("LEFT", (Component)this.myDiffSampleSelector);
        this.myParent.add((Component)toolbar, "North");
        if (dataCache != null) {
            this.notifyDataIsReady(dataCache);
        }
    }

    void notifyDataIsReady(@NotNull MemoryDataCache dataCache) {
        if (dataCache == null) {
            MemoryDetailView.$$$reportNull$$$0(6);
        }
        if (this.myDataCache == dataCache) {
            return;
        }
        this.myMainSampleSelector.addActionListener(e -> {
            if (dataCache == null) {
                MemoryDetailView.$$$reportNull$$$0(16);
            }
            if (this.myMainSampleSelector.getSelectedItem() == null) {
                return;
            }
            assert (this.myMainSampleSelector.getSelectedItem() instanceof AbstractInfoEntryFormatter);
            AbstractInfoEntryFormatter selectedEntry = (AbstractInfoEntryFormatter)this.myMainSampleSelector.getSelectedItem();
            this.updateOnMainEntrySelection(dataCache, selectedEntry);
        });
        this.myDiffSampleSelector.addActionListener(e -> {
            if (dataCache == null) {
                MemoryDetailView.$$$reportNull$$$0(15);
            }
            if (this.myDiffSampleSelector.getSelectedItem() == null) {
                return;
            }
            assert (this.myDiffSampleSelector.getSelectedItem() instanceof AbstractInfoEntryFormatter);
            AbstractInfoEntryFormatter selectedEntry = (AbstractInfoEntryFormatter)this.myDiffSampleSelector.getSelectedItem();
            this.updateOnDiffSelection(dataCache, selectedEntry);
        });
        dataCache.executeOnHeapDumpData((info, file) -> this.addHeapDumpInfo((MemoryProfiler.HeapDumpInfo)info));
        dataCache.executeOnAllocationTrackingSamples(this::addAllocationTrackingSample);
        this.myDataCache = dataCache;
    }

    private void updateOnMainEntrySelection(@NotNull MemoryDataCache dataCache, @NotNull AbstractInfoEntryFormatter selectedMainEntry) {
        if (dataCache == null) {
            MemoryDetailView.$$$reportNull$$$0(7);
        }
        if (selectedMainEntry == null) {
            MemoryDetailView.$$$reportNull$$$0(8);
        }
        if (this.myCurrentMainEntry == selectedMainEntry) {
            return;
        }
        this.myCurrentMainEntry = selectedMainEntry;
        if (this.myCurrentMainEntry != this.DEFAULT_MAIN_ENTRY) {
            this.myMainSampleSelector.removeItem((Object)this.DEFAULT_MAIN_ENTRY);
        }
        if (this.myClassHistogramView == null) {
            this.myClassHistogramView = new ClassHistogramView(this, this.myParent, this.myRange, this.myChoreographer, this.myProfilerEventDispatcher);
        }
        if (this.myCurrentMainEntry instanceof AllocationTrackingInfoEntryFormatter) {
            this.myDiffSampleSelector.removeAllItems();
            this.myDiffSampleSelector.addItem((Object)this.DEFAULT_DIFF_ENTRY);
            this.myDiffSampleSelector.setSelectedItem((Object)this.DEFAULT_DIFF_ENTRY);
            this.myCurrentDiffEntry = this.DEFAULT_DIFF_ENTRY;
            AllocationTrackingInfoEntryFormatter selectedSample = (AllocationTrackingInfoEntryFormatter)this.myCurrentMainEntry;
            if (!this.myClassHistogramView.generateClassHistogramFromAllocationTracking(selectedSample.getSample())) {
                this.myMainSampleSelector.removeItem((Object)this.myCurrentMainEntry);
                this.myMainSampleSelector.insertItemAt((Object)this.DEFAULT_MAIN_ENTRY, 0);
                this.myMainSampleSelector.setSelectedItem((Object)this.DEFAULT_MAIN_ENTRY);
                this.myCurrentMainEntry = this.DEFAULT_MAIN_ENTRY;
            }
        } else if (this.myCurrentMainEntry instanceof HeapDumpInfoEntryFormatter) {
            HeapDumpInfoEntryFormatter selectedHeapDumpEntry = (HeapDumpInfoEntryFormatter)this.myCurrentMainEntry;
            this.myDiffSampleSelector.removeAllItems();
            this.myDiffSampleSelector.addItem((Object)this.DEFAULT_DIFF_ENTRY);
            this.myHeapDumpEntries.forEach(entry -> {
                if (entry != selectedHeapDumpEntry) {
                    this.myDiffSampleSelector.addItem(entry);
                }
            });
            HeapDumpInfoEntryFormatter selectedDiffHeapDump = this.myCurrentDiffEntry instanceof HeapDumpInfoEntryFormatter && this.myCurrentDiffEntry != selectedHeapDumpEntry ? (HeapDumpInfoEntryFormatter)this.myCurrentDiffEntry : null;
            this.myCurrentDiffEntry = selectedDiffHeapDump == null ? this.DEFAULT_DIFF_ENTRY : selectedDiffHeapDump;
            this.myDiffSampleSelector.setSelectedItem((Object)this.myCurrentDiffEntry);
            this.myClassHistogramView.generateClassHistogramFromHeapDumpInfos(dataCache, selectedHeapDumpEntry.getInfo(), selectedDiffHeapDump == null ? null : selectedDiffHeapDump.getInfo());
        }
    }

    private void updateOnDiffSelection(@NotNull MemoryDataCache dataCache, @NotNull AbstractInfoEntryFormatter selectedDiffEntry) {
        if (dataCache == null) {
            MemoryDetailView.$$$reportNull$$$0(9);
        }
        if (selectedDiffEntry == null) {
            MemoryDetailView.$$$reportNull$$$0(10);
        }
        if (this.myCurrentDiffEntry == selectedDiffEntry) {
            return;
        }
        this.myCurrentDiffEntry = selectedDiffEntry;
        if (this.myClassHistogramView == null) {
            this.myClassHistogramView = new ClassHistogramView(this, this.myParent, this.myRange, this.myChoreographer, this.myProfilerEventDispatcher);
        }
        if (this.myCurrentDiffEntry == this.DEFAULT_DIFF_ENTRY) {
            if (this.myCurrentMainEntry instanceof HeapDumpInfoEntryFormatter) {
                this.myClassHistogramView.generateClassHistogramFromHeapDumpInfos(dataCache, ((HeapDumpInfoEntryFormatter)this.myCurrentMainEntry).getInfo(), null);
            }
        } else {
            assert (this.myCurrentMainEntry instanceof HeapDumpInfoEntryFormatter);
            assert (this.myCurrentDiffEntry instanceof HeapDumpInfoEntryFormatter);
            this.myClassHistogramView.generateClassHistogramFromHeapDumpInfos(dataCache, ((HeapDumpInfoEntryFormatter)this.myCurrentMainEntry).getInfo(), ((HeapDumpInfoEntryFormatter)this.myCurrentDiffEntry).getInfo());
        }
    }

    @NotNull
    private HeapDumpInfoEntryFormatter addHeapDumpInfo(@NotNull MemoryProfiler.HeapDumpInfo info) {
        if (info == null) {
            MemoryDetailView.$$$reportNull$$$0(11);
        }
        HeapDumpInfoEntryFormatter infoFormatter = new HeapDumpInfoEntryFormatter(info);
        this.myHeapDumpEntries.add(infoFormatter);
        this.myMainSampleSelector.addItem((Object)infoFormatter);
        if (this.myCurrentMainEntry instanceof HeapDumpInfoEntryFormatter) {
            this.myDiffSampleSelector.addItem((Object)infoFormatter);
            if (this.myCurrentDiffEntry == this.DEFAULT_DIFF_ENTRY) {
                this.myDiffSampleSelector.setSelectedItem((Object)infoFormatter);
            }
        }
        HeapDumpInfoEntryFormatter heapDumpInfoEntryFormatter = infoFormatter;
        if (heapDumpInfoEntryFormatter == null) {
            MemoryDetailView.$$$reportNull$$$0(12);
        }
        return heapDumpInfoEntryFormatter;
    }

    @NotNull
    private AllocationTrackingInfoEntryFormatter addAllocationTrackingSample(@NotNull AllocationTrackingSample sample) {
        if (sample == null) {
            MemoryDetailView.$$$reportNull$$$0(13);
        }
        AllocationTrackingInfoEntryFormatter formatter = new AllocationTrackingInfoEntryFormatter(sample);
        this.myMainSampleSelector.addItem((Object)formatter);
        AllocationTrackingInfoEntryFormatter allocationTrackingInfoEntryFormatter = formatter;
        if (allocationTrackingInfoEntryFormatter == null) {
            MemoryDetailView.$$$reportNull$$$0(14);
        }
        return allocationTrackingInfoEntryFormatter;
    }

    public void dispose() {
        this.myMainSampleSelector.removeAllItems();
        this.myDiffSampleSelector.removeAllItems();
        this.myClassHistogramView = null;
        this.myParent.removeAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStore";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choreographer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerEventDispatcher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memoryEventDispatcher";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataCache";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedMainEntry";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedDiffEntry";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailView";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailView";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addHeapDumpInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllocationTrackingSample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyDataIsReady";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateOnMainEntrySelection";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateOnDiffSelection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addHeapDumpInfo";
                break;
            }
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addAllocationTrackingSample";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notifyDataIsReady$1";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notifyDataIsReady$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AllocationTrackingInfoEntryFormatter
    extends AbstractInfoEntryFormatter {
        private final AllocationTrackingSample mySample;

        public AllocationTrackingInfoEntryFormatter(@NotNull AllocationTrackingSample sample) {
            if (sample == null) {
                AllocationTrackingInfoEntryFormatter.$$$reportNull$$$0(0);
            }
            this.mySample = sample;
        }

        @NotNull
        public AllocationTrackingSample getSample() {
            AllocationTrackingSample allocationTrackingSample = this.mySample;
            if (allocationTrackingSample == null) {
                AllocationTrackingInfoEntryFormatter.$$$reportNull$$$0(1);
            }
            return allocationTrackingSample;
        }

        @Override
        public String toString() {
            double startTimeUs = this.mySample.getStartTime();
            double endTimeUs = this.mySample.getEndTime();
            return "Allocations from " + TimeAxisFormatter.DEFAULT.getFormattedString(endTimeUs, startTimeUs, true) + " to " + TimeAxisFormatter.DEFAULT.getFormattedString(endTimeUs, endTimeUs, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sample";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailView$AllocationTrackingInfoEntryFormatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailView$AllocationTrackingInfoEntryFormatter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSample";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class HeapDumpInfoEntryFormatter
    extends AbstractInfoEntryFormatter {
        private final MemoryProfiler.HeapDumpInfo myInfo;

        public HeapDumpInfoEntryFormatter(MemoryProfiler.HeapDumpInfo info) {
            if (info == null) {
                HeapDumpInfoEntryFormatter.$$$reportNull$$$0(0);
            }
            this.myInfo = info;
        }

        @NotNull
        public MemoryProfiler.HeapDumpInfo getInfo() {
            MemoryProfiler.HeapDumpInfo heapDumpInfo = this.myInfo;
            if (heapDumpInfo == null) {
                HeapDumpInfoEntryFormatter.$$$reportNull$$$0(1);
            }
            return heapDumpInfo;
        }

        @Override
        public String toString() {
            long startTimeUs = TimeUnit.NANOSECONDS.toMicros(MemoryDetailView.this.myDataStore.mapAbsoluteDeviceToRelativeTime(this.myInfo.getStartTime()));
            return String.format("Heap at %s", TimeAxisFormatter.DEFAULT.getFormattedString((double)startTimeUs, (double)startTimeUs, true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailView$HeapDumpInfoEntryFormatter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/view/MemoryDetailView$HeapDumpInfoEntryFormatter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class AbstractInfoEntryFormatter {
        private AbstractInfoEntryFormatter() {
        }

        public String toString() {
            return null;
        }
    }
}

