/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.navigator.nodes.NativeAndroidLibraryNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkModuleNode
extends ProjectViewModuleNode {
    public NdkModuleNode(@NotNull Project project, @NotNull Module value, ViewSettings viewSettings) {
        if (project == null) {
            NdkModuleNode.$$$reportNull$$$0(0);
        }
        if (value == null) {
            NdkModuleNode.$$$reportNull$$$0(1);
        }
        super(project, value, viewSettings);
    }

    @NotNull
    public static Collection<AbstractTreeNode> getNativeSourceNodes(@NotNull Project project, @NotNull NdkModuleModel ndkModuleModel, @NotNull ViewSettings viewSettings) {
        if (project == null) {
            NdkModuleNode.$$$reportNull$$$0(2);
        }
        if (ndkModuleModel == null) {
            NdkModuleNode.$$$reportNull$$$0(3);
        }
        if (viewSettings == null) {
            NdkModuleNode.$$$reportNull$$$0(4);
        }
        NativeAndroidProject nativeAndroidProject = ndkModuleModel.getAndroidProject();
        Set<String> sourceFileExtensions = nativeAndroidProject.getFileExtensions().keySet();
        NdkModuleModel.NdkVariant variant = ndkModuleModel.getSelectedVariant();
        HashMultimap nativeLibraries = HashMultimap.create();
        for (NativeArtifact artifact : variant.getArtifacts()) {
            String artifactOutputFileName = artifact.getOutputFile().getName();
            nativeLibraries.put((Object)artifactOutputFileName, (Object)artifact);
        }
        if (nativeLibraries.keySet().size() == 1) {
            Collection<AbstractTreeNode> collection = NativeAndroidLibraryNode.getSourceDirectoryNodes(project, nativeLibraries.values(), viewSettings, sourceFileExtensions);
            if (collection == null) {
                NdkModuleNode.$$$reportNull$$$0(5);
            }
            return collection;
        }
        ArrayList children = Lists.newArrayList();
        for (String name : nativeLibraries.keySet()) {
            String nativeLibraryType = "";
            String nativeLibraryName = StringUtil.trimEnd((String)name, (String)".so");
            if (nativeLibraryName.length() < name.length()) {
                nativeLibraryType = "Shared Library";
            } else {
                nativeLibraryName = StringUtil.trimEnd((String)name, (String)".a");
                if (nativeLibraryName.length() < name.length()) {
                    nativeLibraryType = "Static Library";
                }
            }
            nativeLibraryName = StringUtil.trimStart((String)nativeLibraryName, (String)"lib");
            children.add(new NativeAndroidLibraryNode(project, nativeLibraryName, nativeLibraryType, nativeLibraries.get((Object)name), viewSettings, sourceFileExtensions));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            NdkModuleNode.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Module module = (Module)this.getValue();
        if (module == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                NdkModuleNode.$$$reportNull$$$0(7);
            }
            return immutableList;
        }
        NdkFacet facet = NdkFacet.getInstance(module);
        if (facet == null || facet.getNdkModuleModel() == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                NdkModuleNode.$$$reportNull$$$0(8);
            }
            return immutableList;
        }
        Collection<AbstractTreeNode> collection = NdkModuleNode.getNativeSourceNodes(this.myProject, facet.getNdkModuleModel(), this.getSettings());
        if (collection == null) {
            NdkModuleNode.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Nullable
    public Comparable getSortKey() {
        Module module = (Module)this.getValue();
        if (module == null) {
            return null;
        }
        return module.getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        Module module = (Module)this.getValue();
        if (module == null) {
            return null;
        }
        return String.format("%1$s (Native-Android-Gradle)", ((Module)this.getValue()).getName());
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/NdkModuleNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/NdkModuleNode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeSourceNodes";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNativeSourceNodes";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

