/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.CreateModuleTemplate;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.ModuleTemplate;
import com.android.tools.idea.npw.ModuleTemplateProvider;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class AndroidModuleTemplatesProvider
implements ModuleTemplateProvider {
    @NotNull
    private static Collection<ModuleTemplate> getModuleTemplates(@NotNull TemplateMetadata metadata, @NotNull FormFactor formFactor) {
        if (metadata == null) {
            AndroidModuleTemplatesProvider.$$$reportNull$$$0(0);
        }
        if (formFactor == null) {
            AndroidModuleTemplatesProvider.$$$reportNull$$$0(1);
        }
        if (formFactor.equals((Object)FormFactor.MOBILE)) {
            CreateModuleTemplate androidApplication = new CreateModuleTemplate(metadata, formFactor, "Phone & Tablet Module", AndroidIcons.ModuleTemplates.Mobile);
            androidApplication.setCustomValue(WizardConstants.IS_LIBRARY_KEY, false);
            CreateModuleTemplate androidLibrary = new CreateModuleTemplate(metadata, formFactor, "Android Library", AndroidIcons.ModuleTemplates.Android);
            androidLibrary.setCustomValue(WizardConstants.IS_LIBRARY_KEY, true);
            ImmutableSet immutableSet = ImmutableSet.of((Object)androidApplication, (Object)androidLibrary);
            if (immutableSet == null) {
                AndroidModuleTemplatesProvider.$$$reportNull$$$0(2);
            }
            return immutableSet;
        }
        ImmutableSet immutableSet = ImmutableSet.of((Object)new CreateModuleTemplate(metadata, formFactor, metadata.getTitle(), AndroidModuleTemplatesProvider.getModuleTypeIcon(formFactor)));
        if (immutableSet == null) {
            AndroidModuleTemplatesProvider.$$$reportNull$$$0(3);
        }
        return immutableSet;
    }

    private static Icon getModuleTypeIcon(@NotNull FormFactor enumValue) {
        if (enumValue == null) {
            AndroidModuleTemplatesProvider.$$$reportNull$$$0(4);
        }
        switch (enumValue) {
            case CAR: {
                return AndroidIcons.ModuleTemplates.Car;
            }
            case GLASS: {
                return AndroidIcons.ModuleTemplates.Glass;
            }
            case MOBILE: {
                return AndroidIcons.ModuleTemplates.Mobile;
            }
            case TV: {
                return AndroidIcons.ModuleTemplates.Tv;
            }
            case WEAR: {
                return AndroidIcons.ModuleTemplates.Wear;
            }
        }
        throw new IllegalArgumentException(enumValue.name());
    }

    @Override
    @NotNull
    public Iterable<ModuleTemplate> getModuleTemplates() {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        ArrayList moduleTemplates = Lists.newArrayList();
        for (File templateFile : applicationTemplates) {
            TemplateMetadata metadata = manager.getTemplateMetadata(templateFile);
            if (metadata == null || metadata.getFormFactor() == null) continue;
            moduleTemplates.addAll(AndroidModuleTemplatesProvider.getModuleTemplates(metadata, FormFactor.get(metadata.getFormFactor())));
        }
        Collections.sort(moduleTemplates, new Comparator<ModuleTemplate>(){

            @Override
            public int compare(ModuleTemplate t1, ModuleTemplate t2) {
                FormFactor f1 = t1.getFormFactor();
                FormFactor f2 = t2.getFormFactor();
                assert (f1 != null) : t1;
                assert (f2 != null) : t2;
                return f1.compareTo(f2);
            }
        });
        ArrayList arrayList = moduleTemplates;
        if (arrayList == null) {
            AndroidModuleTemplatesProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/AndroidModuleTemplatesProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/AndroidModuleTemplatesProvider";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleTemplates";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleTypeIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

