/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.deprecated.ConfigureAndroidProjectPath;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class FormFactorApiComboBox
extends JComboBox<AndroidTargetComboBoxItem> {
    private static final Set<AndroidVersion> ourInstalledVersions = Sets.newHashSet();
    private static final List<AndroidTargetComboBoxItem> ourTargets = Lists.newArrayList();
    private static IAndroidTarget ourHighestInstalledApiTarget;
    private FormFactor myFormFactor;
    private final List<String> myInstallRequests = Lists.newArrayList();
    private ScopedStateStore.Key<String> myBuildApiKey;
    private ScopedStateStore.Key<Integer> myBuildApiLevelKey;
    private ScopedStateStore.Key<Integer> myTargetApiLevelKey;
    private ScopedStateStore.Key<String> myTargetApiStringKey;
    private ScopedStateStore.Key<AndroidTargetComboBoxItem> myTargetComboBoxKey;
    private ScopedStateStore.Key<Boolean> myInclusionKey;
    private static final ProgressIndicator REPO_LOG;
    static final ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox> TARGET_COMBO_BINDING;

    public void init(@NotNull FormFactor formFactor, int minSdkLevel, @Nullable Runnable completedCallback, @Nullable Runnable foundItemsCallback, @Nullable Runnable noItemsCallback) {
        if (formFactor == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(0);
        }
        this.myFormFactor = formFactor;
        FormFactorApiComboBox.loadTargets();
        FormFactorApiComboBox.loadInstalledVersions();
        this.myBuildApiKey = FormFactorUtils.getBuildApiKey(formFactor);
        this.myBuildApiLevelKey = FormFactorUtils.getBuildApiLevelKey(formFactor);
        this.myTargetApiLevelKey = FormFactorUtils.getTargetApiLevelKey(formFactor);
        this.myTargetApiStringKey = FormFactorUtils.getTargetApiStringKey(formFactor);
        this.myTargetComboBoxKey = FormFactorUtils.getTargetComboBoxKey(formFactor);
        this.myInclusionKey = FormFactorUtils.getInclusionKey(formFactor);
        this.populateComboBox(formFactor, minSdkLevel);
        if (this.getItemCount() > 0 && foundItemsCallback != null) {
            foundItemsCallback.run();
        }
        this.loadSavedApi();
        this.loadRemoteTargets(minSdkLevel, completedCallback, foundItemsCallback, noItemsCallback);
    }

    public void registerWith(@NotNull ScopedDataBinder binder) {
        if (binder == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(1);
        }
        assert (this.myFormFactor != null) : "register() called on FormFactorApiComboBox before init()";
        binder.register(FormFactorUtils.getTargetComboBoxKey(this.myFormFactor), this, TARGET_COMBO_BINDING);
    }

    public void loadSavedApi() {
        String savedApiLevel = PropertiesComponent.getInstance().getValue(FormFactorApiComboBox.getPropertiesComponentMinSdkKey(this.myFormFactor), Integer.toString(this.myFormFactor.defaultApi));
        ScopedDataBinder.setSelectedItem(this, savedApiLevel);
        if (this.getSelectedIndex() < 0 && this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void deriveValues(@NotNull ScopedStateStore stateStore, @NotNull Set<ScopedStateStore.Key> modified) {
        if (stateStore == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(2);
        }
        if (modified == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(3);
        }
        if (modified.contains(this.myTargetComboBoxKey) || modified.contains(this.myInclusionKey)) {
            AndroidSdkData sdkData;
            BuildToolInfo buildTool;
            AndroidTargetComboBoxItem targetItem;
            if (!this.myInstallRequests.isEmpty()) {
                for (String request : this.myInstallRequests) {
                    stateStore.listRemove(WizardConstants.INSTALL_REQUESTS_KEY, request);
                }
                this.myInstallRequests.clear();
            }
            if ((targetItem = stateStore.get(this.myTargetComboBoxKey)) == null || !stateStore.getNotNull(this.myInclusionKey, false).booleanValue()) {
                return;
            }
            stateStore.put(FormFactorUtils.getMinApiKey(this.myFormFactor), targetItem.getData());
            stateStore.put(FormFactorUtils.getMinApiLevelKey(this.myFormFactor), targetItem.myApiLevel);
            IAndroidTarget target = targetItem.target;
            if (target != null && (target.getVersion().isPreview() || !target.isPlatform())) {
                this.populateApiLevels(targetItem.myApiLevel, target, stateStore);
            } else {
                int targetApiLevel = ourHighestInstalledApiTarget != null ? ourHighestInstalledApiTarget.getVersion().getFeatureLevel() : 0;
                this.populateApiLevels(targetApiLevel, ourHighestInstalledApiTarget, stateStore);
            }
            AndroidVersion androidVersion = targetItem.myAndroidVersion;
            String platformPath = DetailsTypes.getPlatformPath((AndroidVersion)androidVersion);
            BuildToolInfo buildToolInfo = buildTool = target == null ? null : target.getBuildToolInfo();
            if (buildTool == null) {
                AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                buildTool = sdkHandler.getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(ConfigureAndroidProjectPath.class), false);
            }
            if (buildTool != null) {
                stateStore.put(WizardConstants.BUILD_TOOLS_VERSION_KEY, buildTool.getRevision().toString());
            }
            if (targetItem.myAddon != null) {
                String packagePath = targetItem.myAddon.getPath();
                stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, packagePath);
                this.myInstallRequests.add(packagePath);
                AndroidTargetManager targetManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getAndroidTargetManager(REPO_LOG);
                if (targetManager.getTargetFromHashString(AndroidTargetHash.getPlatformHashString((AndroidVersion)androidVersion), REPO_LOG) == null) {
                    stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, platformPath);
                    this.myInstallRequests.add(platformPath);
                }
                this.populateApiLevels(targetItem.myApiLevel, null, stateStore);
            } else if (target == null && (ourHighestInstalledApiTarget == null || androidVersion.getApiLevel() > ourHighestInstalledApiTarget.getVersion().getApiLevel() && !ourInstalledVersions.contains(androidVersion))) {
                platformPath = DetailsTypes.getPlatformPath((AndroidVersion)new AndroidVersion(25, null));
                stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, platformPath);
                this.myInstallRequests.add(platformPath);
                this.populateApiLevels(25, null, stateStore);
            }
            PropertiesComponent.getInstance().setValue(FormFactorApiComboBox.getPropertiesComponentMinSdkKey(this.myFormFactor), (String)targetItem.getData());
            String javaVersion = null;
            if (ourHighestInstalledApiTarget != null && ourHighestInstalledApiTarget.getVersion().getFeatureLevel() >= 21 && (sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk()) != null) {
                JavaSdkVersion version;
                JavaSdk jdk = JavaSdk.getInstance();
                Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                if (sdk != null && (version = jdk.getVersion(sdk)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                    javaVersion = JavaSdkVersion.JDK_1_7.getDescription();
                }
            }
            stateStore.put(FormFactorUtils.getLanguageLevelKey(this.myFormFactor), javaVersion);
        }
    }

    private void populateComboBox(@NotNull FormFactor formFactor, int minSdk) {
        if (formFactor == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(4);
        }
        for (AndroidTargetComboBoxItem target : Iterables.filter(ourTargets, FormFactorUtils.getMinSdkComboBoxFilter(formFactor, minSdk))) {
            if (target.myApiLevel < minSdk && (target.target == null || !target.target.getVersion().isPreview())) continue;
            this.addItem(target);
        }
    }

    private static String getPropertiesComponentMinSdkKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(5);
        }
        return formFactor.id + "minApi";
    }

    private static void loadTargets() {
        ourTargets.clear();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i = 0; i < knownVersions.length; ++i) {
                ourTargets.add(new AndroidTargetComboBoxItem(knownVersions[i], i + 1));
            }
        }
        for (IAndroidTarget target : FormFactorApiComboBox.getCompilationTargets()) {
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            ourTargets.add(new AndroidTargetComboBoxItem(target));
        }
    }

    public static void loadInstalledVersions() {
        ourInstalledVersions.clear();
        IAndroidTarget highestInstalledTarget = null;
        for (IAndroidTarget target : FormFactorApiComboBox.getCompilationTargets()) {
            if (target.isPlatform() && target.getVersion().getFeatureLevel() >= 22 && (highestInstalledTarget == null || target.getVersion().getFeatureLevel() > highestInstalledTarget.getVersion().getFeatureLevel() && !target.getVersion().isPreview())) {
                highestInstalledTarget = target;
            }
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            ourInstalledVersions.add(target.getVersion());
        }
        ourHighestInstalledApiTarget = highestInstalledTarget;
    }

    @NotNull
    private static IAndroidTarget[] getCompilationTargets() {
        AndroidTargetManager targetManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getAndroidTargetManager(REPO_LOG);
        ArrayList result = Lists.newArrayList();
        for (IAndroidTarget target : targetManager.getTargets(REPO_LOG)) {
            if (!target.isPlatform()) continue;
            result.add(target);
        }
        IAndroidTarget[] iAndroidTargetArray = result.toArray(new IAndroidTarget[result.size()]);
        if (iAndroidTargetArray == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(6);
        }
        return iAndroidTargetArray;
    }

    private void populateApiLevels(int apiLevel, @Nullable IAndroidTarget apiTarget, @NotNull ScopedStateStore state) {
        if (state == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(7);
        }
        if (apiLevel >= 1) {
            if (apiTarget == null) {
                state.put(this.myBuildApiKey, Integer.toString(apiLevel));
            } else if (!apiTarget.isPlatform()) {
                state.put(this.myBuildApiKey, AndroidTargetHash.getTargetHashString((IAndroidTarget)apiTarget));
            } else {
                state.put(this.myBuildApiKey, TemplateMetadata.getBuildApiString(apiTarget.getVersion()));
            }
            state.put(this.myBuildApiLevelKey, apiLevel);
            if (apiLevel >= 25 || apiTarget != null && apiTarget.getVersion().isPreview()) {
                state.put(this.myTargetApiLevelKey, apiLevel);
                if (apiTarget != null) {
                    state.put(this.myTargetApiStringKey, apiTarget.getVersion().getApiString());
                } else {
                    state.put(this.myTargetApiStringKey, Integer.toString(apiLevel));
                }
            } else if (ourHighestInstalledApiTarget != null) {
                state.put(this.myTargetApiLevelKey, ourHighestInstalledApiTarget.getVersion().getApiLevel());
                state.put(this.myTargetApiStringKey, ourHighestInstalledApiTarget.getVersion().getApiString());
            }
        }
    }

    private void loadRemoteTargets(int minSdkLevel, Runnable completedCallback, Runnable foundItemsCallback, Runnable noItemsCallback) {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Runnable runCallbacks = () -> {
            if (completedCallback != null) {
                completedCallback.run();
            }
            if (this.getItemCount() > 0) {
                if (foundItemsCallback != null) {
                    foundItemsCallback.run();
                }
            } else if (noItemsCallback != null) {
                noItemsCallback.run();
            }
        };
        RepoManager.RepoLoadedCallback onComplete = packages -> {
            this.addPackages(packages.getNewPkgs(), minSdkLevel);
            this.addOfflineLevels();
            this.loadSavedApi();
            runCallbacks.run();
        };
        RepoManager.RepoLoadedCallback onLocalComplete = packages -> this.addPackages(packages.getLocalPackages().values(), minSdkLevel);
        Runnable onError = () -> ApplicationManager.getApplication().invokeLater(() -> {
            this.addOfflineLevels();
            runCallbacks.run();
        }, ModalityState.any());
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Refreshing Targets", true, null);
        sdkHandler.getSdkManager(REPO_LOG).load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)onLocalComplete), (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private void addPackages(@NotNull Collection<? extends RepoPackage> packages, int minSdkLevel) {
        if (packages == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(8);
        }
        Iterable filter = Iterables.filter(packages, FormFactorUtils.getMinSdkPackageFilter(this.myFormFactor, minSdkLevel));
        ArrayList sorted = Lists.newArrayList((Iterable)filter);
        Collections.sort(sorted, (repoPackage, other) -> FormFactorUtils.getAndroidVersion(repoPackage).compareTo(FormFactorUtils.getAndroidVersion(other)));
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (RepoPackage info : sorted) {
            int apiLevel = FormFactorUtils.getFeatureLevel(info);
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < this.getItemCount() ? ((AndroidTargetComboBoxItem)this.getItemAt(index)).myApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            this.insertItemAt(new AndroidTargetComboBoxItem(info), index++);
            prevInsertedApiLevel = apiLevel;
        }
    }

    private void addOfflineLevels() {
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (int apiLevel = this.myFormFactor.getMinOfflineApiLevel(); apiLevel <= this.myFormFactor.getMaxOfflineApiLevel(); ++apiLevel) {
            if (this.myFormFactor.isSupported(null, apiLevel) || apiLevel <= 0) continue;
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < this.getItemCount() ? ((AndroidTargetComboBoxItem)this.getItemAt(index)).myApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            this.insertItemAt(new AndroidTargetComboBoxItem(apiLevel), index++);
            prevInsertedApiLevel = apiLevel;
        }
    }

    static {
        REPO_LOG = new StudioLoggerProgressIndicator(FormFactorApiComboBox.class);
        TARGET_COMBO_BINDING = new ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox>(){

            @Override
            public void setValue(@Nullable AndroidTargetComboBoxItem newValue, @NotNull JComboBox component) {
                if (component == null) {
                    1.$$$reportNull$$$0(0);
                }
                component.setSelectedItem(newValue);
            }

            @Override
            @Nullable
            public AndroidTargetComboBoxItem getValue(@NotNull JComboBox component) {
                if (component == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (AndroidTargetComboBoxItem)component.getItemAt(component.getSelectedIndex());
            }

            @Override
            public void addActionListener(@NotNull ActionListener listener, @NotNull JComboBox component) {
                if (listener == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (component == null) {
                    1.$$$reportNull$$$0(3);
                }
                component.addActionListener(listener);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listener";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/npw/FormFactorApiComboBox$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getValue";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addActionListener";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateStore";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modified";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/FormFactorApiComboBox";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/FormFactorApiComboBox";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilationTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerWith";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deriveValues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "populateComboBox";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesComponentMinSdkKey";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "populateApiLevels";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AndroidTargetComboBoxItem
    extends ApiComboBoxItem<String> {
        private final int myApiLevel;
        private final AndroidVersion myAndroidVersion;
        public IAndroidTarget target;
        private RemotePackage myAddon;

        private AndroidTargetComboBoxItem(@NotNull AndroidVersion androidVersion, IdDisplay tag) {
            if (androidVersion == null) {
                AndroidTargetComboBoxItem.$$$reportNull$$$0(0);
            }
            super(androidVersion.getApiString(), AndroidTargetComboBoxItem.getLabel(androidVersion, tag), 1, 1);
            this.myAndroidVersion = androidVersion;
            this.myApiLevel = androidVersion.getFeatureLevel();
        }

        private AndroidTargetComboBoxItem(String label, int apiLevel) {
            super(Integer.toString(apiLevel), label, 1, 1);
            this.myAndroidVersion = new AndroidVersion(apiLevel, null);
            this.myApiLevel = apiLevel;
        }

        private AndroidTargetComboBoxItem(int apiLevel) {
            this(new AndroidVersion(apiLevel, null), SystemImage.DEFAULT_TAG);
        }

        private AndroidTargetComboBoxItem(@NotNull IAndroidTarget target) {
            if (target == null) {
                AndroidTargetComboBoxItem.$$$reportNull$$$0(1);
            }
            this(target.getVersion(), SystemImage.DEFAULT_TAG);
            this.target = target;
        }

        private AndroidTargetComboBoxItem(@NotNull RepoPackage info) {
            if (info == null) {
                AndroidTargetComboBoxItem.$$$reportNull$$$0(2);
            }
            this(FormFactorUtils.getAndroidVersion(info), FormFactorUtils.getTag(info));
            if (info instanceof RemotePackage && SystemImage.GLASS_TAG.equals((Object)FormFactorUtils.getTag(info))) {
                this.myAddon = (RemotePackage)info;
            }
        }

        public int getApiLevel() {
            return this.myApiLevel;
        }

        private static String getLabel(@NotNull AndroidVersion version, @Nullable IdDisplay tag) {
            if (version == null) {
                AndroidTargetComboBoxItem.$$$reportNull$$$0(3);
            }
            int featureLevel = version.getFeatureLevel();
            if (SystemImage.GLASS_TAG.equals((Object)tag)) {
                return String.format("Glass Development Kit Preview (API %1$d)", featureLevel);
            }
            if (featureLevel <= 25) {
                if (version.isPreview()) {
                    return String.format("API %1$s: Android %2$s (%3$s preview)", SdkVersionInfo.getCodeName((int)featureLevel), SdkVersionInfo.getVersionString((int)featureLevel), SdkVersionInfo.getCodeName((int)featureLevel));
                }
                return SdkVersionInfo.getAndroidName((int)featureLevel);
            }
            if (version.isPreview()) {
                return String.format("API %1$d: Android (%2$s)", featureLevel, version.getCodename());
            }
            return String.format("API %1$d: Android", featureLevel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLabel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

