/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.assetstudiolib.GraphicGenerator;
import com.android.assetstudiolib.MaterialDesignIcons;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewEditorImpl
extends ViewEditor {
    private final ScreenView myScreen;

    public ViewEditorImpl(@NotNull ScreenView screen) {
        if (screen == null) {
            ViewEditorImpl.$$$reportNull$$$0(0);
        }
        this.myScreen = screen;
    }

    @Override
    public int getDpi() {
        return this.myScreen.getConfiguration().getDensity().getDpiValue();
    }

    @Override
    @Nullable
    public AndroidVersion getCompileSdkVersion() {
        return AndroidModuleInfo.get(this.myScreen.getModel().getFacet()).getBuildSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion androidVersion = AndroidModuleInfo.get(this.myScreen.getModel().getFacet()).getMinSdkVersion();
        if (androidVersion == null) {
            ViewEditorImpl.$$$reportNull$$$0(1);
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion androidVersion = AndroidModuleInfo.get(this.myScreen.getModel().getFacet()).getTargetSdkVersion();
        if (androidVersion == null) {
            ViewEditorImpl.$$$reportNull$$$0(2);
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myScreen.getConfiguration();
        if (configuration == null) {
            ViewEditorImpl.$$$reportNull$$$0(3);
        }
        return configuration;
    }

    @Override
    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myScreen.getModel();
        if (nlModel == null) {
            ViewEditorImpl.$$$reportNull$$$0(4);
        }
        return nlModel;
    }

    @Override
    @NotNull
    public Collection<ViewInfo> getRootViews() {
        RenderResult result = this.myScreen.getModel().getRenderResult();
        if (result == null) {
            List<ViewInfo> list = Collections.emptyList();
            if (list == null) {
                ViewEditorImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<ViewInfo> list = result.getRootViews();
        if (list == null) {
            ViewEditorImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public boolean moduleContainsResource(@NotNull ResourceType type, @NotNull String name) {
        if (type == null) {
            ViewEditorImpl.$$$reportNull$$$0(7);
        }
        if (name == null) {
            ViewEditorImpl.$$$reportNull$$$0(8);
        }
        return this.myScreen.getModel().getFacet().getModuleResources(true).hasResourceItem(type, name);
    }

    @Override
    public void copyVectorAssetToMainModuleSourceSet(@NotNull String asset) {
        String message;
        Project project;
        if (asset == null) {
            ViewEditorImpl.$$$reportNull$$$0(9);
        }
        if (Messages.showYesNoDialog((Project)(project = this.myScreen.getModel().getProject()), (String)(message = "Do you want to copy vector asset " + asset + " to your main module source set?"), (String)"Copy Vector Asset", (Icon)Messages.getQuestionIcon()) == 1) {
            return;
        }
        try (InputStream in = GraphicGenerator.class.getClassLoader().getResourceAsStream(MaterialDesignIcons.getPathForBasename((String)asset));){
            this.createResourceFile("drawable", asset + ".xml", ByteStreams.toByteArray((InputStream)in));
        }
        catch (IOException exception) {
            Logger.getInstance(ViewEditorImpl.class).warn((Throwable)exception);
        }
    }

    @Override
    public void copyLayoutToMainModuleSourceSet(@NotNull String layout, @Language(value="XML") @NotNull String xml) {
        if (layout == null) {
            ViewEditorImpl.$$$reportNull$$$0(10);
        }
        if (xml == null) {
            ViewEditorImpl.$$$reportNull$$$0(11);
        }
        String message = "Do you want to copy layout " + layout + " to your main module source set?";
        if (Messages.showYesNoDialog((Project)this.myScreen.getModel().getProject(), (String)message, (String)"Copy Layout", (Icon)Messages.getQuestionIcon()) == 1) {
            return;
        }
        this.createResourceFile("layout", layout + ".xml", xml.getBytes(StandardCharsets.UTF_8));
    }

    private void createResourceFile(@NotNull String resourceDirectory, @NotNull String resourceFile, @NotNull byte[] resourceFileContent) {
        if (resourceDirectory == null) {
            ViewEditorImpl.$$$reportNull$$$0(12);
        }
        if (resourceFile == null) {
            ViewEditorImpl.$$$reportNull$$$0(13);
        }
        if (resourceFileContent == null) {
            ViewEditorImpl.$$$reportNull$$$0(14);
        }
        try {
            VirtualFile directory = this.getResourceDirectoryChild(resourceDirectory);
            if (directory == null) {
                return;
            }
            directory.createChildData((Object)this, resourceFile).setBinaryContent(resourceFileContent);
        }
        catch (IOException exception) {
            Logger.getInstance(ViewEditorImpl.class).warn((Throwable)exception);
        }
    }

    @Nullable
    private VirtualFile getResourceDirectoryChild(@NotNull String child) throws IOException {
        VirtualFile resourceDirectory;
        if (child == null) {
            ViewEditorImpl.$$$reportNull$$$0(15);
        }
        if ((resourceDirectory = this.myScreen.getModel().getFacet().getPrimaryResourceDir()) == null) {
            Logger.getInstance(ViewEditorImpl.class).warn("resourceDirectory is null");
            return null;
        }
        VirtualFile resourceDirectoryChild = resourceDirectory.findChild(child);
        if (resourceDirectoryChild == null) {
            return resourceDirectory.createChildDirectory((Object)this, child);
        }
        return resourceDirectoryChild;
    }

    @Override
    @Nullable
    public Map<NlComponent, Dimension> measureChildren(@NotNull NlComponent parent, @Nullable RenderTask.AttributeFilter filter) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(16);
        }
        HashMap unweightedSizes = Maps.newHashMap();
        XmlTag parentTag = parent.getTag();
        if (parentTag.isValid()) {
            if (parent.getChildCount() == 0) {
                return Collections.emptyMap();
            }
            HashMap tagToComponent = Maps.newHashMapWithExpectedSize((int)parent.getChildCount());
            for (NlComponent child : parent.getChildren()) {
                tagToComponent.put(child.getTag(), child);
            }
            NlModel model = this.myScreen.getModel();
            XmlFile xmlFile = model.getFile();
            AndroidFacet facet = model.getFacet();
            RenderService renderService = RenderService.get(facet);
            RenderLogger logger = renderService.createLogger();
            RenderTask task = renderService.createTask((PsiFile)xmlFile, this.getConfiguration(), logger, null);
            if (task == null) {
                return null;
            }
            Map<XmlTag, ViewInfo> map = task.measureChildren(parentTag, filter);
            task.dispose();
            if (map != null) {
                for (Map.Entry<XmlTag, ViewInfo> entry : map.entrySet()) {
                    ViewInfo viewInfo = entry.getValue();
                    viewInfo = RenderService.getSafeBounds(viewInfo);
                    Dimension size = new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
                    NlComponent child = (NlComponent)tagToComponent.get(entry.getKey());
                    if (child == null) continue;
                    unweightedSizes.put(child, size);
                }
            }
        }
        return unweightedSizes;
    }

    @Override
    @Nullable
    public String displayResourceInput(@NotNull String title, @NotNull EnumSet<ResourceType> types) {
        String resource;
        if (title == null) {
            ViewEditorImpl.$$$reportNull$$$0(17);
        }
        if (types == null) {
            ViewEditorImpl.$$$reportNull$$$0(18);
        }
        NlModel model = this.myScreen.getModel();
        ChooseResourceDialog dialog = ChooseResourceDialog.builder().setModule(model.getModule()).setTypes(types).setConfiguration(model.getConfiguration()).build();
        if (!title.isEmpty()) {
            dialog.setTitle(title);
        }
        dialog.show();
        if (dialog.isOK() && (resource = dialog.getResourceName()) != null && !resource.isEmpty()) {
            return resource;
        }
        return null;
    }

    @Override
    @Nullable
    public String displayClassInput(@NotNull Set<String> superTypes, @Nullable Predicate<String> filter, @Nullable String currentValue) {
        if (superTypes == null) {
            ViewEditorImpl.$$$reportNull$$$0(19);
        }
        Module module = this.myScreen.getModel().getModule();
        String[] superTypesArray = ArrayUtil.toStringArray(superTypes);
        Condition psiFilter = null;
        if (filter != null) {
            psiFilter = psiClass -> {
                String qualifiedName = psiClass.getQualifiedName();
                if (qualifiedName == null) {
                    return false;
                }
                return filter.test(qualifiedName);
            };
        }
        return ChooseClassDialog.openDialog(module, "Classes", true, (Condition<PsiClass>)psiFilter, superTypesArray);
    }

    @NotNull
    public ScreenView getScreenView() {
        ScreenView screenView = this.myScreen;
        if (screenView == null) {
            ViewEditorImpl.$$$reportNull$$$0(20);
        }
        return screenView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screen";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asset";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xml";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFileContent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinSdkVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSdkVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 20: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moduleContainsResource";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyVectorAssetToMainModuleSourceSet";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyLayoutToMainModuleSourceSet";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createResourceFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getResourceDirectoryChild";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "measureChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "displayResourceInput";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "displayClassInput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

