/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class DrawComponentFrame
extends DrawRegion {
    public static final int SUBDUED = 0;
    public static final int NORMAL = 1;
    public static final int OVER = 2;
    public static final int SELECTED = 3;
    static Stroke myNormalStroke = new BasicStroke(1.0f);
    static Stroke myProblemStroke = new BasicStroke(2.0f);
    int myMode;
    boolean myHasHorizontalConstraints;
    boolean myHasVerticalConstraints;

    public DrawComponentFrame(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c++]);
    }

    @Override
    public int getLevel() {
        return 20;
    }

    public DrawComponentFrame(int x, int y, int width, int height, int mode, boolean hasHorizontalConstraints, boolean hasVerticalConstraints) {
        super(x, y, width, height);
        this.myMode = mode;
        this.myHasHorizontalConstraints = hasHorizontalConstraints;
        this.myHasVerticalConstraints = hasVerticalConstraints;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color[] colorFrame = new Color[]{colorSet.getSubduedFrames(), colorSet.getFrames(), colorSet.getHighlightedFrames(), colorSet.getSelectedFrames()};
        Stroke previousStroke = g.getStroke();
        g.setStroke(myNormalStroke);
        g.setColor(colorFrame[this.myMode]);
        if (this.myHasHorizontalConstraints && this.myHasVerticalConstraints) {
            g.drawRect(this.x, this.y, this.width, this.height);
        } else {
            if (!this.myHasHorizontalConstraints) {
                g.setStroke(myProblemStroke);
                g.setColor(colorSet.getUnconstrainedColor());
            } else {
                g.setStroke(myNormalStroke);
                g.setColor(colorFrame[this.myMode]);
            }
            g.drawLine(this.x, this.y, this.x, this.y + this.height);
            g.drawLine(this.x + this.width, this.y, this.x + this.width, this.y + this.height);
            if (!this.myHasVerticalConstraints) {
                g.setStroke(myProblemStroke);
                g.setColor(colorSet.getUnconstrainedColor());
            } else {
                g.setStroke(myNormalStroke);
                g.setColor(colorFrame[this.myMode]);
            }
            g.drawLine(this.x, this.y, this.x + this.width, this.y);
            g.drawLine(this.x, this.y + this.height, this.x + this.width, this.y + this.height);
        }
        g.setStroke(previousStroke);
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode;
    }

    public static void add(DisplayList list, SceneContext sceneContext, Rectangle rect, int mode, boolean hasHorizontalConstraints, boolean hasVerticalConstraints) {
        int l = sceneContext.getSwingX(rect.x);
        int t = sceneContext.getSwingY(rect.y);
        int w = sceneContext.getSwingDimension(rect.width);
        int h = sceneContext.getSwingDimension(rect.height);
        list.add(new DrawComponentFrame(l, t, w, h, mode, hasHorizontalConstraints, hasVerticalConstraints));
    }
}

