/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.scene.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawGuidelineCycle;
import com.android.tools.idea.uibuilder.scene.target.ConstraintTarget;
import com.android.tools.idea.uibuilder.scene.target.Target;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuidelineCycleTarget
extends ConstraintTarget {
    private final boolean myIsHorizontal;
    private int mySize = 16;

    public GuidelineCycleTarget(boolean isHorizontal) {
        this.myIsHorizontal = isHorizontal;
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    @Override
    public int getPreferenceLevel() {
        return 40;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            GuidelineCycleTarget.$$$reportNull$$$0(0);
        }
        if (this.myIsHorizontal) {
            this.myLeft = l - this.mySize;
            this.myTop = t - this.mySize / 2;
            this.myRight = l;
            this.myBottom = t + this.mySize / 2;
        } else {
            this.myLeft = l - this.mySize / 2;
            this.myTop = t - this.mySize;
            this.myRight = l + this.mySize / 2;
            this.myBottom = t;
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneTransform) {
        if (list == null) {
            GuidelineCycleTarget.$$$reportNull$$$0(1);
        }
        if (sceneTransform == null) {
            GuidelineCycleTarget.$$$reportNull$$$0(2);
        }
        int mode = ConstraintComponentUtilities.getGuidelineMode(this.myComponent);
        DrawGuidelineCycle.add(list, sceneTransform, this.myIsHorizontal, this.myLeft, this.myTop, this.myRight, this.myBottom, mode, this.myComponent.isSelected());
    }

    @Override
    public void mouseDown(int x, int y) {
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable Target closestTarget) {
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable Target closestTarget) {
        final AttributesTransaction attributes = this.myComponent.getNlComponent().startAttributeTransaction();
        String begin = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        String percent = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
        SceneComponent parent = this.myComponent.getParent();
        int value = this.myComponent.getDrawY() - parent.getDrawY();
        int dimension = parent.getDrawHeight();
        if (!this.myIsHorizontal) {
            value = this.myComponent.getDrawX() - parent.getDrawX();
            dimension = parent.getDrawWidth();
        }
        if (begin != null) {
            this.setEnd(attributes, dimension - value);
        } else if (end != null) {
            this.setPercent(attributes, (float)value / (float)dimension);
        } else if (percent != null) {
            this.setBegin(attributes, value);
        }
        attributes.apply();
        NlModel nlModel = this.myComponent.getNlComponent().getModel();
        Project project = nlModel.getProject();
        XmlFile file = nlModel.getFile();
        String label = "Cycle Guideline";
        WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                attributes.commit();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/scene/target/GuidelineCycleTarget$1", "run"));
            }
        };
        action.execute();
    }

    private void setBegin(AttributesTransaction transaction, int value) {
        String position = String.format("%ddp", value);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", position);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", null);
    }

    private void setEnd(AttributesTransaction transaction, int value) {
        String position = String.format("%ddp", value);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", position);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", null);
    }

    private void setPercent(AttributesTransaction transaction, float value) {
        String position = String.valueOf(value);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", null);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", position);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/scene/target/GuidelineCycleTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

