/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.resources.ScreenRound;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionListener;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenView {
    private final DesignSurface mySurface;
    private ScreenViewType myType;
    private final NlModel myModel;
    private Scene myScene;
    private int x;
    private int y;

    public ScreenView(DesignSurface surface, @NotNull ScreenViewType type, @NotNull NlModel model) {
        if (type == null) {
            ScreenView.$$$reportNull$$$0(0);
        }
        if (model == null) {
            ScreenView.$$$reportNull$$$0(1);
        }
        this.myScene = null;
        this.mySurface = surface;
        this.myType = type;
        this.myModel = model;
        this.myScene = Scene.createScene(this.myModel, this);
        this.myModel.getSelectionModel().addListener(new SelectionListener(){

            @Override
            public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
                if (model == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (selection == null) {
                    1.$$$reportNull$$$0(1);
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ScreenView.this.mySurface != null) {
                            ScreenView.this.mySurface.repaint();
                        }
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "model";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "selection";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/uibuilder/surface/ScreenView$1";
                objectArray[2] = "selectionChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public Scene getScene() {
        return this.myScene;
    }

    @Nullable
    public RenderResult getResult() {
        return this.myModel.getRenderResult();
    }

    @NotNull
    public ScreenViewType getScreenViewType() {
        ScreenViewType screenViewType = this.myType;
        if (screenViewType == null) {
            ScreenView.$$$reportNull$$$0(2);
        }
        return screenViewType;
    }

    public void setType(ScreenViewType type) {
        this.myType = type;
    }

    @NotNull
    public Dimension getSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        Dimension preferred = this.getPreferredSize(dimension);
        double scale = this.mySurface.getScale();
        dimension.setSize((int)(scale * (double)preferred.width), (int)(scale * (double)preferred.height));
        Dimension dimension2 = dimension;
        if (dimension2 == null) {
            ScreenView.$$$reportNull$$$0(3);
        }
        return dimension2;
    }

    @NotNull
    public Dimension getSize() {
        Dimension dimension = this.getSize(null);
        if (dimension == null) {
            ScreenView.$$$reportNull$$$0(4);
        }
        return dimension;
    }

    @NotNull
    public Dimension getPreferredSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        Configuration configuration = this.getConfiguration();
        Device device = configuration.getDevice();
        State state = configuration.getDeviceState();
        if (device != null && state != null) {
            HardwareConfig config = new HardwareConfigHelper(device).setOrientation(state.getOrientation()).getConfig();
            dimension.setSize(config.getScreenWidth(), config.getScreenHeight());
        }
        Dimension dimension2 = dimension;
        if (dimension2 == null) {
            ScreenView.$$$reportNull$$$0(5);
        }
        return dimension2;
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension = this.getPreferredSize(null);
        if (dimension == null) {
            ScreenView.$$$reportNull$$$0(6);
        }
        return dimension;
    }

    public void switchDevice() {
        List<Device> devices = this.myModel.getFacet().getConfigurationManager().getDevices();
        ArrayList applicable = Lists.newArrayList();
        for (Device device : devices) {
            if (!HardwareConfigHelper.isNexus((Device)device)) continue;
            applicable.add(device);
        }
        Configuration configuration = this.getConfiguration();
        Device currentDevice = configuration.getDevice();
        int n = applicable.size();
        for (int i = 0; i < n; ++i) {
            if (applicable.get(i) != currentDevice) continue;
            Device newDevice = (Device)applicable.get((i + 1) % applicable.size());
            configuration.setDevice(newDevice, true);
            break;
        }
    }

    public void toggleOrientation() {
        Configuration configuration = this.getConfiguration();
        configuration.getDeviceState();
        State current = configuration.getDeviceState();
        State flip = configuration.getNextDeviceState(current);
        if (flip != null) {
            configuration.setDeviceState(flip);
        }
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myModel.getConfiguration();
        if (configuration == null) {
            ScreenView.$$$reportNull$$$0(7);
        }
        return configuration;
    }

    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            ScreenView.$$$reportNull$$$0(8);
        }
        return nlModel;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.myModel.getSelectionModel();
        if (selectionModel == null) {
            ScreenView.$$$reportNull$$$0(9);
        }
        return selectionModel;
    }

    @Nullable
    public Shape getScreenShape() {
        Device device = this.getConfiguration().getDevice();
        if (device == null) {
            return null;
        }
        Screen screen = device.getDefaultHardware().getScreen();
        if (screen.getScreenRound() != ScreenRound.ROUND) {
            return null;
        }
        Dimension size = this.getSize();
        int chin = screen.getChin();
        if (chin == 0) {
            return new Ellipse2D.Double(this.x, this.y, size.width, size.height);
        }
        int height = size.height * chin / screen.getYDimension();
        Area a1 = new Area(new Ellipse2D.Double(this.x, this.y, size.width, size.height + height));
        Area a2 = new Area(new Rectangle2D.Double(this.x, this.y + 2 * (size.height + height) - height, size.width, height));
        a1.subtract(a2);
        return a1;
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            ScreenView.$$$reportNull$$$0(10);
        }
        return designSurface;
    }

    public double getScale() {
        return this.mySurface.getScale();
    }

    public void setLocation(int screenX, int screenY) {
        this.x = screenX;
        this.y = screenY;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/ScreenView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/ScreenView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScreenViewType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredSize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ScreenViewType {
        NORMAL,
        BLUEPRINT;

    }
}

