/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;

class SummaryTreeNode
extends UpdaterTreeNode {
    private AndroidVersion myVersion;
    private Set<UpdaterTreeNode> myAllChildren;
    private Set<UpdaterTreeNode> myIncludedChildren = Sets.newHashSet();
    private UpdaterTreeNode myPrimaryChild;

    public static SummaryTreeNode createNode(AndroidVersion version, Set<UpdaterTreeNode> children) {
        HashSet includedChildren = Sets.newHashSet();
        UpdaterTreeNode primaryChild = null;
        for (UpdaterTreeNode child : children) {
            if (child.includeInSummary()) {
                includedChildren.add(child);
            }
            if (!child.isPrimary()) continue;
            primaryChild = child;
        }
        if (!includedChildren.isEmpty()) {
            return new SummaryTreeNode(version, children, includedChildren, primaryChild);
        }
        return null;
    }

    protected SummaryTreeNode(AndroidVersion version, Set<UpdaterTreeNode> children, Set<UpdaterTreeNode> includedChildren, UpdaterTreeNode primaryChild) {
        this.myVersion = version;
        this.myAllChildren = children;
        this.myIncludedChildren = includedChildren;
        this.myPrimaryChild = primaryChild;
    }

    @Override
    public PackageNodeModel.SelectedState getInitialState() {
        boolean hasNeedsUpdate = false;
        for (UpdaterTreeNode summaryNode : this.myIncludedChildren) {
            if (summaryNode.getInitialState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
                return PackageNodeModel.SelectedState.NOT_INSTALLED;
            }
            if (summaryNode.getInitialState() != PackageNodeModel.SelectedState.MIXED) continue;
            hasNeedsUpdate = true;
        }
        return hasNeedsUpdate ? PackageNodeModel.SelectedState.MIXED : PackageNodeModel.SelectedState.INSTALLED;
    }

    @Override
    public PackageNodeModel.SelectedState getCurrentState() {
        boolean hasNeedsUpdate = false;
        for (UpdaterTreeNode summaryNode : this.myIncludedChildren) {
            if (summaryNode.getCurrentState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
                return PackageNodeModel.SelectedState.NOT_INSTALLED;
            }
            if (summaryNode.getCurrentState() != PackageNodeModel.SelectedState.MIXED) continue;
            hasNeedsUpdate = true;
        }
        return hasNeedsUpdate ? PackageNodeModel.SelectedState.MIXED : PackageNodeModel.SelectedState.INSTALLED;
    }

    @Override
    public int compareTo(UpdaterTreeNode o) {
        if (!(o instanceof SummaryTreeNode)) {
            return super.compareTo(o);
        }
        return this.myVersion.compareTo(((SummaryTreeNode)o).myVersion);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SummaryTreeNode)) {
            return false;
        }
        return this.myVersion.equals((Object)((SummaryTreeNode)obj).myVersion);
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.getTextRenderer().append(SdkVersionInfo.getVersionWithCodename((AndroidVersion)this.myVersion));
    }

    public AndroidVersion getVersion() {
        return this.myVersion;
    }

    @Override
    protected void setState(PackageNodeModel.SelectedState state) {
        boolean hasOrigNotInstalled = false;
        for (UpdaterTreeNode summaryTreeNode : this.myIncludedChildren) {
            if (summaryTreeNode.getInitialState() != PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            hasOrigNotInstalled = true;
        }
        for (UpdaterTreeNode child : this.myAllChildren) {
            child.resetState();
        }
        if (state == PackageNodeModel.SelectedState.NOT_INSTALLED && !hasOrigNotInstalled) {
            for (UpdaterTreeNode child : this.myAllChildren) {
                child.setState(PackageNodeModel.SelectedState.NOT_INSTALLED);
            }
        }
        if (state == PackageNodeModel.SelectedState.INSTALLED) {
            for (UpdaterTreeNode child : this.myIncludedChildren) {
                child.setState(PackageNodeModel.SelectedState.INSTALLED);
            }
        }
    }

    @Override
    protected boolean canHaveMixedState() {
        for (UpdaterTreeNode child : this.myIncludedChildren) {
            if (!child.canHaveMixedState()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getStatusString() {
        boolean foundSources = false;
        boolean foundPlatform = false;
        boolean foundUpdate = false;
        for (UpdaterTreeNode child : this.myAllChildren) {
            if (child.getInitialState() == PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            TypeDetails details = ((DetailsTreeNode)child).getPackage().getTypeDetails();
            if (details instanceof DetailsTypes.SourceDetailsType) {
                foundSources = true;
            } else if (details instanceof DetailsTypes.PlatformDetailsType) {
                foundPlatform = true;
            }
            if (child.getInitialState() != PackageNodeModel.SelectedState.MIXED) continue;
            foundUpdate = true;
        }
        if (foundUpdate) {
            return "Update available";
        }
        if (foundPlatform && (foundSources || this.myVersion.getApiLevel() < 14)) {
            return "Installed";
        }
        if (foundPlatform || foundSources) {
            return "Partially installed";
        }
        return "Not installed";
    }

    public UpdaterTreeNode getPrimaryChild() {
        return this.myPrimaryChild;
    }
}

