/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AndroidSourceType {
    MANIFEST("manifest", IdeaSourceProvider.MANIFEST_PROVIDER, AllIcons.Modules.SourceRoot),
    JAVA("java", IdeaSourceProvider.JAVA_PROVIDER, AllIcons.Modules.SourceRoot),
    CPP("cpp", IdeaSourceProvider.JNI_PROVIDER, AllIcons.Modules.SourceRoot),
    AIDL("aidl", IdeaSourceProvider.AIDL_PROVIDER, AllIcons.Modules.SourceRoot),
    RENDERSCRIPT("renderscript", IdeaSourceProvider.RENDERSCRIPT_PROVIDER, AllIcons.Modules.SourceRoot),
    SHADERS("shaders", IdeaSourceProvider.SHADERS_PROVIDER, AllIcons.Modules.SourceRoot),
    ASSETS("assets", IdeaSourceProvider.ASSETS_PROVIDER, AllIcons.Modules.ResourcesRoot),
    JNILIBS("jniLibs", IdeaSourceProvider.JNI_LIBS_PROVIDER, AllIcons.Modules.ResourcesRoot),
    RES("res", IdeaSourceProvider.RES_PROVIDER, AllIcons.Modules.ResourcesRoot),
    RESOURCES("resources", IdeaSourceProvider.RESOURCES_PROVIDER, AllIcons.Modules.ResourcesRoot);

    private final String myName;
    private final Function<IdeaSourceProvider, List<VirtualFile>> mySourceExtractor;
    private final Icon myIcon;

    private AndroidSourceType(String name, Function<IdeaSourceProvider, List<VirtualFile>> sourceExtractor, Icon icon) {
        this.myName = name;
        this.mySourceExtractor = sourceExtractor;
        this.myIcon = icon;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<VirtualFile> getSources(IdeaSourceProvider provider) {
        List<VirtualFile> files = this.mySourceExtractor.apply(provider);
        List<Object> list = files == null ? Collections.emptyList() : files;
        if (list == null) {
            AndroidSourceType.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/facet/AndroidSourceType", "getSources"));
    }
}

