/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.initialization.FlowJSVariablePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSTypeExplicitlyIntention
extends JSIntention {
    private static final JSElementPredicate PREDICATE = new FlowJSVariablePredicate();

    @Override
    @Nullable
    protected PsiElement findMatchingElement(@Nullable PsiElement element) {
        if (element != null && element.getParent() instanceof JSParameterList && element.getPrevSibling() instanceof JSParameter) {
            return element.getPrevSibling();
        }
        return super.findMatchingElement(element);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(1);
        }
        if (FlowJSAnnotation.isFlowAnnotation((PsiFile)element.getContainingFile()) && (element.getLanguage() == JavaScriptSupportLoader.FLOW_JS || element.getParent().getLanguage() == JavaScriptSupportLoader.FLOW_JS)) {
            return PREDICATE.satisfiedBy(element);
        }
        return false;
    }

    private static ASTNode getStatementWithType(@NotNull Project project, @NotNull String newTypeDeclaration) {
        if (project == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(2);
        }
        if (newTypeDeclaration == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(3);
        }
        return JSChangeUtil.createStatementFromText((Project)project, (String)("var a: " + newTypeDeclaration), (JSLanguageDialect)JavaScriptSupportLoader.FLOW_JS);
    }

    @NotNull
    private static PsiElement getColonPsiElement(@NotNull Project project, @NotNull String newTypeDeclaration) {
        if (project == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(4);
        }
        if (newTypeDeclaration == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = FlowJSTypeExplicitlyIntention.getStatementWithType(project, newTypeDeclaration).getLastChildNode().findChildByType(JSTokenTypes.COLON).getPsi();
        if (psiElement == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement getParameterTypePsiElement(@NotNull Project project, @NotNull String newTypeDeclaration) {
        if (project == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(7);
        }
        if (newTypeDeclaration == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(8);
        }
        PsiElement psiElement = FlowJSTypeExplicitlyIntention.getStatementWithType(project, newTypeDeclaration).getLastChildNode().getLastChildNode().getPsi();
        if (psiElement == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(10);
        }
        if (element instanceof JSParameter) {
            PsiFile containingFile = element.getContainingFile();
            if (element.getParent() instanceof JSParameterList) {
                String newTypeDeclaration = FlowJSTypeExplicitlyIntention.getTypeOfFunctions(element);
                if (!FlowJSTypeExplicitlyIntention.checkType(newTypeDeclaration)) {
                    return;
                }
                element.addAfter(FlowJSTypeExplicitlyIntention.getParameterTypePsiElement(containingFile.getProject(), newTypeDeclaration), element.getFirstChild());
                element.addAfter(FlowJSTypeExplicitlyIntention.getColonPsiElement(containingFile.getProject(), newTypeDeclaration), element.getFirstChild());
            }
        } else if (element.getParent() instanceof JSFunctionExpression || element.getParent() instanceof JSFunction) {
            Object expression = element.getParent() instanceof JSFunctionExpression ? (JSFunctionExpression)element.getParent() : (JSFunction)element.getParent();
            PsiFile containingFile = expression.getContainingFile();
            String newTypeDeclaration = FlowJSTypeExplicitlyIntention.getFunctionType(FlowJSTypeExplicitlyIntention.getTypeOfFunctions(element));
            JSParameterList parameterList = expression.getParameterList();
            if (!FlowJSTypeExplicitlyIntention.checkType(newTypeDeclaration) || parameterList == null) {
                return;
            }
            expression.addAfter(FlowJSTypeExplicitlyIntention.getParameterTypePsiElement(containingFile.getProject(), newTypeDeclaration), (PsiElement)parameterList);
            expression.addAfter(FlowJSTypeExplicitlyIntention.getColonPsiElement(containingFile.getProject(), newTypeDeclaration), (PsiElement)parameterList);
        } else if (element.getParent() instanceof JSVariable) {
            JSVarStatement createdStatement;
            JSVariable createdVar;
            JSVariable variable = (JSVariable)element.getParent();
            String newTypeDeclaration = FlowJSTypeExplicitlyIntention.getTypeOfFunctions(element.getParent());
            if (!FlowJSTypeExplicitlyIntention.checkType(newTypeDeclaration)) {
                return;
            }
            StringBuilder declarationBuffer = new StringBuilder();
            declarationBuffer.append("var ");
            declarationBuffer.append(variable.getName());
            declarationBuffer.append(":");
            declarationBuffer.append(newTypeDeclaration);
            JSExpression initializer = variable.getInitializer();
            if (initializer != null) {
                declarationBuffer.append("=");
                declarationBuffer.append(initializer.getText());
            }
            JSVariable jSVariable = createdVar = (createdStatement = (JSVarStatement)JSChangeUtil.createStatementPsiFromTextWithContext((String)declarationBuffer.toString(), (PsiElement)variable, JSVarStatement.class)) != null ? (JSVariable)ArrayUtil.getFirstElement((Object[])createdStatement.getVariables()) : null;
            if (createdVar == null) {
                return;
            }
            createdVar = (JSVariable)variable.replace((PsiElement)createdVar);
            JSElementFactory.reformat((PsiElement)createdVar);
        }
    }

    private static boolean checkType(@NotNull String type) {
        if (type == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(11);
        }
        return !type.isEmpty() && !type.equals("(unknown)");
    }

    @NotNull
    private static String getTypeOfFunctions(PsiElement element) {
        if (ApplicationManager.getApplication().isUnitTestMode() && element.getContainingFile() != null) {
            PsiElement[] children = element.getContainingFile().getChildren();
            String string = children[2].getText().substring(2);
            if (string == null) {
                FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(12);
            }
            return string;
        }
        PsiFile containingFile = element.getContainingFile();
        FlowJSServerService service = FlowJSServerManager.getService((PsiFile)containingFile);
        if (service != null) {
            FlowJSServerService.saveSyncAllUnsavedFiles((PsiFile)containingFile);
            Document document = element.getContainingFile().getViewProvider().getDocument();
            if (document != null) {
                String string = service.getTypeOfElement(element, containingFile.getVirtualFile(), document);
                if (string == null) {
                    FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        if ("" == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(14);
        }
        return "";
    }

    @NotNull
    private static String getFunctionType(String serverType) {
        String[] array = serverType.split("=>");
        int numberOfOpenBracket = 0;
        StringBuilder functionType = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if ((numberOfOpenBracket = FlowJSTypeExplicitlyIntention.isCorrectBracketString(array[i], numberOfOpenBracket)) != 0) continue;
            for (int j = i + 1; j < array.length; ++j) {
                functionType.append(array[j]);
                if (j + 1 == array.length) continue;
                functionType.append("=>");
            }
            String string = functionType.toString();
            if (string == null) {
                FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(15);
            }
            return string;
        }
        if ("" == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(16);
        }
        return "";
    }

    private static int isCorrectBracketString(@NotNull String string, int numberOfOpenBracketsBefore) {
        if (string == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(17);
        }
        for (int i = 0; i < string.length(); ++i) {
            char letter = string.charAt(i);
            if (letter == '(' || letter == '[' || letter == '{') {
                ++numberOfOpenBracketsBefore;
            }
            if (letter != ')' && letter != ']' && letter != '}') continue;
            --numberOfOpenBracketsBefore;
        }
        return numberOfOpenBracketsBefore;
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = PREDICATE;
        if (jSElementPredicate == null) {
            FlowJSTypeExplicitlyIntention.$$$reportNull$$$0(18);
        }
        return jSElementPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTypeDeclaration";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/initialization/FlowJSTypeExplicitlyIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getColonPsiElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypePsiElement";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeOfFunctions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStatementWithType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColonPsiElement";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypePsiElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectBracketString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

