/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.util.ParenthesesUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementFactory {
    private static final String DUMMY_FILE_NAME_PREFIX = "dummy.";

    private JSElementFactory() {
    }

    public static PsiElement addElementBefore(@NotNull PsiElement element, @NotNull PsiElement newElement) {
        if (element == null) {
            JSElementFactory.$$$reportNull$$$0(0);
        }
        if (newElement == null) {
            JSElementFactory.$$$reportNull$$$0(1);
        }
        ASTNode oldElementParentNode = element.getNode();
        PsiElement parentNode = element.getParent();
        ASTNode newElementParentNode = parentNode.getNode();
        ASTNode newElementNode = newElement.getNode();
        if (newElementParentNode == null || newElementNode == null) {
            return null;
        }
        newElementParentNode.addChild(newElementNode, oldElementParentNode);
        return newElement;
    }

    public static PsiElement addElementBefore(@NotNull PsiElement element, @NotNull String elementText) {
        if (element == null) {
            JSElementFactory.$$$reportNull$$$0(2);
        }
        if (elementText == null) {
            JSElementFactory.$$$reportNull$$$0(3);
        }
        PsiElement newElement = JSElementFactory.createDummyFile(element.getProject(), elementText).getFirstChild();
        assert (newElement != null);
        return JSElementFactory.addElementBefore(element, newElement);
    }

    @NotNull
    private static PsiFile createDummyFile(Project project, String text) {
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage());
        assert (def != null);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(DUMMY_FILE_NAME_PREFIX + JavaScriptSupportLoader.JAVASCRIPT.getDefaultExtension(), text);
        if (psiFile == null) {
            JSElementFactory.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    @Nullable
    public static JSExpression replaceExpression(@NotNull JSExpression expression, @NotNull String text) throws IncorrectOperationException {
        if (expression == null) {
            JSElementFactory.$$$reportNull$$$0(5);
        }
        if (text == null) {
            JSElementFactory.$$$reportNull$$$0(6);
        }
        return com.intellij.lang.javascript.psi.JSElementFactory.replaceExpression((JSExpression)expression, (String)text);
    }

    public static JSExpression replaceExpression(@NotNull JSExpression expression, @NotNull JSExpression newExpression) throws IncorrectOperationException {
        if (expression == null) {
            JSElementFactory.$$$reportNull$$$0(7);
        }
        if (newExpression == null) {
            JSElementFactory.$$$reportNull$$$0(8);
        }
        return com.intellij.lang.javascript.psi.JSElementFactory.replaceExpression((JSExpression)expression, (JSExpression)newExpression);
    }

    public static void replaceExpressionWithNegatedExpression(@NotNull JSExpression newExpression, @NotNull JSExpression exp) throws IncorrectOperationException {
        String replacementString;
        JSExpression expressionToReplace;
        if (newExpression == null) {
            JSElementFactory.$$$reportNull$$$0(9);
        }
        if (exp == null) {
            JSElementFactory.$$$reportNull$$$0(10);
        }
        if ((expressionToReplace = BoolUtils.findNegation(exp)) == null) {
            expressionToReplace = exp;
            if (ComparisonUtils.isComparison((JSExpression)newExpression)) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)newExpression;
                IElementType operationSign = binaryExpression.getOperationSign();
                String negatedComparison = ComparisonUtils.getNegatedOperatorText((IElementType)operationSign);
                JSExpression leftOperand = binaryExpression.getLOperand();
                JSExpression rightOperand = binaryExpression.getROperand();
                assert (rightOperand != null);
                replacementString = leftOperand.getText() + negatedComparison + rightOperand.getText();
            } else {
                replacementString = '!' + ParenthesesUtils.getParenthesized((JSExpression)newExpression, (int)3);
            }
        } else {
            replacementString = newExpression.getText();
        }
        JSElementFactory.replaceExpression(expressionToReplace, replacementString);
    }

    public static void replaceExpressionWithNegatedExpressionString(@NotNull JSExpression exp, String newExpression) throws IncorrectOperationException {
        if (exp == null) {
            JSElementFactory.$$$reportNull$$$0(11);
        }
        JSExpression expressionToReplace = BoolUtils.findNegation(exp);
        String replacementString = newExpression;
        if (expressionToReplace == null) {
            expressionToReplace = exp;
            replacementString = "!(" + newExpression + ')';
        } else {
            PsiElement parent = expressionToReplace.getParent();
            if (parent instanceof JSBinaryExpression && exp instanceof JSBinaryExpression) {
                IElementType parentSign = ((JSBinaryExpression)parent).getOperationSign();
                IElementType childSign = ((JSBinaryExpression)exp).getOperationSign();
                if (childSign == JSTokenTypes.ANDAND && parentSign == JSTokenTypes.ANDAND) {
                    replacementString = "(" + newExpression + ")";
                }
            }
        }
        JSElementFactory.replaceExpression(expressionToReplace, replacementString);
    }

    public static void removeRange(@NotNull PsiElement from, @NotNull PsiElement to) {
        if (from == null) {
            JSElementFactory.$$$reportNull$$$0(12);
        }
        if (to == null) {
            JSElementFactory.$$$reportNull$$$0(13);
        }
        FormatFixer ff = FormatFixer.create((PsiElement)from, (PsiElement)to, (FormatFixer.Mode)FormatFixer.Mode.FirstLinebreak);
        from.getParent().deleteChildRange(from, to);
        ff.fixFormat();
    }

    public static PsiElement getNonWhiteSpaceSibling(PsiElement element, boolean forward) {
        return forward ? PsiTreeUtil.skipWhitespacesForward((PsiElement)element) : PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/psiutil/JSElementFactory";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/psiutil/JSElementFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addElementBefore";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionWithNegatedExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionWithNegatedExpressionString";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

