/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleCoverageAnnotator
extends BaseCoverageAnnotator {
    private final Map<String, BaseCoverageAnnotator.FileCoverageInfo> myFileCoverageInfos = new HashMap();
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> myTestDirCoverageInfos = new HashMap();
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> myDirCoverageInfos = new HashMap();

    public SimpleCoverageAnnotator(Project project) {
        super(project);
    }

    @Override
    public void onSuiteChosen(CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.myFileCoverageInfos.clear();
        this.myTestDirCoverageInfos.clear();
        this.myDirCoverageInfos.clear();
    }

    @Nullable
    protected BaseCoverageAnnotator.DirCoverageInfo getDirCoverageInfo(@NotNull PsiDirectory directory, @NotNull CoverageSuitesBundle currentSuite) {
        if (directory == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(0);
        }
        if (currentSuite == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(1);
        }
        VirtualFile dir = directory.getVirtualFile();
        boolean isInTestContent = TestSourcesFilter.isTestSources((VirtualFile)dir, (Project)directory.getProject());
        if (!currentSuite.isTrackTestFolders() && isInTestContent) {
            return null;
        }
        String path = SimpleCoverageAnnotator.normalizeFilePath(dir.getPath());
        return isInTestContent ? this.myTestDirCoverageInfos.get(path) : this.myDirCoverageInfos.get(path);
    }

    @Override
    @Nullable
    public String getDirCoverageInformationString(@NotNull PsiDirectory directory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        BaseCoverageAnnotator.DirCoverageInfo coverageInfo;
        if (directory == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(2);
        }
        if (currentSuite == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(4);
        }
        if ((coverageInfo = this.getDirCoverageInfo(directory, currentSuite)) == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.coveredLineCount > 0 ? "covered" : null;
        }
        String filesCoverageInfo = this.getFilesCoverageInformationString(coverageInfo);
        if (filesCoverageInfo != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(filesCoverageInfo);
            String linesCoverageInfo = this.getLinesCoverageInformationString(coverageInfo);
            if (linesCoverageInfo != null) {
                builder.append(", ").append(linesCoverageInfo);
            }
            return builder.toString();
        }
        return null;
    }

    @Deprecated
    public static String getFilePath(String filePath) {
        return SimpleCoverageAnnotator.normalizeFilePath(filePath);
    }

    @NotNull
    private static String normalizeFilePath(@NotNull String filePath) {
        if (filePath == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(5);
        }
        if (SystemInfo.isWindows) {
            filePath = filePath.toLowerCase();
        }
        String string = FileUtil.toSystemIndependentName((String)filePath);
        if (string == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public String getFileCoverageInformationString(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        if (psiFile == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(7);
        }
        if (currentSuite == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(9);
        }
        VirtualFile file = psiFile.getVirtualFile();
        assert (file != null);
        String path = SimpleCoverageAnnotator.normalizeFilePath(file.getPath());
        BaseCoverageAnnotator.FileCoverageInfo coverageInfo = this.myFileCoverageInfos.get(path);
        if (coverageInfo == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.coveredLineCount > 0 ? "covered" : null;
        }
        return this.getLinesCoverageInformationString(coverageInfo);
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo collectBaseFileCoverage(@NotNull VirtualFile file, @NotNull Annotator annotator, @NotNull ProjectData projectData, @NotNull Map<String, String> normalizedFiles2Files) {
        String filePath;
        ClassData classData;
        BaseCoverageAnnotator.FileCoverageInfo info;
        if (file == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(10);
        }
        if (annotator == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(11);
        }
        if (projectData == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(12);
        }
        if (normalizedFiles2Files == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(13);
        }
        if ((info = (classData = SimpleCoverageAnnotator.getClassData(filePath = SimpleCoverageAnnotator.normalizeFilePath(file.getPath()), projectData, normalizedFiles2Files)) != null ? this.fileInfoForCoveredFile(classData) : this.fillInfoForUncoveredFile(VfsUtilCore.virtualToIoFile((VirtualFile)file))) != null) {
            annotator.annotateFile(filePath, info);
        }
        return info;
    }

    @Nullable
    private static ClassData getClassData(@NotNull String filePath, @NotNull ProjectData data, @NotNull Map<String, String> normalizedFiles2Files) {
        String originalFileName;
        if (filePath == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(14);
        }
        if (data == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(15);
        }
        if (normalizedFiles2Files == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(16);
        }
        if ((originalFileName = normalizedFiles2Files.get(filePath)) == null) {
            return null;
        }
        return data.getClassData(originalFileName);
    }

    @Nullable
    protected BaseCoverageAnnotator.DirCoverageInfo collectFolderCoverage(@NotNull VirtualFile dir, @NotNull CoverageDataManager dataManager, Annotator annotator, ProjectData projectInfo, boolean trackTestFolders, @NotNull ProjectFileIndex index, @NotNull CoverageEngine coverageEngine, Set<VirtualFile> visitedDirs, @NotNull Map<String, String> normalizedFiles2Files) {
        if (dir == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(17);
        }
        if (dataManager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(18);
        }
        if (index == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(19);
        }
        if (coverageEngine == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(20);
        }
        if (normalizedFiles2Files == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(21);
        }
        if (!index.isInContent(dir)) {
            return null;
        }
        if (visitedDirs.contains(dir)) {
            return null;
        }
        if (!this.shouldCollectCoverageInsideLibraryDirs() && (index.isInLibrarySource(dir) || index.isInLibraryClasses(dir))) {
            return null;
        }
        visitedDirs.add(dir);
        boolean isInTestSrcContent = TestSourcesFilter.isTestSources((VirtualFile)dir, (Project)this.getProject());
        if (!trackTestFolders && isInTestSrcContent) {
            return null;
        }
        VirtualFile[] children = (VirtualFile[])dataManager.doInReadActionIfProjectOpen(() -> ((VirtualFile)dir).getChildren());
        if (children == null) {
            return null;
        }
        BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo = new BaseCoverageAnnotator.DirCoverageInfo();
        for (VirtualFile fileOrDir : children) {
            BaseCoverageAnnotator.FileCoverageInfo fileInfo;
            if (fileOrDir.isDirectory()) {
                BaseCoverageAnnotator.DirCoverageInfo childCoverageInfo = this.collectFolderCoverage(fileOrDir, dataManager, annotator, projectInfo, trackTestFolders, index, coverageEngine, visitedDirs, normalizedFiles2Files);
                if (childCoverageInfo == null) continue;
                dirCoverageInfo.totalFilesCount += childCoverageInfo.totalFilesCount;
                dirCoverageInfo.coveredFilesCount += childCoverageInfo.coveredFilesCount;
                dirCoverageInfo.totalLineCount += childCoverageInfo.totalLineCount;
                dirCoverageInfo.coveredLineCount += childCoverageInfo.coveredLineCount;
                continue;
            }
            if (!coverageEngine.coverageProjectViewStatisticsApplicableTo(fileOrDir) || (fileInfo = this.collectBaseFileCoverage(fileOrDir, annotator, projectInfo, normalizedFiles2Files)) == null) continue;
            dirCoverageInfo.totalLineCount += fileInfo.totalLineCount;
            ++dirCoverageInfo.totalFilesCount;
            if (fileInfo.coveredLineCount <= 0) continue;
            ++dirCoverageInfo.coveredFilesCount;
            dirCoverageInfo.coveredLineCount += fileInfo.coveredLineCount;
        }
        if (dirCoverageInfo.totalFilesCount == 0) {
            return null;
        }
        String dirPath = SimpleCoverageAnnotator.normalizeFilePath(dir.getPath());
        if (isInTestSrcContent) {
            annotator.annotateTestDirectory(dirPath, dirCoverageInfo);
        } else {
            annotator.annotateSourceDirectory(dirPath, dirCoverageInfo);
        }
        return dirCoverageInfo;
    }

    protected boolean shouldCollectCoverageInsideLibraryDirs() {
        return true;
    }

    public void annotate(@NotNull VirtualFile contentRoot, @NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager, @NotNull ProjectData data, Project project, Annotator annotator) {
        if (contentRoot == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(22);
        }
        if (suite == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(23);
        }
        if (dataManager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(24);
        }
        if (data == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(25);
        }
        if (!contentRoot.isValid()) {
            return;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Set files = data.getClasses().keySet();
        java.util.HashMap normalizedFiles2Files = ContainerUtil.newHashMap();
        for (String file : files) {
            normalizedFiles2Files.put(SimpleCoverageAnnotator.normalizeFilePath(file), file);
        }
        this.collectFolderCoverage(contentRoot, dataManager, annotator, data, suite.isTrackTestFolders(), index, suite.getCoverageEngine(), ContainerUtil.newHashSet(), Collections.unmodifiableMap(normalizedFiles2Files));
    }

    @Override
    @Nullable
    protected Runnable createRenewRequest(@NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager) {
        ProjectData data;
        if (suite == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(26);
        }
        if (dataManager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(27);
        }
        if ((data = suite.getCoverageData()) == null) {
            return null;
        }
        return () -> {
            Project project;
            ProjectRootManager rootManager;
            VirtualFile[] modulesContentRoots;
            if (dataManager == null) {
                SimpleCoverageAnnotator.$$$reportNull$$$0(33);
            }
            if (suite == null) {
                SimpleCoverageAnnotator.$$$reportNull$$$0(34);
            }
            if ((modulesContentRoots = (VirtualFile[])dataManager.doInReadActionIfProjectOpen(() -> SimpleCoverageAnnotator.lambda$null$0(rootManager = ProjectRootManager.getInstance((Project)(project = this.getProject()))))) == null) {
                return;
            }
            for (VirtualFile root : modulesContentRoots) {
                this.annotate(root, suite, dataManager, data, project, new Annotator(){

                    @Override
                    public void annotateSourceDirectory(String dirPath, BaseCoverageAnnotator.DirCoverageInfo info) {
                        SimpleCoverageAnnotator.this.myDirCoverageInfos.put(dirPath, info);
                    }

                    @Override
                    public void annotateTestDirectory(String dirPath, BaseCoverageAnnotator.DirCoverageInfo info) {
                        SimpleCoverageAnnotator.this.myTestDirCoverageInfos.put(dirPath, info);
                    }

                    @Override
                    public void annotateFile(@NotNull String filePath, @NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
                        if (filePath == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (info == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        SimpleCoverageAnnotator.this.myFileCoverageInfos.put(filePath, info);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "filePath";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "info";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/coverage/SimpleCoverageAnnotator$1";
                        objectArray[2] = "annotateFile";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            dataManager.triggerPresentationUpdate();
        };
    }

    @Nullable
    protected String getLinesCoverageInformationString(@NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
        if (info == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(28);
        }
        return SimpleCoverageAnnotator.calcCoveragePercentage(info) + "% lines covered";
    }

    protected static int calcCoveragePercentage(BaseCoverageAnnotator.FileCoverageInfo info) {
        return SimpleCoverageAnnotator.calcPercent(info.coveredLineCount, info.totalLineCount);
    }

    private static int calcPercent(int covered, int total) {
        return total != 0 ? (int)((double)covered / (double)total * 100.0) : 100;
    }

    @Nullable
    protected String getFilesCoverageInformationString(@NotNull BaseCoverageAnnotator.DirCoverageInfo info) {
        if (info == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(29);
        }
        return SimpleCoverageAnnotator.calcPercent(info.coveredFilesCount, info.totalFilesCount) + "% files";
    }

    @Nullable
    private BaseCoverageAnnotator.FileCoverageInfo fileInfoForCoveredFile(@NotNull ClassData classData) {
        Object[] lines;
        int count;
        if (classData == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(30);
        }
        if ((count = (lines = classData.getLines()).length - 1) == 0) {
            return null;
        }
        BaseCoverageAnnotator.FileCoverageInfo info = new BaseCoverageAnnotator.FileCoverageInfo();
        info.coveredLineCount = 0;
        info.totalLineCount = 0;
        for (int i = 1; i <= count; ++i) {
            LineData lineData = classData.getLineData(i);
            this.processLineData(info, lineData);
        }
        return info;
    }

    protected void processLineData(@NotNull BaseCoverageAnnotator.FileCoverageInfo info, @Nullable LineData lineData) {
        if (info == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(31);
        }
        if (lineData == null) {
            return;
        }
        int status = lineData.getStatus();
        if (status != 0) {
            ++info.coveredLineCount;
        }
        ++info.totalLineCount;
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo fillInfoForUncoveredFile(@NotNull File file) {
        if (file == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(32);
        }
        return null;
    }

    private static /* synthetic */ VirtualFile[] lambda$null$0(ProjectRootManager rootManager) {
        return rootManager.getContentRoots();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/SimpleCoverageAnnotator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 13: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedFiles2Files";
                break;
            }
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 18: 
            case 24: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageEngine";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 23: 
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/SimpleCoverageAnnotator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDirCoverageInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDirCoverageInformationString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizeFilePath";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileCoverageInformationString";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectBaseFileCoverage";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getClassData";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectFolderCoverage";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createRenewRequest";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLinesCoverageInformationString";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFilesCoverageInformationString";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fileInfoForCoveredFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processLineData";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fillInfoForUncoveredFile";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRenewRequest$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Annotator {
        public void annotateSourceDirectory(String var1, BaseCoverageAnnotator.DirCoverageInfo var2);

        public void annotateTestDirectory(String var1, BaseCoverageAnnotator.DirCoverageInfo var2);

        public void annotateFile(@NotNull String var1, @NotNull BaseCoverageAnnotator.FileCoverageInfo var2);
    }
}

