/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.view.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.websocket.WebSocketProjectComponent;
import com.intellij.websocket.view.WebSocketViewSettings;
import com.intellij.websocket.view.WebsocketFinderRecursivePanel;

public class ShowResourcesAction
extends ToggleAction {
    private WebsocketFinderRecursivePanel myPanel;

    public ShowResourcesAction(WebsocketFinderRecursivePanel panel) {
        this.myPanel = panel;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setText("Resources/Classes View");
        e.getPresentation().setIcon(AllIcons.Nodes.ResourceBundle);
    }

    public boolean isSelected(AnActionEvent e) {
        return this.myPanel.isShowResourcesView();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        WebSocketViewSettings viewSettings;
        if (state != this.myPanel.isShowResourcesView() && (viewSettings = WebSocketProjectComponent.getInstance(this.myPanel.getProject()).getState()) != null) {
            viewSettings.showResources = state;
            this.myPanel.updatePanel();
        }
    }
}

