/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.deobfuscator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.GenericDominatorEngine;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraph;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.IGraphNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ExceptionDeobfuscator {
    public static void restorePopRanges(ControlFlowGraph graph) {
        ArrayList<Range> lstRanges = new ArrayList<Range>();
        for (ExceptionRangeCFG exceptionRangeCFG : graph.getExceptions()) {
            boolean found = false;
            for (Range arr : lstRanges) {
                if (arr.handler != exceptionRangeCFG.getHandler() || !InterpreterUtil.equalObjects(exceptionRangeCFG.getUniqueExceptionsString(), arr.uniqueStr)) continue;
                arr.protectedRange.addAll(exceptionRangeCFG.getProtectedRange());
                found = true;
                break;
            }
            if (found) continue;
            lstRanges.add(new Range(exceptionRangeCFG.getHandler(), exceptionRangeCFG.getUniqueExceptionsString(), new HashSet<BasicBlock>(exceptionRangeCFG.getProtectedRange()), exceptionRangeCFG));
        }
        for (Range range : lstRanges) {
            BasicBlock handler;
            InstructionSequence seq;
            if (range.uniqueStr == null || (seq = (handler = range.handler).getSeq()).length() <= 0) continue;
            Instruction firstinstr = seq.getInstr(0);
            if (firstinstr.opcode != 87 && firstinstr.opcode != 58) continue;
            HashSet setrange = new HashSet(range.protectedRange);
            for (Range range_super : lstRanges) {
                if (range == range_super) continue;
                HashSet setrange_super = new HashSet(range_super.protectedRange);
                if (setrange.contains(range_super.handler) || setrange_super.contains(handler) || range_super.uniqueStr != null && !setrange_super.containsAll(setrange)) continue;
                if (range_super.uniqueStr == null) {
                    setrange_super.retainAll(setrange);
                } else {
                    setrange_super.removeAll(setrange);
                }
                if (setrange_super.isEmpty()) continue;
                BasicBlock newblock = handler;
                if (seq.length() > 1) {
                    newblock = new BasicBlock(++graph.last_id);
                    SimpleInstructionSequence newseq = new SimpleInstructionSequence();
                    newseq.addInstruction(firstinstr.clone(), -1);
                    newblock.setSeq(newseq);
                    graph.getBlocks().addWithKey(newblock, newblock.id);
                    ArrayList<BasicBlock> lstTemp = new ArrayList<BasicBlock>();
                    lstTemp.addAll(handler.getPreds());
                    lstTemp.addAll(handler.getPredExceptions());
                    for (BasicBlock pred : lstTemp) {
                        pred.replaceSuccessor(handler, newblock);
                    }
                    for (ExceptionRangeCFG range_ext : graph.getExceptions()) {
                        if (range_ext.getHandler() == handler) {
                            range_ext.setHandler(newblock);
                            continue;
                        }
                        if (!range_ext.getProtectedRange().contains(handler)) continue;
                        newblock.addSuccessorException(range_ext.getHandler());
                        range_ext.getProtectedRange().add(newblock);
                    }
                    newblock.addSuccessor(handler);
                    if (graph.getFirst() == handler) {
                        graph.setFirst(newblock);
                    }
                    seq.removeInstruction(0);
                }
                newblock.addSuccessorException(range_super.handler);
                range_super.rangeCFG.getProtectedRange().add(newblock);
                handler = range.rangeCFG.getHandler();
                seq = handler.getSeq();
            }
        }
    }

    public static void insertEmptyExceptionHandlerBlocks(ControlFlowGraph graph) {
        HashSet<BasicBlock> setVisited = new HashSet<BasicBlock>();
        for (ExceptionRangeCFG range : graph.getExceptions()) {
            BasicBlock handler = range.getHandler();
            if (setVisited.contains(handler)) continue;
            setVisited.add(handler);
            BasicBlock emptyblock = new BasicBlock(++graph.last_id);
            graph.getBlocks().addWithKey(emptyblock, emptyblock.id);
            ArrayList<BasicBlock> lstTemp = new ArrayList<BasicBlock>(handler.getPredExceptions());
            for (BasicBlock pred : lstTemp) {
                pred.replaceSuccessor(handler, emptyblock);
            }
            for (ExceptionRangeCFG range_ext : graph.getExceptions()) {
                if (range_ext.getHandler() == handler) {
                    range_ext.setHandler(emptyblock);
                    continue;
                }
                if (!range_ext.getProtectedRange().contains(handler)) continue;
                emptyblock.addSuccessorException(range_ext.getHandler());
                range_ext.getProtectedRange().add(emptyblock);
            }
            emptyblock.addSuccessor(handler);
            if (graph.getFirst() != handler) continue;
            graph.setFirst(emptyblock);
        }
    }

    public static void removeEmptyRanges(ControlFlowGraph graph) {
        List<ExceptionRangeCFG> lstRanges = graph.getExceptions();
        for (int i = lstRanges.size() - 1; i >= 0; --i) {
            ExceptionRangeCFG range = lstRanges.get(i);
            boolean isEmpty = true;
            for (BasicBlock block : range.getProtectedRange()) {
                if (block.getSeq().isEmpty()) continue;
                isEmpty = false;
                break;
            }
            if (!isEmpty) continue;
            for (BasicBlock block : range.getProtectedRange()) {
                block.removeSuccessorException(range.getHandler());
            }
            lstRanges.remove(i);
        }
    }

    public static void removeCircularRanges(final ControlFlowGraph graph) {
        GenericDominatorEngine engine = new GenericDominatorEngine(new IGraph(){

            @Override
            public List<? extends IGraphNode> getReversePostOrderList() {
                return graph.getReversePostOrder();
            }

            @Override
            public Set<? extends IGraphNode> getRoots() {
                return new HashSet<IGraphNode>(Arrays.asList(graph.getFirst()));
            }
        });
        engine.initialize();
        List<ExceptionRangeCFG> lstRanges = graph.getExceptions();
        for (int i = lstRanges.size() - 1; i >= 0; --i) {
            ExceptionRangeCFG range = lstRanges.get(i);
            BasicBlock handler = range.getHandler();
            List<BasicBlock> rangeList = range.getProtectedRange();
            if (!rangeList.contains(handler)) continue;
            List<BasicBlock> lstRemBlocks = ExceptionDeobfuscator.getReachableBlocksRestricted(range, engine);
            if (lstRemBlocks.size() < rangeList.size() || rangeList.size() == 1) {
                for (BasicBlock block : lstRemBlocks) {
                    block.removeSuccessorException(handler);
                    rangeList.remove(block);
                }
            }
            if (!rangeList.isEmpty()) continue;
            lstRanges.remove(i);
        }
    }

    private static List<BasicBlock> getReachableBlocksRestricted(ExceptionRangeCFG range, GenericDominatorEngine engine) {
        ArrayList<BasicBlock> lstRes = new ArrayList<BasicBlock>();
        LinkedList<BasicBlock> stack = new LinkedList<BasicBlock>();
        HashSet<BasicBlock> setVisited = new HashSet<BasicBlock>();
        BasicBlock handler = range.getHandler();
        stack.addFirst(handler);
        while (!stack.isEmpty()) {
            BasicBlock block = (BasicBlock)stack.removeFirst();
            setVisited.add(block);
            if (!range.getProtectedRange().contains(block) || !engine.isDominator(block, handler)) continue;
            lstRes.add(block);
            ArrayList<BasicBlock> lstSuccs = new ArrayList<BasicBlock>(block.getSuccs());
            lstSuccs.addAll(block.getSuccExceptions());
            for (BasicBlock succ : lstSuccs) {
                if (setVisited.contains(succ)) continue;
                stack.add(succ);
            }
        }
        return lstRes;
    }

    public static boolean hasObfuscatedExceptions(ControlFlowGraph graph) {
        HashMap<BasicBlock, HashSet<BasicBlock>> mapRanges = new HashMap<BasicBlock, HashSet<BasicBlock>>();
        for (ExceptionRangeCFG exceptionRangeCFG : graph.getExceptions()) {
            HashSet<BasicBlock> set = (HashSet<BasicBlock>)mapRanges.get(exceptionRangeCFG.getHandler());
            if (set == null) {
                set = new HashSet<BasicBlock>();
                mapRanges.put(exceptionRangeCFG.getHandler(), set);
            }
            set.addAll(exceptionRangeCFG.getProtectedRange());
        }
        for (Map.Entry entry : mapRanges.entrySet()) {
            HashSet<BasicBlock> setEntries = new HashSet<BasicBlock>();
            for (BasicBlock block : (Set)entry.getValue()) {
                HashSet<BasicBlock> setTemp = new HashSet<BasicBlock>(block.getPreds());
                setTemp.removeAll((Collection)entry.getValue());
                if (setTemp.isEmpty()) continue;
                setEntries.add(block);
            }
            if (setEntries.isEmpty() || setEntries.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private static class Range {
        private final BasicBlock handler;
        private final String uniqueStr;
        private final Set<BasicBlock> protectedRange;
        private final ExceptionRangeCFG rangeCFG;

        private Range(BasicBlock handler, String uniqueStr, Set<BasicBlock> protectedRange, ExceptionRangeCFG rangeCFG) {
            this.handler = handler;
            this.uniqueStr = uniqueStr;
            this.protectedRange = protectedRange;
            this.rangeCFG = rangeCFG;
        }
    }
}

