/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSFileType;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.scss.SCSSFileType;
import org.jetbrains.plugins.scss.index.SassScssIndexedRootProvider;
import org.jetbrains.plugins.scss.psi.SCSSEachStatementImpl;
import org.jetbrains.plugins.scss.psi.SCSSForStatementImpl;
import org.jetbrains.plugins.scss.psi.SCSSIfStatementImpl;
import org.jetbrains.plugins.scss.psi.SCSSWhileStatementImpl;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclarationImpl;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssMixinDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssPlaceholderSelector;
import org.jetbrains.plugins.scss.psi.SassScssPropertyRuleset;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;

public class SASSSCSSLangUtil {
    public static final int IMPORTED_ELEMENT_PRIORITY = 30;
    private static final int KEYWORD_ELEMENT_PRIORITY = 70;
    private static final String NMSTART = "(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))";
    private static final String NMCHAR = "((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))";
    private static final String IDENT = "[_-]?(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))*";
    private static final Pattern IDENT_PATTERN = Pattern.compile("[_-]?(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))*");
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$?[_-]?(([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))((([A-z_])|(\\\\[ -~])|[^\u0000-\u007f]|(\\\\[0-9a-fA-F]{1,6}))|([0-9_-]))*");
    public static final Class[] ELEMENT_SCOPES = new Class[]{PsiFile.class, CssRuleset.class, CssAtRule.class, SassScssMixinDeclaration.class, SCSSForStatementImpl.class, SCSSEachStatementImpl.class, SCSSWhileStatementImpl.class, SCSSIfStatementImpl.class, SassScssInclude.class, SassScssFunctionDeclarationImpl.class};

    public static boolean isValidScope(PsiElement element) {
        for (Class scope : ELEMENT_SCOPES) {
            if (!scope.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String normalizeName(@Nullable String name) {
        if (name == null || !StringUtil.containsChar((String)name, (char)'-')) {
            return name;
        }
        return StringUtil.notNullize((String)name).replace('-', '_');
    }

    public static boolean isValidVariableName(@NotNull String name) {
        if (name == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(0);
        }
        return VARIABLE_PATTERN.matcher(name).matches();
    }

    public static boolean isValidMixinName(@NotNull String name) {
        if (name == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(1);
        }
        return IDENT_PATTERN.matcher(name).matches();
    }

    public static boolean isValidFunctionName(@NotNull String name) {
        if (name == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(2);
        }
        return IDENT_PATTERN.matcher(name).matches();
    }

    public static boolean isValidSelectorName(@NotNull String name) {
        if (name == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(3);
        }
        return IDENT_PATTERN.matcher(name).matches();
    }

    public static String restoreFullPropertyName(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(4);
        }
        StringBuilder result = new StringBuilder(propertyName);
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context, CssDeclaration.class, (boolean)false);
        context = declaration != null ? declaration.getParent() : context;
        SassScssPropertyRuleset propertyRuleset = (SassScssPropertyRuleset)PsiTreeUtil.getParentOfType((PsiElement)context, SassScssPropertyRuleset.class);
        while (propertyRuleset != null) {
            String namespace = propertyRuleset.getNamespace();
            if (!namespace.isEmpty()) {
                result.insert(0, '-');
                result.insert(0, namespace);
            }
            propertyRuleset = (SassScssPropertyRuleset)PsiTreeUtil.getParentOfType((PsiElement)propertyRuleset, SassScssPropertyRuleset.class);
        }
        return result.toString();
    }

    public static boolean isVisibleDeclaration(@NotNull PsiElement declaration, @NotNull PsiElement reference) {
        CssRuleset rulesetParent;
        if (declaration == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(5);
        }
        if (reference == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(6);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)reference, CssSelectorList.class, (boolean)false) != null && (rulesetParent = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)reference, CssRuleset.class)) != null) {
            reference = rulesetParent;
        }
        if (declaration.getTextOffset() > reference.getTextOffset() && declaration.getContainingFile().getOriginalFile() == reference.getContainingFile().getOriginalFile()) {
            return false;
        }
        PsiElement declarationScope = SASSSCSSLangUtil.getOriginalScope(declaration);
        PsiElement originalScope = SASSSCSSLangUtil.getOriginalScope(reference);
        return declarationScope instanceof PsiFile || originalScope != null && PsiTreeUtil.isAncestor((PsiElement)declarationScope, (PsiElement)originalScope, (boolean)false);
    }

    @Nullable
    public static PsiElement getOriginalScope(PsiElement reference) {
        PsiElement myElementScope = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])ELEMENT_SCOPES);
        if (myElementScope instanceof SassScssInclude && myElementScope.getParent() instanceof CssRuleset) {
            myElementScope = myElementScope.getParent();
        }
        PsiElement originalScope = myElementScope != null ? CompletionUtil.getOriginalElement((PsiElement)myElementScope) : null;
        return originalScope == null && myElementScope != null ? SASSSCSSLangUtil.getOriginalScope(myElementScope) : originalScope;
    }

    @Nullable
    public static ResolveResult filterOverridedResults(Collection<ResolveResult> result, PsiElement reference) {
        ResolveResult singleResult = null;
        PsiFile originalFile = reference.getContainingFile();
        for (ResolveResult resolveResult : result) {
            PsiElement resolvedElement = resolveResult.getElement();
            if (resolvedElement == null || originalFile != resolvedElement.getContainingFile()) continue;
            if (singleResult == null) {
                singleResult = resolveResult;
                continue;
            }
            PsiElement singleResultElement = singleResult.getElement();
            if (singleResultElement == null || resolvedElement.getTextOffset() <= singleResultElement.getTextOffset()) continue;
            singleResult = resolveResult;
        }
        return singleResult;
    }

    public static LookupElement createKeywordLookupItem(String keyword) {
        return SASSSCSSLangUtil.createKeywordLookupItem(keyword, null);
    }

    public static LookupElement createKeywordLookupItem(String keyword, @Nullable InsertHandler<LookupElement> insertHandler) {
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)keyword).bold().withInsertHandler(insertHandler), (double)70.0);
    }

    @NotNull
    public static LookupElement createMixinLookupItem(SassScssMixinDeclaration declaration, boolean validResult, @NotNull String currentPrefix) {
        if (currentPrefix == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(7);
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        String tailText = validResult ? declaration.getParametersString() : declaration.getParametersString() + " implicitly imported";
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(declaration.getName(), currentPrefix);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)declarationName, (PsiElement)declaration).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withInsertHandler((InsertHandler)(declaration.hasParameters() ? ParenthesesInsertHandler.WITH_PARAMETERS : null)).withTypeText(itemPresentation.getLocationString(), true), (double)(validResult ? 30.0 : 0.0));
        if (lookupElement == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(8);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createVariableLookupItem(@NotNull SassScssVariableDeclaration declaration, boolean validResult, @NotNull String currentPrefix) {
        if (declaration == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(9);
        }
        if (currentPrefix == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(10);
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        String tailText = validResult ? "" : " implicitly imported";
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(declaration.getName(), currentPrefix);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)declarationName, (PsiElement)declaration).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withTypeText(itemPresentation.getLocationString(), true), (double)(validResult ? 30.0 : 0.0));
        if (lookupElement == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(11);
        }
        return lookupElement;
    }

    public static LookupElement createFunctionLookupItem(@NotNull SassScssFunctionDeclaration declaration, boolean validResult, @Nullable String currentPrefix) {
        if (declaration == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(12);
        }
        ItemPresentation itemPresentation = declaration.getPresentation();
        String argumentsString = declaration.getParametersString();
        String tailText = validResult ? argumentsString : argumentsString + " implicitly imported";
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(declaration.getName(), currentPrefix);
        boolean higherPriority = validResult && !"sass_functions.scss".equals(declaration.getContainingFile().getName());
        LookupElement element = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)declarationName, (PsiElement)declaration).withIcon(itemPresentation.getIcon(false)).withBoldness(higherPriority).withTailText(tailText, true).withInsertHandler((InsertHandler)(argumentsString.isEmpty() || "()".equals(argumentsString) ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS)).withTypeText(itemPresentation.getLocationString(), true), (double)(higherPriority ? 30.0 : 0.0));
        return element;
    }

    public static LookupElement createPlaceholderSelectorLookup(@NotNull SassScssPlaceholderSelector selector, @NotNull PsiElement navigationElement, boolean validResult) {
        if (selector == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(13);
        }
        if (navigationElement == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(14);
        }
        ItemPresentation itemPresentation = selector.getPresentation();
        if (selector != navigationElement) {
            itemPresentation = new CssNamedItemPresentation.WithCustomContext(itemPresentation, navigationElement);
        }
        String tailText = validResult ? "" : " implicitly imported";
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)selector.getName(), (PsiElement)navigationElement).withIcon(itemPresentation.getIcon(false)).withBoldness(validResult).withTailText(tailText, true).withTypeText(itemPresentation.getLocationString(), true), (double)(validResult ? 30.0 : 0.0));
    }

    public static LookupElement createCustomFunctionLookupItem(@NotNull SassExtensionFunctionInfo functionInfo, @Nullable String currentPrefix) {
        if (functionInfo == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(15);
        }
        String filePath = functionInfo.getFilePath();
        String fileName = PathUtil.getFileName((String)filePath);
        String argumentString = functionInfo.getArgumentsString();
        String declarationName = SASSSCSSLangUtil.normalizedDeclarationName(functionInfo.getName(), currentPrefix);
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)functionInfo, (String)declarationName).withIcon(AllIcons.Nodes.Function).withTailText("(" + argumentString + ")", true).withInsertHandler((InsertHandler)(argumentString.isEmpty() ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS)).withTypeText(fileName.isEmpty() ? filePath : fileName, true), (double)30.0);
    }

    public static SearchScope restrictedBySassFilesScope(@NotNull SearchScope scope) {
        if (scope == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(16);
        }
        return scope instanceof GlobalSearchScope ? GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)scope), (FileType[])new FileType[]{SASSFileType.SASS, SCSSFileType.SCSS}) : scope;
    }

    public static GlobalSearchScope searchScopeWithSassStdlib(@NotNull PsiElement context) {
        Module module;
        if (context == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(17);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null && SassRubyIntegrationHelper.getInstance().isRubyModule(module)) {
            return CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context);
        }
        return new AdditionalIndexedRootsScope(CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context), SassScssIndexedRootProvider.class);
    }

    @NotNull
    public static String normalizedDeclarationName(@NotNull String declarationName, @Nullable String currentPrefix) {
        if (declarationName == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(18);
        }
        if (StringUtil.isNotEmpty((String)currentPrefix)) {
            String normalizedPrefix = SASSSCSSLangUtil.normalizeName(currentPrefix);
            String normalizedName = SASSSCSSLangUtil.normalizeName(declarationName);
            if (normalizedName.startsWith(normalizedPrefix)) {
                String string = currentPrefix + declarationName.substring(currentPrefix.length());
                if (string == null) {
                    SASSSCSSLangUtil.$$$reportNull$$$0(19);
                }
                return string;
            }
        }
        String string = declarationName;
        if (string == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    public static boolean nameEquals(@NotNull String first, @Nullable String second) {
        if (first == null) {
            SASSSCSSLangUtil.$$$reportNull$$$0(21);
        }
        if (second == null) {
            return false;
        }
        if (first == second) {
            return true;
        }
        if (first.length() != second.length()) {
            return false;
        }
        for (int i = 0; i < first.length(); ++i) {
            char c2;
            char c1 = first.charAt(i);
            if (c1 == (c2 = second.charAt(i)) || c1 == '_' && c2 == '-' || c1 == '-' && c2 == '_') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPrefix";
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/scss/SASSSCSSLangUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/scss/SASSSCSSLangUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createMixinLookupItem";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createVariableLookupItem";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizedDeclarationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidVariableName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidMixinName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidFunctionName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidSelectorName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreFullPropertyName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleDeclaration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMixinLookupItem";
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 20: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createVariableLookupItem";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionLookupItem";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPlaceholderSelectorLookup";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createCustomFunctionLookupItem";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "restrictedBySassFilesScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "searchScopeWithSassStdlib";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "normalizedDeclarationName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "nameEquals";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

