/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.connection;

import com.heroku.api.Heroku;
import com.heroku.api.connection.AsyncConnection;
import com.heroku.api.connection.Connection;
import com.heroku.api.connection.ConnectionProvider;
import com.heroku.api.exception.HerokuAPIException;
import com.heroku.api.http.Http;
import com.heroku.api.request.Request;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.internal.util.Base64;

public class JerseyClientAsyncConnection
implements AsyncConnection<Future<?>> {
    private final Client client;
    private Integer myRemainingRateLimit;

    public JerseyClientAsyncConnection() {
        this(ClientBuilder.newClient((Configuration)JerseyClientAsyncConnection.createClientConfig()));
    }

    public JerseyClientAsyncConnection(Client client) {
        this.client = client;
    }

    public <T> Future<T> executeAsync(final Request<T> request, Map<String, String> extraHeaders, String apiKey) {
        Invocation.Builder builder = this.client.target(Heroku.Config.ENDPOINT.value + request.getEndpoint()).request();
        builder.header("Authorization", (Object)Base64.encodeAsString((byte[])(":" + apiKey).getBytes()));
        builder.header(request.getResponseType().getHeaderName(), (Object)request.getResponseType().getHeaderValue());
        builder.header(Heroku.ApiVersion.v3.getHeaderName(), (Object)Heroku.ApiVersion.v3.getHeaderValue());
        builder.header(Http.ContentType.JSON.getHeaderName(), (Object)Http.ContentType.JSON.getHeaderValue());
        builder.header(Http.UserAgent.LATEST.getHeaderName(), (Object)Http.UserAgent.LATEST.getHeaderValue("jersey-client"));
        for (Map.Entry header : request.getHeaders().entrySet()) {
            builder.header((String)header.getKey(), header.getValue());
        }
        AsyncInvoker invoker = builder.async();
        final Future futureResponse = request.hasBody() ? invoker.method(request.getHttpMethod().name(), Entity.json((Object)request.getBodyAsMap())) : invoker.method(request.getHttpMethod().name());
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return futureResponse.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return futureResponse.isCancelled();
            }

            @Override
            public boolean isDone() {
                return futureResponse.isDone();
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return this.handleResponse((Response)futureResponse.get());
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.handleResponse((Response)futureResponse.get(timeout, unit));
            }

            private T handleResponse(Response r) {
                return request.getResponse((byte[])r.readEntity(byte[].class), r.getStatus(), JerseyClientAsyncConnection.toJavaMap((MultivaluedMap<String, String>)r.getStringHeaders()));
            }
        };
    }

    public <T> Future<T> executeAsync(final Request<T> request, String apiKey) {
        Invocation.Builder builder = this.client.target(Heroku.Config.ENDPOINT.value + request.getEndpoint()).request();
        builder.header("Authorization", (Object)Base64.encodeAsString((byte[])(":" + apiKey).getBytes()));
        builder.header(request.getResponseType().getHeaderName(), (Object)request.getResponseType().getHeaderValue());
        builder.header(Heroku.ApiVersion.v3.getHeaderName(), (Object)Heroku.ApiVersion.v3.getHeaderValue());
        builder.header(Http.ContentType.JSON.getHeaderName(), (Object)Http.ContentType.JSON.getHeaderValue());
        builder.header(Http.UserAgent.LATEST.getHeaderName(), (Object)Http.UserAgent.LATEST.getHeaderValue("jersey-client"));
        for (Map.Entry header : request.getHeaders().entrySet()) {
            builder.header((String)header.getKey(), header.getValue());
        }
        AsyncInvoker invoker = builder.async();
        final Future futureResponse = request.hasBody() ? invoker.method(request.getHttpMethod().name(), Entity.json((Object)request.getBodyAsMap())) : invoker.method(request.getHttpMethod().name());
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return futureResponse.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return futureResponse.isCancelled();
            }

            @Override
            public boolean isDone() {
                return futureResponse.isDone();
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                return this.handleResponse((Response)futureResponse.get());
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.handleResponse((Response)futureResponse.get(timeout, unit));
            }

            private T handleResponse(Response r) {
                String header = (String)r.getHeaders().getFirst((Object)"X-RateLimit-Remaining");
                try {
                    JerseyClientAsyncConnection.this.myRemainingRateLimit = header == null ? null : Integer.valueOf(Integer.parseInt(header));
                }
                catch (NumberFormatException e) {
                    JerseyClientAsyncConnection.this.myRemainingRateLimit = null;
                }
                return request.getResponse((byte[])r.readEntity(byte[].class), r.getStatus(), JerseyClientAsyncConnection.toJavaMap((MultivaluedMap<String, String>)r.getStringHeaders()));
            }
        };
    }

    public <T> T execute(Request<T> request, String apiKey) {
        return this.execute(request, Collections.emptyMap(), apiKey);
    }

    public <T> T execute(Request<T> request, Map<String, String> extraHeaders, String key) {
        try {
            return (T)this.executeAsync((Request)request, (Map)extraHeaders, key).get();
        }
        catch (InterruptedException e) {
            throw new HerokuAPIException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new HerokuAPIException((Throwable)e);
        }
    }

    public void close() {
        this.client.close();
    }

    public Integer getRemainingRateLimit() {
        return this.myRemainingRateLimit;
    }

    private static <T> Future<Response> invoke(Request<T> request, Invocation.Builder builder) {
        if (Http.Method.PATCH.equals((Object)request.getHttpMethod())) {
            AsyncInvoker invoker = builder.async();
            builder.property("X-HTTP-Method-Override", (Object)"PATCH");
            return invoker.method("POST", Entity.json((Object)request.getBodyAsMap()));
        }
        AsyncInvoker invoker = builder.async();
        return request.hasBody() ? invoker.method(request.getHttpMethod().name(), Entity.json((Object)request.getBodyAsMap())) : invoker.method(request.getHttpMethod().name());
    }

    private static ClientConfig createClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        ApacheConnectorProvider connectorProvider = new ApacheConnectorProvider();
        clientConfig.connectorProvider((ConnectorProvider)connectorProvider);
        return clientConfig;
    }

    private static Map<String, String> toJavaMap(MultivaluedMap<String, String> headers) {
        HashMap<String, String> javaMap = new HashMap<String, String>();
        for (String key : headers.keySet()) {
            javaMap.put(key, (String)headers.getFirst((Object)key));
        }
        return javaMap;
    }

    public static class Provider
    implements ConnectionProvider {
        public Connection getConnection() {
            return new JerseyClientAsyncConnection();
        }
    }
}

