/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web.jsr45;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.j2ee.web.jsr45.JSR45RunConfigurationEditor;
import com.intellij.j2ee.web.jsr45.JSR45ServerInstance;
import com.intellij.j2ee.web.jsr45.Jsr45DebugBundle;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.ServerModel;
import com.intellij.javaee.run.execution.DefaultOutputProcessor;
import com.intellij.javaee.run.execution.OutputProcessor;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class JSR45Model
implements ServerModel {
    public String JSP_PACKAGE = "org.apache.jsp";
    public String VM_OPTS = "";
    public boolean USE_WEBSPHERE51_LINEMAPPING_MODEL = false;
    public int LOCAL_PORT = 80;
    private CommonModel myCommonModel;

    public int getDefaultPort() {
        return 80;
    }

    public void setCommonModel(CommonModel commonModel) {
        this.myCommonModel = commonModel;
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new JSR45RunConfigurationEditor(this.myCommonModel.isLocal());
    }

    public J2EEServerInstance createServerInstance() throws ExecutionException {
        try {
            this.checkValid();
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getLocalizedMessage());
        }
        return new JSR45ServerInstance(this.myCommonModel);
    }

    public void checkValid() throws RuntimeConfigurationException {
        if (!this.JSP_PACKAGE.isEmpty()) {
            RuntimeConfigurationError executionException = new RuntimeConfigurationError(Jsr45DebugBundle.message("exception.text.not.valid.java.package.name", this.JSP_PACKAGE));
            if (!Character.isJavaIdentifierStart(this.JSP_PACKAGE.charAt(0))) {
                throw executionException;
            }
            for (int i = 1; i < this.JSP_PACKAGE.length(); ++i) {
                char ch = this.JSP_PACKAGE.charAt(i);
                if (ch == '.' || Character.isJavaIdentifierPart(ch)) continue;
                throw executionException;
            }
        }
        if (this.myCommonModel.isLocal() && this.VM_OPTS != null && this.VM_OPTS.isEmpty()) {
            throw new RuntimeConfigurationException(Jsr45DebugBundle.message("exception.text.not.valid.environment.vartiable.name", this.VM_OPTS));
        }
    }

    public DeploymentProvider getDeploymentProvider() {
        return null;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public int getLocalPort() {
        return this.LOCAL_PORT;
    }

    public void checkConfigurationInt() throws RuntimeConfigurationException {
        this.checkValid();
    }

    public List<Pair<String, Integer>> getAddressesToCheck() {
        ArrayList<Pair<String, Integer>> result = new ArrayList<Pair<String, Integer>>();
        result.add(new Pair((Object)this.myCommonModel.getHost(), (Object)this.myCommonModel.getPort()));
        return result;
    }

    @NotNull
    public String getDefaultUrlForBrowser() {
        String string = "http://" + this.myCommonModel.getHost() + ":" + this.myCommonModel.getPort();
        if (string == null) {
            JSR45Model.$$$reportNull$$$0(0);
        }
        return string;
    }

    public OutputProcessor createOutputProcessor(ProcessHandler j2EEOSProcessHandlerWrapper, J2EEServerInstance serverInstance) {
        return new DefaultOutputProcessor(j2EEOSProcessHandlerWrapper);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
    }

    public JSR45Model clone() throws CloneNotSupportedException {
        return (JSR45Model)super.clone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/web/jsr45/JSR45Model", "getDefaultUrlForBrowser"));
    }
}

