/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.html5;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.dialects.ThymeleafAttributeProcessor;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafDialects;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nullable;

public class ThymeleafAttrDescriptorProvider
implements XmlAttributeDescriptorsProvider {
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag context) {
        return ThymeleafAttrDescriptorProvider.getDescriptors(context);
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        return ThymeleafAttrDescriptorProvider.getDescriptor(attributeName, context);
    }

    public static XmlAttributeDescriptor[] getDescriptors(XmlTag context) {
        HashSet descriptors = new HashSet();
        if (HtmlUtil.isHtml5Context((XmlElement)context)) {
            for (ThymeleafDialect dialect : ThymeleafDialects.getDialects(context.getProject())) {
                String prefixByNamespace;
                if (!dialect.isSupported(context.getProject()) || (prefixByNamespace = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(context, dialect.getNamespaces())) == null) continue;
                for (ThymeleafAttributeProcessor attributeProcessor : dialect.getAttributeProcessors()) {
                    String attributeName = attributeProcessor.getName();
                    if (!StringUtil.isNotEmpty((String)attributeName)) continue;
                    descriptors.add(new AnyXmlAttributeDescriptor(prefixByNamespace + ":" + attributeName));
                    descriptors.add(new AnyXmlAttributeDescriptor("data-" + prefixByNamespace + "-" + attributeName));
                }
            }
        }
        return descriptors.toArray(new XmlAttributeDescriptor[descriptors.size()]);
    }

    public static XmlAttributeDescriptor getDescriptor(String attributeName, XmlTag context) {
        String prefixByQualifiedName = XmlUtil.findPrefixByQualifiedName((String)attributeName);
        if (prefixByQualifiedName.length() != 0 && ThymeleafCommonUtil.isThymeleafPrefix(context, prefixByQualifiedName)) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        return null;
    }
}

