/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.psi.impl;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesQuickFixFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.PropertiesPsiCompletionUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafPsiCompositeElementImpl;
import com.intellij.thymeleaf.lang.support.ThymeleafBundleProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import gnu.trove.THashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ThymeleafMessageReferenceImpl
extends ThymeleafPsiCompositeElementImpl {
    public ThymeleafMessageReferenceImpl(@NotNull ASTNode node) {
        if (node == null) {
            ThymeleafMessageReferenceImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public PsiReference getReference() {
        return new PropertyReference(this.getText(), this, null, false){

            @Nullable
            protected List<PropertiesFile> getPropertiesFiles() {
                HashSet files = ContainerUtil.newHashSet();
                for (ThymeleafBundleProvider provider : (ThymeleafBundleProvider[])Extensions.getExtensions(ThymeleafBundleProvider.EP_NAME)) {
                    files.addAll(provider.getPropertiesFile(ThymeleafMessageReferenceImpl.this));
                }
                return ContainerUtil.newArrayList((Iterable)files);
            }

            @NotNull
            public Object[] getVariants() {
                THashSet allVariants = new THashSet();
                List<PropertiesFile> files = this.getPropertiesFiles();
                if (files != null) {
                    for (PropertiesFile propertiesFile : files) {
                        PropertiesPsiCompletionUtil.addVariantsFromFile((PropertyReferenceBase)this, (PropertiesFile)propertiesFile, (Set)allVariants);
                    }
                }
                HashMap filtered = new HashMap();
                for (Object variant : allVariants) {
                    IProperty property;
                    String propertyKey;
                    if (variant instanceof String) {
                        filtered.put((String)variant, LookupElementBuilder.create((String)((String)variant)).withIcon(PlatformIcons.PROPERTY_ICON));
                    }
                    if (!(variant instanceof IProperty) || (propertyKey = (property = (IProperty)variant).getKey()) == null) continue;
                    filtered.put(propertyKey, LookupElementBuilder.create((String)propertyKey).withIcon(PlatformIcons.PROPERTY_ICON));
                }
                Object[] objectArray = ArrayUtil.toObjectArray(filtered.values());
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            public LocalQuickFix[] getQuickFixes() {
                return new LocalQuickFix[]{PropertiesQuickFixFactory.getInstance().createCreatePropertyFix(this.myElement, this.myKey, this.getPropertiesFiles())};
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return super.handleElementRename(newElementName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafMessageReferenceImpl$1", "getVariants"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafMessageReferenceImpl", "<init>"));
    }
}

