/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.references.paths.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.thymeleaf.references.paths.ThymeleafViewResolverHelper;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ThymeleafSpringTemplateResolverHelper
extends ThymeleafViewResolverHelper {
    @Override
    @NotNull
    public Set<String> getTemplateResolverPrefixes(@NotNull Module module) {
        PsiClass templateResolverClass;
        if (module == null) {
            ThymeleafSpringTemplateResolverHelper.$$$reportNull$$$0(0);
        }
        if ((templateResolverClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.thymeleaf.templateresolver.TemplateResolver")) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                ThymeleafSpringTemplateResolverHelper.$$$reportNull$$$0(1);
            }
            return set;
        }
        HashSet strings = new HashSet();
        SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)templateResolverClass).withInheritors();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        for (SpringBeanPointer configurer : configurers) {
            String prefix = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)configurer.getSpringBean(), (String)"prefix");
            if (!StringUtil.isNotEmpty((String)prefix)) continue;
            strings.add(prefix);
        }
        HashSet hashSet = strings;
        if (hashSet == null) {
            ThymeleafSpringTemplateResolverHelper.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/references/paths/spring/ThymeleafSpringTemplateResolverHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/references/paths/spring/ThymeleafSpringTemplateResolverHelper";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateResolverPrefixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateResolverPrefixes";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

