/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.caching.internal.BuildCacheHasher;

public class ListValueSnapshot
implements ValueSnapshot {
    public static final ValueSnapshot EMPTY = new ListValueSnapshot(new ValueSnapshot[0]);
    private final ValueSnapshot[] elements;

    public ListValueSnapshot(ValueSnapshot[] elements) {
        this.elements = elements;
    }

    public ValueSnapshot[] getElements() {
        return this.elements;
    }

    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString("List");
        hasher.putInt(this.elements.length);
        for (ValueSnapshot element : this.elements) {
            element.appendToHasher(hasher);
        }
    }

    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot element;
        int pos;
        if (!(value instanceof List)) {
            return snapshotter.snapshot(value);
        }
        List list = (List)value;
        int len = Math.min(this.elements.length, list.size());
        ValueSnapshot newElement = null;
        for (pos = 0; pos < len && (element = this.elements[pos]) == (newElement = snapshotter.snapshot(list.get(pos), element)); ++pos) {
        }
        if (pos == this.elements.length && pos == list.size()) {
            return this;
        }
        ValueSnapshot[] newElements = new ValueSnapshot[list.size()];
        System.arraycopy(this.elements, 0, newElements, 0, pos);
        if (pos < list.size()) {
            newElements[pos] = newElement;
            for (int i = pos + 1; i < list.size(); ++i) {
                newElements[i] = snapshotter.snapshot(list.get(i));
            }
        }
        return new ListValueSnapshot(newElements);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ListValueSnapshot other = (ListValueSnapshot)obj;
        return Arrays.equals(this.elements, other.elements);
    }

    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }
}

