/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.Annotation;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.LineAnnotation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.UtilKt;
import gnu.trove.THashMap;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0010J \u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012J\u001b\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\u0002J\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001fJ\u0006\u0010 \u001a\u00020\u0015R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/javascript/debugger/LineAnnotationMaps;", "", "()V", "consoleAnnotations", "Ljava/util/ArrayList;", "Lcom/intellij/javascript/debugger/LineAnnotation;", "consoleLineToIndexCache", "Lgnu/trove/TIntIntHashMap;", "consoleOffsets", "Lcom/intellij/util/containers/IntArrayList;", "fileToAnnotations", "Lgnu/trove/THashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lcom/intellij/javascript/debugger/Annotation;", "add", "", "consoleOffset", "", "annotation", "addToFileMap", "", "clear", "find", "file", "line", "column", "get", "editor", "Lcom/intellij/openapi/editor/Editor;", "getLast", "Lkotlin/Pair;", "isEmpty", "JavaScriptDebugger"})
public final class LineAnnotationMaps {
    private final IntArrayList consoleOffsets = new IntArrayList();
    private final ArrayList<LineAnnotation> consoleAnnotations = new ArrayList();
    private final TIntIntHashMap consoleLineToIndexCache = new TIntIntHashMap();
    private final THashMap<VirtualFile, List<Annotation>> fileToAnnotations = new THashMap();

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Annotation find(@NotNull VirtualFile file, int line, int column) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        List list = (List)this.fileToAnnotations.get((Object)file);
        if (list != null) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            List list2;
            List it = list2 = list;
            Iterable iterable = (Iterable)RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)it)));
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void i;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                Annotation annotation = (Annotation)it.get((int)i);
                collection.add(annotation);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                Annotation it2 = (Annotation)element$iv$iv;
                if (!(it2.getLine() == line && it2.getColumn() == column)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            iterator = $receiver$iv.iterator();
            if (iterator.hasNext()) {
                Object element$iv = iterator.next();
                Annotation it3 = (Annotation)element$iv;
                return it3;
            }
        }
        return null;
    }

    public final void add(int consoleOffset, @NotNull LineAnnotation annotation, boolean addToFileMap) {
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Integer lastConsoleOffset = this.consoleOffsets.isEmpty() ? null : Integer.valueOf(this.consoleOffsets.get(this.consoleOffsets.size() - 1));
        JavaScriptDebugProcessKt.getLOG().assertTrue(lastConsoleOffset == null || Intrinsics.compare((int)consoleOffset, (int)lastConsoleOffset) >= 0);
        this.consoleOffsets.add(consoleOffset);
        this.consoleAnnotations.add(annotation);
        if (addToFileMap && annotation.getAnno().getPosition() != null) {
            UtilKt.putValue((Map)((Map)this.fileToAnnotations), (Object)annotation.getAnno().getFile(), (Object)annotation.getAnno());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        this.consoleOffsets.clear();
        this.consoleAnnotations.clear();
        this.fileToAnnotations.clear();
        TIntIntHashMap tIntIntHashMap = this.consoleLineToIndexCache;
        synchronized (tIntIntHashMap) {
            this.consoleLineToIndexCache.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isEmpty() {
        return this.consoleOffsets.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final LineAnnotation get(int line, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        TIntIntHashMap tIntIntHashMap = this.consoleLineToIndexCache;
        synchronized (tIntIntHashMap) {
            block10: {
                try {
                    int initialConsoleLineCacheSize;
                    int n = initialConsoleLineCacheSize = this.consoleLineToIndexCache.size();
                    int n2 = this.consoleOffsets.size() - 1;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            this.consoleLineToIndexCache.put(document.getLineNumber(this.consoleOffsets.get((int)i)), (int)i);
                            if (i != n2) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    LineAnnotation lineAnnotation = null;
                    return lineAnnotation;
                }
                if (this.consoleLineToIndexCache.containsKey(line)) break block10;
                LineAnnotation lineAnnotation = null;
                return lineAnnotation;
            }
            LineAnnotation lineAnnotation = this.consoleAnnotations.get(this.consoleLineToIndexCache.get(line));
            return lineAnnotation;
        }
    }

    @Nullable
    public final Pair<Integer, LineAnnotation> getLast() {
        return this.consoleAnnotations.isEmpty() ? null : new Pair((Object)this.consoleOffsets.get(this.consoleOffsets.size() - 1), CollectionsKt.last((List)this.consoleAnnotations));
    }
}

