/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.breakpoints.JavaScriptBreakpointType;
import com.intellij.javascript.debugger.breakpoints.JavaScriptLineBreakpointProperties;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

final class JavaScriptBreakpointListener
implements StartupActivity,
DumbAware {
    JavaScriptBreakpointListener() {
    }

    public void runActivity(final @NotNull Project project) {
        JavaScriptBreakpointType breakpointType;
        if (project == null) {
            JavaScriptBreakpointListener.$$$reportNull$$$0(0);
        }
        if ((breakpointType = (JavaScriptBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(JavaScriptBreakpointType.class))) == null) {
            return;
        }
        XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpointListener((XBreakpointType)breakpointType, (XBreakpointListener)new XBreakpointListener<XLineBreakpoint<JavaScriptLineBreakpointProperties>>(){

            public void breakpointAdded(@NotNull XLineBreakpoint breakpoint) {
                if (breakpoint == null) {
                    1.$$$reportNull$$$0(0);
                }
                JavaScriptBreakpointListener.checkBreakpoint(breakpoint, project);
            }

            public void breakpointChanged(@NotNull XLineBreakpoint breakpoint) {
                if (breakpoint == null) {
                    1.$$$reportNull$$$0(1);
                }
                JavaScriptBreakpointListener.checkBreakpoint(breakpoint, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "breakpoint";
                objectArray2[1] = "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointListener$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)project);
    }

    private static void checkBreakpoint(@NotNull XLineBreakpoint breakpoint, @NotNull Project project) {
        String errorMessage;
        XSourcePosition sourcePosition2;
        if (breakpoint == null) {
            JavaScriptBreakpointListener.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JavaScriptBreakpointListener.$$$reportNull$$$0(2);
        }
        if ((sourcePosition2 = breakpoint.getSourcePosition()) == null) {
            return;
        }
        VirtualFile file = sourcePosition2.getFile();
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        FileType fileType = file.getFileType();
        if ((fileType == JavaScriptFileType.INSTANCE || HtmlUtil.isHtmlFile((VirtualFile)file)) && JsFileUtil.containsDebuggableElement(breakpoint.getLine(), project, FileDocumentManager.getInstance().getDocument(file), true, true)) {
            errorMessage = JSDebuggerBundle.message("error.message.breakpoints.in.event.handlers.are.not.supported", new Object[0]);
        } else if (JsFileUtil.isTemplateFileType(fileType)) {
            errorMessage = JSDebuggerBundle.message("error.message.breakpoint.in.0.files.are.not.supported", fileType.getName(), ApplicationNamesInfo.getInstance().getFullProductName());
        } else {
            breakpointManager.updateBreakpointPresentation(breakpoint, null, null);
            return;
        }
        breakpointManager.updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/debugger/breakpoints/JavaScriptBreakpointListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

