/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;

public class PostgresHelper {
    public static Object convertValue(@NotNull String className, @NotNull Object o) {
        if (className == null) {
            PostgresHelper.$$$reportNull$$$0(0);
        }
        if (o == null) {
            PostgresHelper.$$$reportNull$$$0(1);
        }
        if (ArrayUtil.contains((String)className, (String[])new String[]{"org.postgresql.jdbc4.Jdbc4SQLXML", "org.postgresql.jdbc.PgSQLXML"})) {
            return JdbcNativeUtil.tryGetString(o);
        }
        return null;
    }

    public static void setNative(@NotNull String value, @NotNull String typeName, @NotNull RemotePreparedStatement statement, int idx) throws Exception {
        if (value == null) {
            PostgresHelper.$$$reportNull$$$0(2);
        }
        if (typeName == null) {
            PostgresHelper.$$$reportNull$$$0(3);
        }
        if (statement == null) {
            PostgresHelper.$$$reportNull$$$0(4);
        }
        try {
            Class<?> aClass = Class.forName("org.postgresql.util.PGobject");
            Object pgObject = aClass.newInstance();
            ReflectionHelper.tryInvokeMethod(pgObject, "setType", (Class[])ContainerUtil.ar((Object[])new Class[]{String.class}), ContainerUtil.ar((Object[])new String[]{typeName}));
            ReflectionHelper.tryInvokeMethod(pgObject, "setValue", (Class[])ContainerUtil.ar((Object[])new Class[]{String.class}), ContainerUtil.ar((Object[])new String[]{value}));
            statement.setObject(idx, pgObject);
        }
        catch (Exception e) {
            statement.setObject(idx, value);
        }
    }

    public static boolean shouldSetNative(@NotNull Rdbms rdbms, @NotNull String typeName) {
        if (rdbms == null) {
            PostgresHelper.$$$reportNull$$$0(5);
        }
        if (typeName == null) {
            PostgresHelper.$$$reportNull$$$0(6);
        }
        return PostgresHelper.isPgJson(rdbms, typeName) || PostgresHelper.isPgHStore(rdbms, typeName);
    }

    public static boolean isPgJson(@NotNull Rdbms rdbms, @NotNull String typeName) {
        if (rdbms == null) {
            PostgresHelper.$$$reportNull$$$0(7);
        }
        if (typeName == null) {
            PostgresHelper.$$$reportNull$$$0(8);
        }
        return rdbms == Postgres.RDBMS && StringUtil.findIgnoreCase((String)typeName, (String[])new String[]{"json", "jsonb"});
    }

    public static boolean isPgBitColumn(@NotNull Rdbms rdbms, @NotNull String name) {
        if (rdbms == null) {
            PostgresHelper.$$$reportNull$$$0(9);
        }
        if (name == null) {
            PostgresHelper.$$$reportNull$$$0(10);
        }
        return rdbms == Postgres.RDBMS && StringUtil.findIgnoreCase((String)name, (String[])new String[]{"varbit", "bit"});
    }

    private static boolean isPgHStore(@NotNull Rdbms rdbms, @NotNull String typeName) {
        if (rdbms == null) {
            PostgresHelper.$$$reportNull$$$0(11);
        }
        if (typeName == null) {
            PostgresHelper.$$$reportNull$$$0(12);
        }
        return rdbms == Postgres.RDBMS && StringUtil.equalsIgnoreCase((CharSequence)typeName, (CharSequence)"hstore");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdbms";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/impl/PostgresHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convertValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setNative";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSetNative";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isPgJson";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isPgBitColumn";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isPgHStore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

