/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.RemoteConnectionImpl;
import com.intellij.database.remote.jdbc.impl.SerializableDriverPropertyInfo;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class RemoteDriverImpl
extends JdbcRemoteObject
implements RemoteDriver {
    private final Driver myDelegate;

    protected RemoteDriverImpl(Driver delegate) {
        this.myDelegate = delegate;
    }

    public static RemoteDriverImpl wrap(Driver delegate) {
        return delegate == null ? null : new RemoteDriverImpl(delegate);
    }

    public String getCastToClassName() {
        return Driver.class.getName();
    }

    @Override
    public RemoteConnection connect(String p1, Properties p2) throws RemoteException, SQLException {
        try {
            return (RemoteConnection)((Object)this.export((Remote)((Object)RemoteConnectionImpl.wrap(this.myDelegate.connect(p1, p2)))));
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public boolean acceptsURL(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.acceptsURL(p1);
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public int getMajorVersion() throws RemoteException {
        try {
            return this.myDelegate.getMajorVersion();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public int getMinorVersion() throws RemoteException {
        try {
            return this.myDelegate.getMinorVersion();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String p1, Properties p2) throws RemoteException, SQLException {
        try {
            DriverPropertyInfo[] value = this.myDelegate.getPropertyInfo(p1, p2);
            DriverPropertyInfo[] result = new DriverPropertyInfo[value == null ? 0 : value.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new SerializableDriverPropertyInfo(value[i]);
            }
            return result;
        }
        catch (Exception e) {
            this.rethrowException(e);
            throw new AssertionError();
        }
    }

    @Override
    public boolean jdbcCompliant() throws RemoteException {
        try {
            return this.myDelegate.jdbcCompliant();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    public void unreferenced() {
        System.exit(0);
    }
}

