/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteArray;
import com.intellij.database.remote.jdbc.RemoteBlob;
import com.intellij.database.remote.jdbc.RemoteClob;
import com.intellij.database.remote.jdbc.RemoteRef;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteResultSetMetaData;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.OracleHelper;
import com.intellij.database.remote.jdbc.impl.RemoteArrayImpl;
import com.intellij.database.remote.jdbc.impl.RemoteBlobImpl;
import com.intellij.database.remote.jdbc.impl.RemoteClobImpl;
import com.intellij.database.remote.jdbc.impl.RemoteRefImpl;
import com.intellij.database.remote.jdbc.impl.RemoteResultSetMetaDataImpl;
import com.intellij.database.remote.jdbc.impl.RemoteStatementImpl;
import com.intellij.database.remote.jdbc.impl.ZonedValue;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sqlite;

public class RemoteResultSetImpl
extends JdbcRemoteObject
implements RemoteResultSet,
com.intellij.openapi.util.Getter<Connection> {
    private final ResultSet myDelegate;
    private final List<WeakReference<RemoteObject>> myExportedResults = ContainerUtil.createLockFreeCopyOnWriteList();

    protected RemoteResultSetImpl(ResultSet delegate) {
        this.myDelegate = delegate;
    }

    public static RemoteResultSetImpl wrap(ResultSet delegate) {
        return delegate == null ? null : new RemoteResultSetImpl(delegate);
    }

    private void dropExportedResults() throws RemoteException {
        this.unexportChildren(this.myExportedResults);
        this.myExportedResults.clear();
    }

    public <T extends Remote> T export2(T child) throws RemoteException {
        if (child == null) {
            return null;
        }
        this.myExportedResults.add(((JdbcRemoteObject)((Object)child)).getWeakRef());
        return (T)super.export(child);
    }

    public synchronized void unexportChildren() throws RemoteException {
        this.myExportedResults.clear();
        super.unexportChildren();
    }

    public String getCastToClassName() {
        return ResultSet.class.getName();
    }

    public Connection get() {
        try {
            return this.myDelegate.getStatement().getConnection();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getObject(int p1) throws RemoteException, SQLException {
        try {
            return this.wrapIfNeeded(this.myDelegate.getObject(p1), this);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Object getObject(String p1) throws RemoteException, SQLException {
        try {
            return this.wrapIfNeeded(this.myDelegate.getObject(p1), this);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Object getObject(String p1, Map<String, Class<?>> p2) throws RemoteException, SQLException {
        try {
            return this.wrapIfNeeded(this.myDelegate.getObject(p1, p2), this);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Object getObject(int p1, Map<String, Class<?>> p2) throws RemoteException, SQLException {
        try {
            return this.wrapIfNeeded(this.myDelegate.getObject(p1, p2), this);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean getBoolean(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBoolean(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean getBoolean(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBoolean(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public byte getByte(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getByte(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public byte getByte(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getByte(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public short getShort(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getShort(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public short getShort(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getShort(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getInt(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getInt(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getInt(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getInt(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public long getLong(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getLong(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public long getLong(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getLong(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public float getFloat(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getFloat(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public float getFloat(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getFloat(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public double getDouble(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDouble(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public double getDouble(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDouble(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public byte[] getBytes(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBytes(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public byte[] getBytes(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBytes(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteArray getArray(int p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteArrayImpl.wrap(this.myDelegate.getArray(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteArray getArray(String p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteArrayImpl.wrap(this.myDelegate.getArray(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean next() throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            return this.myDelegate.next();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getType() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getType();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean previous() throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            return this.myDelegate.previous();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isClosed() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isClosed();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void close() throws RemoteException, SQLException {
        try {
            this.unexportChildren();
            this.myDelegate.close();
            this.unreferenced();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteRef getRef(int p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteRefImpl.wrap(this.myDelegate.getRef(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteRef getRef(String p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteRefImpl.wrap(this.myDelegate.getRef(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Date getDate(String p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDate(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Date getDate(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDate(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Date getDate(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDate(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Date getDate(int p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getDate(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Time getTime(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTime(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Time getTime(String p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTime(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Time getTime(int p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTime(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Time getTime(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTime(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean first() throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            return this.myDelegate.first();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean last() throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            return this.myDelegate.last();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTimestamp(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTimestamp(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTimestamp(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String p1, Calendar p2) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getTimestamp(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getString(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getString(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getString(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getString(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws RemoteException, SQLException {
        try {
            return this.wrapSqlWarning(this.myDelegate.getWarnings());
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public List<SQLWarning> getAllWarnings() throws RemoteException, SQLException {
        try {
            List<SQLWarning> warnings = this.getAllWarnings(this.myDelegate.getWarnings());
            this.myDelegate.clearWarnings();
            return warnings;
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean absolute(int p1) throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            return this.myDelegate.absolute(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void afterLast() throws RemoteException, SQLException {
        try {
            this.myDelegate.afterLast();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void beforeFirst() throws RemoteException, SQLException {
        try {
            this.myDelegate.beforeFirst();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void cancelRowUpdates() throws RemoteException, SQLException {
        try {
            this.myDelegate.cancelRowUpdates();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void clearWarnings() throws RemoteException, SQLException {
        try {
            this.myDelegate.clearWarnings();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void deleteRow() throws RemoteException, SQLException {
        try {
            this.dropExportedResults();
            this.myDelegate.deleteRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int findColumn(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.findColumn(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBigDecimal(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.getBigDecimal(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteBlob getBlob(int p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteBlobImpl.wrap(this.myDelegate.getBlob(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteBlob getBlob(String p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteBlobImpl.wrap(this.myDelegate.getBlob(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteClob getClob(int p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteClobImpl.wrap(this.myDelegate.getClob(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteClob getClob(String p1) throws RemoteException, SQLException {
        try {
            return this.export2(RemoteClobImpl.wrap(this.myDelegate.getClob(p1)));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getConcurrency() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getConcurrency();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public String getCursorName() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getCursorName();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getFetchDirection() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getFetchDirection();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getFetchSize() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getFetchSize();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteResultSetMetaData getMetaData() throws RemoteException, SQLException {
        try {
            return (RemoteResultSetMetaData)((Object)this.export((Remote)((Object)RemoteResultSetMetaDataImpl.wrap(this.myDelegate.getMetaData()))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int getRow() throws RemoteException, SQLException {
        try {
            return this.myDelegate.getRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public RemoteStatement getStatement() throws RemoteException, SQLException {
        try {
            return (RemoteStatement)((Object)this.export((Remote)((Object)RemoteStatementImpl.wrap(this.myDelegate.getStatement()))));
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void insertRow() throws RemoteException, SQLException {
        try {
            this.myDelegate.insertRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isAfterLast() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isAfterLast();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isBeforeFirst() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isBeforeFirst();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isFirst() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isFirst();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean isLast() throws RemoteException, SQLException {
        try {
            return this.myDelegate.isLast();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void moveToCurrentRow() throws RemoteException, SQLException {
        try {
            this.myDelegate.moveToCurrentRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void moveToInsertRow() throws RemoteException, SQLException {
        try {
            this.myDelegate.moveToInsertRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void refreshRow() throws RemoteException, SQLException {
        try {
            this.myDelegate.refreshRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean relative(int p1) throws RemoteException, SQLException {
        try {
            return this.myDelegate.relative(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean rowDeleted() throws RemoteException, SQLException {
        try {
            return this.myDelegate.rowDeleted();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean rowInserted() throws RemoteException, SQLException {
        try {
            return this.myDelegate.rowInserted();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean rowUpdated() throws RemoteException, SQLException {
        try {
            return this.myDelegate.rowUpdated();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setFetchDirection(int p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.setFetchDirection(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void setFetchSize(int p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.setFetchSize(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateArray(String p1, Array p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateArray(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateArray(int p1, Array p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateArray(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBigDecimal(String p1, BigDecimal p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBigDecimal(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBigDecimal(int p1, BigDecimal p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBigDecimal(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBlob(int p1, Blob p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBlob(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBlob(String p1, Blob p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBlob(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBoolean(String p1, boolean p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBoolean(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBoolean(int p1, boolean p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBoolean(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateByte(int p1, byte p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateByte(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateByte(String p1, byte p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateByte(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBytes(String p1, byte[] p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBytes(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateBytes(int p1, byte[] p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateBytes(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateClob(String p1, Clob p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateClob(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateClob(int p1, Clob p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateClob(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateDate(int p1, Date p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateDate(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateDate(String p1, Date p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateDate(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateDouble(int p1, double p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateDouble(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateDouble(String p1, double p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateDouble(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateFloat(int p1, float p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateFloat(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateFloat(String p1, float p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateFloat(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateInt(int p1, int p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateInt(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateInt(String p1, int p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateInt(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateLong(String p1, long p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateLong(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateLong(int p1, long p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateLong(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateNull(int p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateNull(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateNull(String p1) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateNull(p1);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateObject(String p1, Object p2, int p3) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateObject(p1, p2, p3);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateObject(String p1, Object p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateObject(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateObject(int p1, Object p2, int p3) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateObject(p1, p2, p3);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateObject(int p1, Object p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateObject(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateRef(String p1, Ref p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateRef(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateRef(int p1, Ref p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateRef(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateRow() throws RemoteException, SQLException {
        try {
            this.myDelegate.updateRow();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateShort(String p1, short p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateShort(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateShort(int p1, short p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateShort(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateString(int p1, String p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateString(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateString(String p1, String p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateString(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateTime(int p1, Time p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateTime(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateTime(String p1, Time p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateTime(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateTimestamp(String p1, Timestamp p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateTimestamp(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public void updateTimestamp(int p1, Timestamp p2) throws RemoteException, SQLException {
        try {
            this.myDelegate.updateTimestamp(p1, p2);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public boolean wasNull() throws RemoteException, SQLException {
        try {
            return this.myDelegate.wasNull();
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    @Override
    public int scrollToPosition(int curRowNum, int position) throws RemoteException, SQLException {
        try {
            return this.doScroll(curRowNum, position);
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    private int doScroll(int rowNum, int position) throws SQLException {
        switch (this.myDelegate.getType()) {
            case 1003: {
                while (rowNum < position && this.myDelegate.next()) {
                    ++rowNum;
                }
                break;
            }
            default: {
                int actualRowNum = this.myDelegate.getRow();
                if (rowNum != actualRowNum) {
                    throw new IllegalArgumentException("Supplied current row number: " + rowNum + ". Actual: " + actualRowNum + ".\nDelegate class: " + this.myDelegate.getClass().getName());
                }
                if (position < rowNum && this.myDelegate.getClass().getName().startsWith("com.sybase")) {
                    return rowNum;
                }
                if (!this.myDelegate.absolute(position)) break;
                rowNum = this.myDelegate.getRow();
            }
        }
        return rowNum;
    }

    @Override
    public List<Object[]> getObjects(@NotNull RemoteResultSet.DataRetrievingOptions options) throws RemoteException, SQLException {
        if (options == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(0);
        }
        try {
            this.dropExportedResults();
            ResultSetMetaData metaData = this.myDelegate.getMetaData();
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            int count = 0;
            while (count++ < options.rowCount && this.myDelegate.next()) {
                result.add(this.getCurrentRow(options, this.myDelegate, metaData));
            }
            return result;
        }
        catch (Exception e) {
            throw this.rethrowException(e);
        }
    }

    private Object[] getCurrentRow(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData) throws SQLException {
        if (options == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(1);
        }
        if (resultSet == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(2);
        }
        if (metaData == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(3);
        }
        int columnCount = metaData.getColumnCount();
        Object[] objects = new Object[columnCount];
        Set<Integer> longs = RemoteResultSetImpl.findOracleLongs(options.rdbms, metaData, columnCount);
        for (Integer i : longs) {
            objects[i.intValue() - 1] = this.getObject(options, resultSet, metaData, i);
        }
        for (int i = 1; i <= columnCount; ++i) {
            if (longs.contains(i)) continue;
            objects[i - 1] = this.getObject(options, resultSet, metaData, i);
        }
        return objects;
    }

    private static Set<Integer> findOracleLongs(@NotNull Rdbms rdbms, @NotNull ResultSetMetaData metaData, int columnCount) throws SQLException {
        if (rdbms == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(4);
        }
        if (metaData == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(5);
        }
        if (rdbms != Oracle.RDBMS) {
            return ContainerUtilRt.newHashSet();
        }
        HashSet result = ContainerUtilRt.newHashSet();
        for (int i = 1; i <= columnCount; ++i) {
            if (metaData.getColumnType(i) != -1) continue;
            result.add(i);
        }
        return result;
    }

    private Object getObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int index) {
        if (options == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(6);
        }
        if (resultSet == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(7);
        }
        if (metaData == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(8);
        }
        try {
            int type = metaData.getColumnType(index);
            String clazz = metaData.getColumnClassName(index);
            String typeName = metaData.getColumnTypeName(index);
            int trueType = JdbcNativeUtil.fixJdbcType(options.rdbms, typeName, clazz, type);
            return this.createInfoIfNeeded(options, RemoteResultSetImpl.tryGetObject(options, resultSet, metaData, trueType, index));
        }
        catch (Throwable e) {
            return "<failed to load>\n" + ExceptionUtil.getThrowableText((Throwable)e, (String)"com.intellij.");
        }
    }

    private static Object tryGetObject(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData, int jdbcType, int index) throws SQLException {
        int precision;
        String typeName;
        if (options == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(9);
        }
        if (resultSet == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(10);
        }
        if (metaData == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(11);
        }
        if (jdbcType == 2004 || jdbcType == 2005) {
            return RemoteResultSetImpl.getBlobOrClob(resultSet, index, jdbcType == 2004);
        }
        boolean isPostgres = options.rdbms == Postgres.RDBMS;
        if (RemoteResultSetImpl.isDriverFailsOnType(jdbcType, isPostgres, typeName = metaData.getColumnTypeName(index))) {
            return resultSet.getString(index);
        }
        if (JdbcNativeUtil.isZonedColumn(typeName, options.rdbms) && !options.raw) {
            String timestamp = resultSet.getString(index);
            return timestamp != null ? new ZonedValue(options.rdbms == Oracle.RDBMS ? OracleHelper.normalizeTimestamp(timestamp, resultSet.getTimestamp(index)) : timestamp) : null;
        }
        Getter getter = Getter.of(options.rdbms, jdbcType);
        if (getter != null) {
            try {
                return getter.get(resultSet, options, index);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean isBit = StringUtil.equalsIgnoreCase((CharSequence)"bit", (CharSequence)typeName);
        boolean isMysql = options.rdbms == Mysql.RDBMS;
        boolean isHsql = StringUtil.equalsIgnoreCase((CharSequence)options.rdbms.code, (CharSequence)"hsqldb");
        if (isBit && (isHsql || isMysql) && !options.raw && (precision = metaData.getPrecision(index)) > 1) {
            byte[] bytes = resultSet.getBytes(index);
            return isMysql ? BitString.of(bytes) : BitString.of(bytes, precision);
        }
        return resultSet.getObject(index);
    }

    private static boolean isDriverFailsOnType(int jdbcType, boolean isPostgres, String typeName) {
        boolean isBitOrMoney = StringUtil.findIgnoreCase((String)typeName, (String[])new String[]{"_money", "money", "bit"});
        return jdbcType == 12 || jdbcType == 1 || jdbcType == -9 || jdbcType == -15 || isPostgres && isBitOrMoney;
    }

    private static Object getBlobOrClob(ResultSet resultSet, int index, boolean isBlob) throws SQLException {
        try {
            return isBlob ? resultSet.getBlob(index) : resultSet.getClob(index);
        }
        catch (SQLException e) {
            return resultSet.getObject(index);
        }
    }

    private Object createInfoIfNeeded(@NotNull RemoteResultSet.DataRetrievingOptions options, Object o) throws Exception {
        if (options == null) {
            RemoteResultSetImpl.$$$reportNull$$$0(12);
        }
        if (!options.raw) {
            if (o instanceof String) {
                return LobInfo.fromString((String)o, options.maxLobLength);
            }
            if (o instanceof byte[]) {
                return LobInfo.fromByteArray((byte[])o, options.maxLobLength);
            }
            if (o instanceof Blob) {
                return LobInfo.fromBlob((Blob)o, options.maxLobLength);
            }
            if (o instanceof Clob) {
                return LobInfo.fromClob((Clob)o, options.maxLobLength);
            }
            if (o instanceof InputStream) {
                return LobInfo.fromInputStream((InputStream)o, options.maxLobLength);
            }
            if (o instanceof Reader) {
                return LobInfo.fromReader((Reader)o, options.maxLobLength);
            }
        }
        return this.wrapIfNeeded(o, this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdbms";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/impl/RemoteResultSetImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getObjects";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentRow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findOracleLongs";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getObject";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "tryGetObject";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createInfoIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Getter {
        LENIENT(Sqlite.RDBMS, new int[]{93, 91}){

            @Override
            @Nullable
            Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    1.$$$reportNull$$$0(1);
                }
                return set.getObject(idx);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/remote/jdbc/impl/RemoteResultSetImpl$Getter$1";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        TIME(new int[]{92}){

            @Override
            @Nullable
            Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
                if (set == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    2.$$$reportNull$$$0(1);
                }
                return set.getTime(idx, JdbcNativeUtil.getUtcCalendar());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/remote/jdbc/impl/RemoteResultSetImpl$Getter$2";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        TIMESTAMP(new int[]{93}){

            @Override
            @Nullable
            Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
                if (set == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    3.$$$reportNull$$$0(1);
                }
                return set.getTimestamp(idx, JdbcNativeUtil.getUtcCalendar());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/remote/jdbc/impl/RemoteResultSetImpl$Getter$3";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        DATE(new int[]{91}){

            @Override
            @Nullable
            Object get(@NotNull ResultSet set, @NotNull RemoteResultSet.DataRetrievingOptions options, int idx) throws SQLException {
                if (set == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (options == null) {
                    4.$$$reportNull$$$0(1);
                }
                return set.getDate(idx, options.clientCalendar);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "set";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "options";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/remote/jdbc/impl/RemoteResultSetImpl$Getter$4";
                objectArray[2] = "get";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        private final Rdbms myRdbms;
        private final int[] myTypes;

        private Getter(int ... type) {
            this(null, type);
        }

        private Getter(Rdbms rdbms, int ... type) {
            this.myRdbms = rdbms;
            this.myTypes = type;
        }

        boolean isSuitable(@NotNull Rdbms rdbms, int type) {
            if (rdbms == null) {
                Getter.$$$reportNull$$$0(0);
            }
            return (this.myRdbms == null || rdbms == this.myRdbms) && ArrayUtil.find((int[])this.myTypes, (int)type) != -1;
        }

        @Nullable
        abstract Object get(@NotNull ResultSet var1, @NotNull RemoteResultSet.DataRetrievingOptions var2, int var3) throws SQLException;

        @Nullable
        static Getter of(@NotNull Rdbms rdbms, int type) {
            if (rdbms == null) {
                Getter.$$$reportNull$$$0(1);
            }
            for (Getter getter : Getter.values()) {
                if (!getter.isSuitable(rdbms, type)) continue;
                return getter;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "rdbms";
            objectArray2[1] = "com/intellij/database/remote/jdbc/impl/RemoteResultSetImpl$Getter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuitable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "of";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

