/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.ComponentPrinter;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.format.Formatting;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.NewHierarchy;
import org.fest.swing.hierarchy.SingleComponentHierarchy;
import org.fest.util.Preconditions;

public final class BasicComponentPrinter
implements ComponentPrinter {
    private static final String INDENTATION = "  ";
    private static final ComponentMatcher ALWAYS_MATCHES = BasicComponentPrinter.alwaysMatches();
    private final ComponentHierarchy hierarchy;

    @Nonnull
    private static ComponentMatcher alwaysMatches() {
        ComponentMatcher componentMatcher = new ComponentMatcher(){

            @Override
            public boolean matches(@Nullable Component c) {
                return true;
            }
        };
        if (componentMatcher == null) {
            BasicComponentPrinter.$$$reportNull$$$0(0);
        }
        return componentMatcher;
    }

    @Nonnull
    public static ComponentPrinter printerWithNewAwtHierarchy() {
        BasicComponentPrinter basicComponentPrinter = new BasicComponentPrinter(NewHierarchy.ignoreExistingComponents());
        if (basicComponentPrinter == null) {
            BasicComponentPrinter.$$$reportNull$$$0(1);
        }
        return basicComponentPrinter;
    }

    @Nonnull
    public static ComponentPrinter printerWithCurrentAwtHierarchy() {
        BasicComponentPrinter basicComponentPrinter = new BasicComponentPrinter(new ExistingHierarchy());
        if (basicComponentPrinter == null) {
            BasicComponentPrinter.$$$reportNull$$$0(2);
        }
        return basicComponentPrinter;
    }

    protected BasicComponentPrinter(@Nonnull ComponentHierarchy hierarchy) {
        if (hierarchy == null) {
            BasicComponentPrinter.$$$reportNull$$$0(3);
        }
        this.hierarchy = hierarchy;
    }

    @Nonnull
    protected final ComponentHierarchy hierarchy() {
        ComponentHierarchy componentHierarchy = this.hierarchy;
        if (componentHierarchy == null) {
            BasicComponentPrinter.$$$reportNull$$$0(4);
        }
        return componentHierarchy;
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out) {
        if (out == null) {
            BasicComponentPrinter.$$$reportNull$$$0(5);
        }
        this.printComponents(out, ALWAYS_MATCHES);
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out, @Nullable Container root) {
        if (out == null) {
            BasicComponentPrinter.$$$reportNull$$$0(6);
        }
        this.printComponents(out, ALWAYS_MATCHES, root);
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out, @Nonnull Class<? extends Component> type) {
        if (out == null) {
            BasicComponentPrinter.$$$reportNull$$$0(7);
        }
        if (type == null) {
            BasicComponentPrinter.$$$reportNull$$$0(8);
        }
        this.printComponents(out, type, null);
    }

    @Override
    @RunsInEDT
    public void printComponents(@Nonnull PrintStream out, @Nonnull Class<? extends Component> type, @Nullable Container root) {
        if (out == null) {
            BasicComponentPrinter.$$$reportNull$$$0(9);
        }
        if (type == null) {
            BasicComponentPrinter.$$$reportNull$$$0(10);
        }
        BasicComponentPrinter.print(this.hierarchy(root), new TypeMatcher((Class)Preconditions.checkNotNull(type)), (PrintStream)Preconditions.checkNotNull((Object)out));
    }

    @Override
    public void printComponents(@Nonnull PrintStream out, @Nonnull ComponentMatcher matcher) {
        if (out == null) {
            BasicComponentPrinter.$$$reportNull$$$0(11);
        }
        if (matcher == null) {
            BasicComponentPrinter.$$$reportNull$$$0(12);
        }
        this.printComponents(out, matcher, null);
    }

    @Override
    public void printComponents(@Nonnull PrintStream out, @Nonnull ComponentMatcher matcher, @Nullable Container root) {
        if (out == null) {
            BasicComponentPrinter.$$$reportNull$$$0(13);
        }
        if (matcher == null) {
            BasicComponentPrinter.$$$reportNull$$$0(14);
        }
        BasicComponentPrinter.print(this.hierarchy(root), (ComponentMatcher)Preconditions.checkNotNull((Object)matcher), (PrintStream)Preconditions.checkNotNull((Object)out));
    }

    @Nonnull
    private ComponentHierarchy hierarchy(@Nullable Container root) {
        ComponentHierarchy componentHierarchy = root != null ? new SingleComponentHierarchy(root, this.hierarchy) : this.hierarchy;
        if (componentHierarchy == null) {
            BasicComponentPrinter.$$$reportNull$$$0(15);
        }
        return componentHierarchy;
    }

    @RunsInEDT
    private static void print(final @Nonnull ComponentHierarchy hierarchy, final @Nonnull ComponentMatcher matcher, final @Nonnull PrintStream out) {
        if (hierarchy == null) {
            BasicComponentPrinter.$$$reportNull$$$0(16);
        }
        if (matcher == null) {
            BasicComponentPrinter.$$$reportNull$$$0(17);
        }
        if (out == null) {
            BasicComponentPrinter.$$$reportNull$$$0(18);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                for (Component component : hierarchy.roots()) {
                    BasicComponentPrinter.print((Component)Preconditions.checkNotNull((Object)component), hierarchy, matcher, 0, out);
                }
            }
        });
    }

    @RunsInCurrentThread
    private static void print(@Nonnull Component c, @Nonnull ComponentHierarchy h, @Nonnull ComponentMatcher matcher, int level, @Nonnull PrintStream out) {
        if (c == null) {
            BasicComponentPrinter.$$$reportNull$$$0(19);
        }
        if (h == null) {
            BasicComponentPrinter.$$$reportNull$$$0(20);
        }
        if (matcher == null) {
            BasicComponentPrinter.$$$reportNull$$$0(21);
        }
        if (out == null) {
            BasicComponentPrinter.$$$reportNull$$$0(22);
        }
        if (matcher.matches(c)) {
            BasicComponentPrinter.print(c, level, out);
        }
        for (Component child : h.childrenOf(c)) {
            BasicComponentPrinter.print((Component)Preconditions.checkNotNull((Object)child), h, matcher, level + 1, out);
        }
    }

    @RunsInCurrentThread
    private static void print(@Nonnull Component c, int level, @Nonnull PrintStream out) {
        if (c == null) {
            BasicComponentPrinter.$$$reportNull$$$0(23);
        }
        if (out == null) {
            BasicComponentPrinter.$$$reportNull$$$0(24);
        }
        for (int i = 0; i < level; ++i) {
            out.print(INDENTATION);
        }
        out.println(Formatting.format(c));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/core/BasicComponentPrinter";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchy";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysMatches";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "printerWithNewAwtHierarchy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "printerWithCurrentAwtHierarchy";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/core/BasicComponentPrinter";
                break;
            }
            case 4: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "hierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "printComponents";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

