/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;

class ContainerFocusOwnerFinder {
    ContainerFocusOwnerFinder() {
    }

    @Nullable
    @RunsInCurrentThread
    Component focusOwnerOf(@Nullable Container c) {
        if (!(c instanceof Window)) {
            return null;
        }
        return this.focusOwnerOf((Window)c);
    }

    @Nullable
    @RunsInCurrentThread
    private Component focusOwnerOf(@Nonnull Window w) {
        if (w == null) {
            ContainerFocusOwnerFinder.$$$reportNull$$$0(0);
        }
        if (!w.isShowing()) {
            return null;
        }
        Component focus = w.getFocusOwner();
        if (focus != null) {
            return focus;
        }
        for (Window o : w.getOwnedWindows()) {
            focus = o.getFocusOwner();
            if (focus == null) continue;
            return focus;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "w", "org/fest/swing/core/ContainerFocusOwnerFinder", "focusOwnerOf"));
    }
}

