/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JApplet;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JAppletDriver
extends ComponentDriver
implements AppletStub {
    private JApplet applet;

    public JAppletDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JAppletDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    public JAppletDriver(@Nonnull Robot robot, @Nonnull JApplet newApplet) {
        if (robot == null) {
            JAppletDriver.$$$reportNull$$$0(1);
        }
        if (newApplet == null) {
            JAppletDriver.$$$reportNull$$$0(2);
        }
        this(robot);
        this.applet = newApplet;
    }

    @RunsInEDT
    private static void doResize(final @Nonnull JApplet applet, final int width, final int height) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(3);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                applet.resize(width, height);
            }
        });
    }

    @Nullable
    @RunsInEDT
    private static URL codeBase(final @Nonnull JApplet applet) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(4);
        }
        return GuiActionRunner.execute(new GuiQuery<URL>(){

            @Override
            @Nullable
            protected URL executeInEDT() {
                return applet.getCodeBase();
            }
        });
    }

    @Nullable
    @RunsInEDT
    private static URL documentBase(final @Nonnull JApplet applet) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(5);
        }
        return GuiActionRunner.execute(new GuiQuery<URL>(){

            @Override
            protected URL executeInEDT() {
                return applet.getDocumentBase();
            }
        });
    }

    @Nullable
    @RunsInEDT
    private static String parameter(final @Nonnull JApplet applet, final @Nullable String parameterName) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(6);
        }
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            @Nullable
            protected String executeInEDT() {
                return applet.getParameter(parameterName);
            }
        });
    }

    @RunsInEDT
    private static boolean active(final @Nonnull JApplet applet) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(7);
        }
        Boolean result = GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            @Nullable
            protected Boolean executeInEDT() {
                return applet.isActive();
            }
        });
        return (Boolean)Preconditions.checkNotNull((Object)result);
    }

    @Override
    @RunsInEDT
    public void appletResize(int width, int height) {
        this.appletResize(this.applet, width, height);
    }

    @RunsInEDT
    public void appletResize(@Nonnull JApplet applet, int width, int height) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(8);
        }
        JAppletDriver.doResize(applet, width, height);
    }

    @Override
    @RunsInEDT
    public AppletContext getAppletContext() {
        return this.getAppletContext(this.applet);
    }

    @RunsInEDT
    public AppletContext getAppletContext(JApplet applet) {
        return JAppletDriver.appletContext(applet);
    }

    @Nullable
    @RunsInEDT
    private static AppletContext appletContext(final @Nonnull JApplet applet) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(9);
        }
        return GuiActionRunner.execute(new GuiQuery<AppletContext>(){

            @Override
            @Nullable
            protected AppletContext executeInEDT() {
                return applet.getAppletContext();
            }
        });
    }

    @Override
    @Nullable
    @RunsInEDT
    public URL getCodeBase() {
        return this.getCodeBase(this.applet);
    }

    @Nullable
    @RunsInEDT
    public URL getCodeBase(@Nonnull JApplet applet) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(10);
        }
        return JAppletDriver.codeBase(applet);
    }

    @Override
    @Nullable
    @RunsInEDT
    public URL getDocumentBase() {
        return this.getDocumentBase(this.applet);
    }

    @Nullable
    @RunsInEDT
    public URL getDocumentBase(@Nonnull JApplet applet) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(11);
        }
        return JAppletDriver.documentBase(applet);
    }

    @Override
    @Nullable
    @RunsInEDT
    public String getParameter(@Nullable String name) {
        return this.getParameter(this.applet, name);
    }

    @RunsInEDT
    public String getParameter(@Nonnull JApplet applet, @Nullable String name) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(12);
        }
        return JAppletDriver.parameter(applet, name);
    }

    @Override
    @RunsInEDT
    public boolean isActive() {
        return this.isActive(this.applet);
    }

    @RunsInEDT
    public boolean isActive(@Nonnull JApplet applet) {
        if (applet == null) {
            JAppletDriver.$$$reportNull$$$0(13);
        }
        return JAppletDriver.active(applet);
    }

    @RunsInEDT
    public Applet getApplet(@Nonnull String name) {
        if (name == null) {
            JAppletDriver.$$$reportNull$$$0(14);
        }
        return this.applet.getAppletContext().getApplet(name);
    }

    @Nonnull
    @RunsInEDT
    public Enumeration<Applet> getApplets() {
        Enumeration<Applet> applets = this.applet.getAppletContext().getApplets();
        Enumeration<Applet> enumeration = applets != null ? applets : Collections.enumeration(Collections.emptyList());
        if (enumeration == null) {
            JAppletDriver.$$$reportNull$$$0(15);
        }
        return enumeration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newApplet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applet";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JAppletDriver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JAppletDriver";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doResize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "codeBase";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "documentBase";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parameter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "active";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appletResize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appletContext";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCodeBase";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentBase";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getApplet";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

