/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.IntAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJComboBoxCellReader;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComboBoxContentQuery;
import org.fest.swing.driver.JComboBoxDropDownListFinder;
import org.fest.swing.driver.JComboBoxEditableQuery;
import org.fest.swing.driver.JComboBoxItemCountQuery;
import org.fest.swing.driver.JComboBoxItemIndexPreconditions;
import org.fest.swing.driver.JComboBoxMatchingItemQuery;
import org.fest.swing.driver.JComboBoxSelectedIndexQuery;
import org.fest.swing.driver.JComboBoxSelectionValueQuery;
import org.fest.swing.driver.JComboBoxSetSelectedIndexTask;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JListDriver;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Arrays;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

@InternalApi
public class JComboBoxDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private final JListDriver listDriver;
    private final JComboBoxDropDownListFinder dropDownListFinder;
    private JComboBoxCellReader cellReader;

    public JComboBoxDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JComboBoxDriver.$$$reportNull$$$0(0);
        }
        super(robot);
        this.listDriver = new JListDriver(robot);
        this.dropDownListFinder = new JComboBoxDropDownListFinder(robot);
        this.replaceCellReader(new BasicJComboBoxCellReader());
    }

    @Nonnull
    @RunsInEDT
    public String[] contentsOf(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(1);
        }
        String[] stringArray = JComboBoxContentQuery.contents(comboBox, this.cellReader());
        if (stringArray == null) {
            JComboBoxDriver.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @RunsInEDT
    public void selectItem(@Nonnull JComboBox comboBox, @Nullable String value) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(3);
        }
        this.selectItem(comboBox, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void selectItem(@Nonnull JComboBox comboBox, @Nonnull Pattern pattern) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            JComboBoxDriver.$$$reportNull$$$0(5);
        }
        this.selectItem(comboBox, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectItem(@Nonnull JComboBox comboBox, @Nonnull TextMatcher matcher) {
        int index;
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(6);
        }
        if (matcher == null) {
            JComboBoxDriver.$$$reportNull$$$0(7);
        }
        if ((index = JComboBoxMatchingItemQuery.matchingItemIndex(comboBox, matcher, this.cellReader())) < 0) {
            String format = "Unable to find item matching %s among the JComboBox contents: ";
            String msg = String.format(format, matcher.description(), Arrays.format((Object)this.contentsOf(comboBox)));
            throw new LocationUnavailableException(msg);
        }
        this.selectItem(comboBox, index);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JComboBox comboBox, @Nullable String value) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(8);
        }
        String selection = this.requiredSelectionOf(comboBox);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(comboBox)).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JComboBox comboBox, @Nonnull Pattern pattern) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(9);
        }
        if (pattern == null) {
            JComboBoxDriver.$$$reportNull$$$0(10);
        }
        String selection = this.requiredSelectionOf(comboBox);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(comboBox)).matches(pattern);
    }

    @Nullable
    @RunsInEDT
    private String requiredSelectionOf(@Nonnull JComboBox comboBox) throws AssertionError {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(11);
        }
        Pair<Boolean, String> selection = JComboBoxSelectionValueQuery.selection(comboBox, this.cellReader());
        boolean hasSelection = (Boolean)selection.first;
        if (!hasSelection) {
            throw this.failNoSelection(comboBox);
        }
        return (String)selection.second;
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JComboBox comboBox, int index) {
        int selectedIndex;
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(12);
        }
        if ((selectedIndex = JComboBoxSelectedIndexQuery.selectedIndexOf(comboBox)) == -1) {
            this.failNoSelection(comboBox);
        }
        ((IntAssert)Assertions.assertThat((int)selectedIndex).as(this.selectedIndexProperty(comboBox))).isEqualTo(index);
    }

    @Nonnull
    private AssertionError failNoSelection(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(13);
        }
        throw Fail.fail((String)String.format("[%s] No selection", this.selectedIndexProperty(comboBox).value()));
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(14);
        }
        Pair<Boolean, String> selection = JComboBoxSelectionValueQuery.selection(comboBox, this.cellReader());
        boolean hasSelection = (Boolean)selection.first;
        if (!hasSelection) {
            return;
        }
        String format = "[%s] Expecting no selection, but found:<%s>";
        Fail.fail((String)String.format(format, this.selectedIndexProperty(comboBox).value(), Strings.quote((String)((String)selection.second))));
    }

    @Nullable
    public String value(@Nonnull JComboBox comboBox, int index) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(15);
        }
        return JComboBoxDriver.valueAsText(comboBox, index, this.cellReader());
    }

    @Nullable
    @RunsInEDT
    private static String valueAsText(final @Nonnull JComboBox comboBox, final int index, final @Nonnull JComboBoxCellReader cellReader) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(16);
        }
        if (cellReader == null) {
            JComboBoxDriver.$$$reportNull$$$0(17);
        }
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            @Nullable
            protected String executeInEDT() {
                JComboBoxItemIndexPreconditions.checkItemIndexInBounds(comboBox, index);
                return cellReader.valueAt(comboBox, index);
            }
        });
    }

    @Nonnull
    private Description selectedIndexProperty(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(18);
        }
        Description description = JComboBoxDriver.propertyName(comboBox, SELECTED_INDEX_PROPERTY);
        if (description == null) {
            JComboBoxDriver.$$$reportNull$$$0(19);
        }
        return description;
    }

    public void clearSelection(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(20);
        }
        JComboBoxSetSelectedIndexTask.setSelectedIndex(comboBox, -1);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectItem(@Nonnull JComboBox comboBox, int index) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(21);
        }
        JComboBoxDriver.validateCanSelectItem(comboBox, index);
        this.showDropDownList(comboBox);
        this.selectItemAtIndex(comboBox, index);
        this.hideDropDownListIfVisible(comboBox);
    }

    @RunsInEDT
    private static void validateCanSelectItem(final @Nonnull JComboBox comboBox, final int index) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(22);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(comboBox);
                JComboBoxItemIndexPreconditions.checkItemIndexInBounds(comboBox, index);
            }
        });
    }

    @VisibleForTesting
    @RunsInEDT
    void showDropDownList(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(23);
        }
        this.dropDownVisibleThroughUIDelegate(comboBox, true);
    }

    @RunsInEDT
    private void selectItemAtIndex(@Nonnull JComboBox comboBox, int index) {
        JList dropDownList;
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(24);
        }
        if ((dropDownList = this.dropDownListFinder.findDropDownList()) != null) {
            this.listDriver.selectItem(dropDownList, index);
            return;
        }
        JComboBoxSetSelectedIndexTask.setSelectedIndex(comboBox, index);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private void hideDropDownListIfVisible(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(25);
        }
        this.dropDownVisibleThroughUIDelegate(comboBox, false);
    }

    @RunsInEDT
    private void dropDownVisibleThroughUIDelegate(final @Nonnull JComboBox comboBox, final boolean visible) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(26);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                comboBox.setPopupVisible(visible);
            }
        });
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void replaceText(@Nonnull JComboBox comboBox, @Nonnull String text) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(27);
        }
        if (text == null) {
            JComboBoxDriver.$$$reportNull$$$0(28);
        }
        this.selectAllText(comboBox);
        this.enterText(comboBox, text);
    }

    @RunsInEDT
    public void selectAllText(@Nonnull JComboBox comboBox) {
        Component editor;
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(29);
        }
        if (!((editor = JComboBoxDriver.accessibleEditorOf(comboBox)) instanceof JComponent)) {
            return;
        }
        this.focus(editor);
        this.invokeAction((JComponent)editor, "select-all");
    }

    @Nullable
    @RunsInEDT
    private static Component accessibleEditorOf(final @Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(30);
        }
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            @Nullable
            protected Component executeInEDT() {
                JComboBoxDriver.checkAccessibleEditor(comboBox);
                return JComboBoxDriver.editorComponentOf(comboBox);
            }
        });
    }

    @RunsInEDT
    public void enterText(final @Nonnull JComboBox comboBox, @Nonnull String text) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(31);
        }
        if (text == null) {
            JComboBoxDriver.$$$reportNull$$$0(32);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JComboBoxDriver.checkAccessibleEditor(comboBox);
            }
        });
        Component editor = JComboBoxDriver.editorComponentOf(comboBox);
        if (editor == null) {
            throw ActionFailedException.actionFailure("JComboBox does not have an editor");
        }
        this.focusAndWaitForFocusGain(editor);
        this.robot.enterText(text);
    }

    @RunsInEDT
    public void pressAndReleaseKeys(@Nonnull JComboBox comboBox, int ... keyCodes) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(33);
        }
        if (keyCodes == null) {
            JComboBoxDriver.$$$reportNull$$$0(34);
        }
        Preconditions.checkNotNull((Object)keyCodes);
        JComboBoxDriver.checkInEdtEnabledAndShowing(comboBox);
        Component target = JComboBoxDriver.editorIfEditable(comboBox);
        if (target == null) {
            target = comboBox;
        }
        this.focusAndWaitForFocusGain(target);
        this.robot.pressAndReleaseKeys(keyCodes);
    }

    @RunsInEDT
    private static Component editorIfEditable(final JComboBox comboBox) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            protected Component executeInEDT() {
                if (!comboBox.isEditable()) {
                    return null;
                }
                return JComboBoxDriver.editorComponent(comboBox);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkAccessibleEditor(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(35);
        }
        ComponentPreconditions.checkEnabledAndShowing(comboBox);
        if (!comboBox.isEditable()) {
            String msg = String.format("Expecting component %s to be editable", Formatting.format(comboBox));
            throw new IllegalStateException(msg);
        }
    }

    @Nullable
    @RunsInEDT
    private static Component editorComponentOf(final @Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(36);
        }
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            @Nullable
            protected Component executeInEDT() {
                return JComboBoxDriver.editorComponent(comboBox);
            }
        });
    }

    @Nullable
    @RunsInCurrentThread
    private static Component editorComponent(@Nonnull JComboBox comboBox) {
        ComboBoxEditor editor;
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(37);
        }
        if ((editor = comboBox.getEditor()) == null) {
            return null;
        }
        return editor.getEditorComponent();
    }

    @Nonnull
    @RunsInEDT
    public JList dropDownList() {
        JList list = this.dropDownListFinder.findDropDownList();
        if (list == null) {
            throw new ComponentLookupException("Unable to find the pop-up list for the JComboBox");
        }
        JList jList = list;
        if (jList == null) {
            JComboBoxDriver.$$$reportNull$$$0(38);
        }
        return jList;
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(39);
        }
        this.checkEditable(comboBox, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(40);
        }
        this.checkEditable(comboBox, false);
    }

    @RunsInEDT
    private void checkEditable(@Nonnull JComboBox comboBox, boolean expected) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(41);
        }
        ((BooleanAssert)Assertions.assertThat((boolean)JComboBoxEditableQuery.isEditable(comboBox)).as(JComboBoxDriver.editableProperty(comboBox))).isEqualTo(expected);
    }

    @RunsInEDT
    private static Description editableProperty(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(42);
        }
        return JComboBoxDriver.propertyName(comboBox, EDITABLE_PROPERTY);
    }

    public void replaceCellReader(@Nonnull JComboBoxCellReader newCellReader) {
        if (newCellReader == null) {
            JComboBoxDriver.$$$reportNull$$$0(43);
        }
        this.cellReader = (JComboBoxCellReader)Preconditions.checkNotNull((Object)newCellReader);
    }

    @RunsInEDT
    public void requireItemCount(@Nonnull JComboBox comboBox, int expected) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(44);
        }
        int actual = JComboBoxItemCountQuery.itemCountIn(comboBox);
        ((IntAssert)Assertions.assertThat((int)actual).as(JComboBoxDriver.propertyName(comboBox, "itemCount"))).isEqualTo(expected);
    }

    @Nullable
    public String selectedItemOf(@Nonnull JComboBox comboBox) {
        if (comboBox == null) {
            JComboBoxDriver.$$$reportNull$$$0(45);
        }
        return (String)JComboBoxSelectionValueQuery.selection((JComboBox)comboBox, (JComboBoxCellReader)this.cellReader()).second;
    }

    @Nonnull
    private JComboBoxCellReader cellReader() {
        JComboBoxCellReader jComboBoxCellReader = this.cellReader;
        if (jComboBoxCellReader == null) {
            JComboBoxDriver.$$$reportNull$$$0(46);
        }
        return jComboBoxCellReader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 19: 
            case 38: 
            case 46: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 19: 
            case 38: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 2: 
            case 19: 
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JComboBoxDriver";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyCodes";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCellReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JComboBoxDriver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsOf";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedIndexProperty";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "dropDownList";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "cellReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contentsOf";
                break;
            }
            case 2: 
            case 19: 
            case 38: 
            case 46: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "requireSelection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "requiredSelectionOf";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "failNoSelection";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "requireNoSelection";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "value";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "valueAsText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "selectedIndexProperty";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "clearSelection";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "validateCanSelectItem";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showDropDownList";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "selectItemAtIndex";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hideDropDownListIfVisible";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "dropDownVisibleThroughUIDelegate";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "selectAllText";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "accessibleEditorOf";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "enterText";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "pressAndReleaseKeys";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkAccessibleEditor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "editorComponentOf";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "editorComponent";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "requireEditable";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "requireNotEditable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkEditable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "editableProperty";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "replaceCellReader";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "requireItemCount";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "selectedItemOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 19: 
            case 38: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

