/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.edt;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.fest.util.Preconditions;

abstract class CheckThreadViolationRepaintManager
extends RepaintManager {
    private final boolean completeCheck;
    private WeakReference<JComponent> lastComponent;

    CheckThreadViolationRepaintManager() {
        this(true);
    }

    CheckThreadViolationRepaintManager(boolean completeCheck) {
        this.completeCheck = completeCheck;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent component) {
        this.checkThreadViolations((JComponent)Preconditions.checkNotNull((Object)component));
        super.addInvalidComponent(component);
    }

    @Override
    public void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        this.checkThreadViolations((JComponent)Preconditions.checkNotNull((Object)component));
        super.addDirtyRegion(component, x, y, w, h);
    }

    private void checkThreadViolations(@Nonnull JComponent c) {
        if (c == null) {
            CheckThreadViolationRepaintManager.$$$reportNull$$$0(0);
        }
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || c.isShowing())) {
            StackTraceElement[] stackTrace;
            boolean imageUpdate = false;
            boolean repaint = false;
            boolean fromSwing = false;
            for (StackTraceElement st : stackTrace = Thread.currentThread().getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(st.getMethodName())) {
                    imageUpdate = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
                fromSwing = false;
            }
            if (imageUpdate) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (this.lastComponent != null && c == this.lastComponent.get()) {
                return;
            }
            this.lastComponent = new WeakReference<JComponent>(c);
            this.violationFound(c, stackTrace);
        }
    }

    abstract void violationFound(@Nonnull JComponent var1, @Nonnull StackTraceElement[] var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "c", "org/fest/swing/edt/CheckThreadViolationRepaintManager", "checkThreadViolations"));
    }
}

