/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.awt.AWT;
import org.fest.swing.hierarchy.ChildrenFinder;
import org.fest.swing.hierarchy.ParentFinder;
import org.fest.util.Maps;

class WindowFilter {
    private final ParentFinder parentFinder;
    private final ChildrenFinder childrenFinder;
    final Map<Component, Boolean> ignored;
    final Map<Component, Boolean> implicitlyIgnored;

    WindowFilter() {
        this(new ParentFinder(), new ChildrenFinder());
    }

    WindowFilter(@Nonnull ParentFinder parentFinder, @Nonnull ChildrenFinder childrenFinder) {
        if (parentFinder == null) {
            WindowFilter.$$$reportNull$$$0(0);
        }
        if (childrenFinder == null) {
            WindowFilter.$$$reportNull$$$0(1);
        }
        this.ignored = Maps.newWeakHashMap();
        this.implicitlyIgnored = Maps.newWeakHashMap();
        this.parentFinder = parentFinder;
        this.childrenFinder = childrenFinder;
    }

    boolean isImplicitlyIgnored(@Nonnull Component c) {
        if (c == null) {
            WindowFilter.$$$reportNull$$$0(2);
        }
        return this.implicitlyIgnored.containsKey(c);
    }

    @RunsInCurrentThread
    boolean isIgnored(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        if (this.ignored.containsKey(c)) {
            return true;
        }
        if (c instanceof Window && this.isIgnored(c.getParent())) {
            return true;
        }
        return !(c instanceof Window) && this.isWindowIgnored(c);
    }

    private boolean isWindowIgnored(@Nullable Component c) {
        Window w = this.parentFinder.windowFor(c);
        return w != null && this.isIgnored(w);
    }

    void implicitlyIgnore(@Nonnull Component c) {
        if (c == null) {
            WindowFilter.$$$reportNull$$$0(3);
        }
        this.implicitlyIgnored.put(c, true);
    }

    @RunsInCurrentThread
    void ignore(@Nonnull Component c) {
        if (c == null) {
            WindowFilter.$$$reportNull$$$0(4);
        }
        this.filter(c, true);
    }

    @RunsInCurrentThread
    void recognize(@Nonnull Component c) {
        if (c == null) {
            WindowFilter.$$$reportNull$$$0(5);
        }
        this.filter(c, false);
    }

    @Nonnull
    Collection<Component> filtered() {
        Set<Component> set = this.ignored.keySet();
        if (set == null) {
            WindowFilter.$$$reportNull$$$0(6);
        }
        return set;
    }

    private void filter(@Nonnull Component c, boolean ignore) {
        if (c == null) {
            WindowFilter.$$$reportNull$$$0(7);
        }
        if (AWT.isSharedInvisibleFrame(c)) {
            for (Component child : this.childrenFinder.childrenOf(c)) {
                this.filter(child, ignore);
            }
            return;
        }
        this.doFilter(c, ignore);
        this.implicitlyIgnored.remove(c);
        if (!(c instanceof Window)) {
            return;
        }
        for (Window owned : ((Window)c).getOwnedWindows()) {
            if (owned == null) continue;
            this.filter(owned, ignore);
        }
    }

    private void doFilter(@Nonnull Component c, boolean ignore) {
        if (c == null) {
            WindowFilter.$$$reportNull$$$0(8);
        }
        if (ignore) {
            this.ignored.put(c, true);
            return;
        }
        this.ignored.remove(c);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFinder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenFinder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/hierarchy/WindowFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/hierarchy/WindowFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filtered";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitlyIgnored";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "implicitlyIgnore";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ignore";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "recognize";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

